/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.common.ability.domain.repo.data;

import cn.com.yusys.yusp.pay.common.ability.domain.constant.EComOutType;
import cn.com.yusys.yusp.pay.common.ability.domain.vo.UpPOuttrademapVo;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.util.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public abstract class ExchangeRepo {
    @Autowired
    @Qualifier(value="remoteRestTemplate")
    public RestTemplate restTemplate;
    @Value(value="${bsp.rioOut.hostip:nmgnx.tencent.com}")
    private String hostip;

    public YuinResult exchangeOutAdapter(Map<String, Object> info, UpPOuttrademapVo uiPOuttrademapVo) throws Exception {
        try {
            String url = "http://" + this.hostip;
            if (StringUtils.isNotEmpty((String)uiPOuttrademapVo.getSvcurl())) {
                url = url + uiPOuttrademapVo.getSvcurl();
            }
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            String send = info.getOrDefault("send", "").toString();
            HttpEntity requestEntity = new HttpEntity((Object)send, (MultiValueMap)httpHeaders);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, JSONObject.class, new Object[0]);
            HttpStatus status = responseEntity.getStatusCode();
            String code = JSON.toJSONString((Object)status.value());
            if ("200".equals(code)) {
                JSONObject objectMap = new HashMap();
                if (responseEntity.getBody() != null) {
                    JSONObject obj = (JSONObject)responseEntity.getBody();
                    objectMap = JSON.parseObject((String)JSONUtil.trim((String)obj.toJSONString(), (int)1));
                    info.putAll((Map<String, Object>)objectMap);
                }
                return YuinResult.newSuccessResult((Object[])new Object[]{objectMap});
            }
            return YuinResult.newFailureResult((String)"E8199", (String)EComOutType.ERR_OUT.getName());
        }
        catch (Exception e) {
            String errcode = info.getOrDefault("G_RET_CODE", "E8199").toString();
            e.printStackTrace();
            String message = e.getMessage();
            if (message.contains("timed out")) {
                return YuinResult.newFailureResult((String)"E8103", (String)EComOutType.ERR_OUT_TIME.getName());
            }
            return YuinResult.newFailureResult((String)"E8199", (String)EComOutType.ERR_OUT.getName());
        }
    }
}

