/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g30;

import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.TradeInitService;
import cn.com.yusys.yusp.payment.common.flow.domain.constant.ErrorCode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP30311SubService {
    @Autowired
    private TradeInitService tradeInitService;
    @Autowired
    private TradeOperDbService tradeOperDbService;

    public YuinResult queryHandler(JavaDict request) {
        if (request.hasKey("startdate") && request.hasKey("stopdate")) {
            int distance = this.dateDiffDays(request.getString("startdate"), request.getString("stopdate"));
            request.set("returnint", (Object)distance);
            if (distance >= 30) {
                return YuinResult.newFailureResult((String)"E0399", (String)ErrorCode.getErrmsg((String)"E0399"));
            }
        }
        return this.queryInfo(request);
    }

    public YuinResult queryInfo(JavaDict request) {
        try {
            YuinResultDto selResult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), "sel_bupbteleacct");
            if (!selResult.isSuccess()) {
                return YuinResult.newFailureResult((String)"S9400", (String)"operDbaction failed");
            }
            List selResultList = (List)selResult.getBody();
            if (selResultList.size() > 50) {
                return YuinResult.newFailureResult((String)"E0399", (String)ErrorCode.getErrmsg((String)"E0399"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public int dateDiffDays(String strBeginDate, String strEndDate) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            Date startDate = dateFormat.parse(strBeginDate);
            Date endDate = dateFormat.parse(strEndDate);
            Long diffTimes = endDate.getTime() - startDate.getTime();
            return (int)(diffTimes / 24L / 60L / 60L / 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

