/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.domain.service.pub;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.center.ability.domain.service.func.HostDealCommonService;
import cn.com.yusys.yusp.pay.center.busideal.dao.po.UpBMsgmangePo;
import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpBMsgmangeRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpDLimitadmRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpMChkvrfyRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpMTranjnlRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.data.UpDMsgtypemapService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpBMsgmangeVo;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpDLimitadmVo;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpMChkvrfyVo;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpMTranjnlVo;
import cn.com.yusys.yusp.pay.sign.client.dto.ProtoChangeReqDto;
import cn.com.yusys.yusp.pay.sign.client.dto.ProtoSignReqDto;
import cn.com.yusys.yusp.pay.sign.client.inter.PaySignClient;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.service.UpPDictService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.YuinBeanUtil;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.payment.common.component.parm.dao.po.UpPBankmapPo;
import cn.com.yusys.yusp.payment.common.component.parm.domain.repo.UpPBankmapRepo;
import cn.com.yusys.yusp.payment.common.component.parm.domain.vo.UpPBankmapQueryVo;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBrnoBankInfoGetService;
import cn.com.yusys.yusp.payment.common.flow.domain.constant.ECorpStatus;
import cn.com.yusys.yusp.payment.common.flow.domain.tools.Tools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UPPGetService {
    @Autowired
    private UpPDictService upPDictService;
    @Autowired
    private UpPBrnoBankInfoGetService upPBrnoBankInfoGetService;
    @Autowired
    private UpDMsgtypemapService upDMsgtypemapService;
    @Autowired
    private TradeOperDbService tradeOperDbService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UpBMsgmangeRepo upBMsgmangeRepo;
    @Resource
    private UpPBankinfoService uppBankinfoService;
    @Autowired
    private UpPBankmapRepo upPBankmapRepo;
    @Autowired
    private UPPChkService uPPChkService;
    @Resource
    private UpMTranjnlRepo upMTranjnlRepo;
    @Resource
    private HostDealCommonService hostDealCommonService;
    @Resource
    private UpDLimitadmRepo upDLimitadmRepo;
    @Resource
    private UpMChkvrfyRepo upMChkvrfyRepo;
    @Resource
    private PaySignClient paySignClient;

    public YuinResult getDictMap(JavaDict javaDict, String dictInfo, String outStr) {
        YuinResult result = this.upPDictService.getDictValue2ByKey(javaDict, dictInfo);
        if (!result.isSuccess()) {
            YuinLogUtils.getInst((Object)this).info("{}|{}-{}", new Object[]{javaDict.get("logPrefix"), outStr, result.getErrorMsg()});
            return YuinResult.newFailureResult((String)result.getErrorCode(), (String)result.getErrorMsg());
        }
        YuinLogUtils.getInst((Object)this).info("{}|[{}]|[{}]", new Object[]{javaDict.get("logPrefix"), outStr, result.getOutputParams().get(0)});
        javaDict.set(outStr, result.getOutputParams().get(0));
        return YuinResult.newSuccessResult(null);
    }

    public String getDictKeyValue(JavaDict javaDict, String dictInfo, String key) {
        YuinResult result = this.upPDictService.getDictValue2ByKey(javaDict, dictInfo);
        if (result.isSuccess()) {
            return String.format("%s-%s", key, result.getOutputParams().get(0));
        }
        return String.format("%s", key);
    }

    public YuinResult getRealTradeAmt(JavaDict javaDict, String[] listInPara, String[] listOutPara) {
        BigDecimal initAmt = new BigDecimal(0.0);
        for (String inParm : listInPara) {
            javaDict.set(inParm, (Object)javaDict.getBigDecimal(inParm, initAmt));
        }
        if (listInPara.length < 2) {
            return YuinResult.newFailureResult((String)"S9001", (String)"\u5b9e\u9645\u4ea4\u6613\u91d1\u989d\u81f3\u5c11\u5305\u542b\u4ea4\u6613\u91d1\u989d\u53ca\u624b\u7eed\u8d39\u91d1\u989d");
        }
        if (listInPara.length == 3) {
            YuinLogUtils.getInst((Object)this).info("{}|\u4ea4\u6613\u91d1\u989d: {} \u624b\u7eed\u8d39: {} \u5de5\u672c\u8d39: {}", new Object[]{javaDict.get("logPrefix"), javaDict.get(listInPara[0]), javaDict.get(listInPara[1]), javaDict.get(listInPara[2])});
        } else {
            YuinLogUtils.getInst((Object)this).info("{}|\u4ea4\u6613\u91d1\u989d: {} \u624b\u7eed\u8d39: {}", new Object[]{javaDict.get("logPrefix"), javaDict.get(listInPara[0]), javaDict.get(listInPara[1])});
        }
        if (listOutPara.length < 1) {
            return YuinResult.newFailureResult((String)"S9001", (String)"\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u51fa\u53c2\u53d8\u91cf");
        }
        if ("1".equals(javaDict.getString("mbflag")) && javaDict.getBigDecimal(listInPara[0]).compareTo(initAmt) == 0) {
            return YuinResult.newFailureResult((String)"S9002", (String)"\u5f80\u8d26\u4ea4\u6613\u91d1\u989d\u4e0d\u80fd\u4e3a0");
        }
        if (javaDict.getBigDecimal(listInPara[0]).compareTo(initAmt) < 0) {
            return YuinResult.newFailureResult((String)"O1022", (String)"\u4ea4\u6613\u91d1\u989d\u975e\u6cd5");
        }
        BigDecimal realTradeAmt = javaDict.getBigDecimal(listInPara[0]).add(javaDict.getBigDecimal(listInPara[1]));
        if (listInPara.length == 3) {
            realTradeAmt = realTradeAmt.add(javaDict.getBigDecimal(listInPara[2]));
        }
        javaDict.set(listOutPara[0], (Object)realTradeAmt);
        YuinLogUtils.getInst((Object)this).info("{}|\u5b9e\u9645\u4ea4\u6613\u91d1\u989d: [{}][{}]", new Object[]{javaDict.get("logPrefix"), listOutPara[0], realTradeAmt});
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getAcctBankInfo(JavaDict javaDict, String accbrno, String[] banknameList) {
        YuinResult result = null;
        if (StringUtils.isBlank((CharSequence)accbrno)) {
            return YuinResult.newFailureResult((String)"S9001", (String)"\u5f00\u6237\u673a\u6784\u53f7\u4e0d\u5b58\u5728");
        }
        try {
            result = this.upPBrnoBankInfoGetService.getAcctBankInfoByBrno(javaDict, accbrno, banknameList);
            if (!result.isSuccess()) {
                return result;
            }
            JavaDict valueDict = (JavaDict)result.getOutputParams().get(0);
            Tools.printKeyValue((Object)this, (String)javaDict.getString("logPrefix", ""), (JavaDict)valueDict);
            javaDict.set((IDict)valueDict);
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"S9001", (String)"\u5f00\u6237\u884c\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getMsgtypeMap(JavaDict javaDict) {
        if ("2".equals(javaDict.getString("sysflag"))) {
            return YuinResult.newSuccessResult(null);
        }
        YuinResult result = this.upDMsgtypemapService.getMsgtypeMap(javaDict);
        if (!result.isSuccess()) {
            return result;
        }
        String mapmsgtype = ((JavaDict)result.getOutputParams().get(0)).getString("mapmsgtype");
        javaDict.set("__sendmsgtype__", (Object)mapmsgtype);
        YuinLogUtils.getInst((Object)this).info("{}|\u4e00\u4e8c\u4ee3\u62a5\u6587\u6620\u5c04\u7c7b\u578b\u8f6c\u6362[{}]|[{}]", new Object[]{javaDict.get("logPrefix"), "__sendmsgtype__", mapmsgtype});
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCityCodeNew(JavaDict javaDict, String[] listInPara) {
        String defaultCityCode = "150100";
        if (!javaDict.hasKey(listInPara[0])) {
            return YuinResult.newSuccessResult((Object[])new Object[]{defaultCityCode});
        }
        String sendbrno = javaDict.getString(listInPara[0]);
        YuinLogUtils.getInst((Object)this).info("{}|\u5f00\u6237\u884c\u673a\u6784\u53f7\u662f: {}", javaDict.get("logPrefix"), (Object)sendbrno);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sel_clearbrno");
        javaDict.set("sendbrno", (Object)sendbrno);
        try {
            YuinResultDto result = this.tradeOperDbService.operDbaction(javaDict, javaDict.get("sysid").toString(), javaDict.get("appid").toString(), arrayList);
            List Qryresult = (List)result.getBody();
            if (CollectionUtils.isEmpty((Collection)Qryresult)) {
                return YuinResult.newSuccessResult((Object[])new Object[]{defaultCityCode});
            }
            Map itemMap = YuinBeanUtil.transBean2Map(Qryresult.get(0));
            javaDict.setMap(itemMap);
            ArrayList<String> arrayListCity = new ArrayList<String>();
            arrayListCity.add("sel_citycode");
            YuinResultDto resultCityDto = this.tradeOperDbService.operDbaction(javaDict, javaDict.get("sysid").toString(), javaDict.get("appid").toString(), arrayListCity);
            List qryResultCity = (List)resultCityDto.getBody();
            if (CollectionUtils.isEmpty((Collection)qryResultCity)) {
                return YuinResult.newSuccessResult((Object[])new Object[]{defaultCityCode});
            }
            Map itemMapCity = YuinBeanUtil.transBean2Map(qryResultCity.get(0));
            javaDict.setMap(itemMapCity);
            YuinLogUtils.getInst((Object)this).info("{}|\u65b0\u7684\u57ce\u5e02\u4ee3\u7801\u503c\u662f: {}", javaDict.get("logPrefix"), (Object)javaDict.getString("citycode"));
            javaDict.set("payercitycode", (Object)javaDict.getString("citycode"));
            return YuinResult.newSuccessResult((Object[])new Object[]{javaDict.getString("citycode")});
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst((Object)this).info("{}|\u9519\u8bef\u4fe1\u606f: {}", javaDict.get("logPrefix"), (Object)e.getStackTrace());
            return YuinResult.newFailureResult((String)"E1099", (String)PayErrorCode.getErrmsgAdd((String)"E1099", (String)"\u83b7\u53d6\u57ce\u5e02\u4ee3\u7801\u5f02\u5e38"));
        }
    }

    public YuinResult getCityCode(JavaDict javaDict, String inparamBank, String outparamCityMap) {
        try {
            YuinResult result = this.upPBankinfoService.getBankInfoByBank(javaDict, inparamBank);
            String payeecitycode = ((JavaDict)result.getOutputParams().get(0)).getString("nodecity");
            javaDict.set(outparamCityMap, (Object)payeecitycode);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst((Object)this).info("{}|\u9519\u8bef\u4fe1\u606f: {}", javaDict.get("logPrefix"), (Object)e.getStackTrace());
            return YuinResult.newFailureResult((String)"E1099", (String)PayErrorCode.getErrmsg((String)"E1099"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public YuinResult getCorpInfo(JavaDict javaDict, List<String> inParam) {
        Object result = null;
        try {
            String corpErrCodeInner;
            String corpStatus = javaDict.getString(inParam.get(0));
            String corpErrCode = inParam.get(1);
            String corpErrMsg = inParam.get(2);
            if (javaDict.hasKey(corpErrCode) && javaDict.hasKey(corpErrMsg)) {
                return YuinResult.newSuccessResult(null);
            }
            if (javaDict.hasKey(corpErrCode)) {
                String msgPrefix = "";
                String msgSuffix = "";
                YuinResult sysAbbreviation = this.upPDictService.getDictValue2ByKey(javaDict, "sysid,appid,#systemAbbreviation,#S,#System,#BE");
                List outputParams = sysAbbreviation.getOutputParams();
                msgPrefix = String.valueOf(outputParams.get(0));
                msgSuffix = PayErrorCode.getErrmsg((String)javaDict.getString(corpErrCode).substring(3));
                String innerCorpErrMsg = msgPrefix + msgSuffix;
                javaDict.set(corpErrMsg, (Object)innerCorpErrMsg);
                return YuinResult.newSuccessResult(null);
            }
            if (javaDict.hasKey(corpErrCode)) return YuinResult.newSuccessResult(null);
            if (ECorpStatus.MPS_CORPSTATUS_WASH.getCode().equals(corpStatus)) {
                corpErrCodeInner = "CU1S9999";
                if (!javaDict.hasKey(corpErrMsg)) {
                    String innerCorpErrMsg = "\u5176\u4ed6\u7cfb\u7edf\u9519";
                    javaDict.set(corpErrMsg, (Object)innerCorpErrMsg);
                }
            } else {
                corpErrCodeInner = "CU0I0000";
                if (!javaDict.hasKey(corpErrMsg)) {
                    String innerCorpErrMsg = "\u5904\u7406\u6210\u529f";
                    javaDict.set(corpErrMsg, (Object)innerCorpErrMsg);
                }
            }
            javaDict.set(corpErrCode, (Object)corpErrCodeInner);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newExeptionResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)("\u83b7\u53d6\u4e2d\u5fc3\u9519\u8bef\u4fe1\u606f\u5f02\u5e38" + e.getMessage())));
        }
    }

    public YuinResult getUpMsg(JavaDict javaDict) {
        String sysid = javaDict.getString("sysid");
        String appid = javaDict.getString("appid");
        String sendmsgtype = javaDict.getString("sendmsgtype");
        String sendclearbank = javaDict.getString("sendclearbank");
        String recvclearbank = javaDict.getString("recvclearbank");
        String authcode = javaDict.getString("authcode");
        String msgtype = sendmsgtype.substring(0, sendmsgtype.length() - 1) + "2";
        if ("ibps.101.001.02".equals(msgtype)) {
            UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
            upBMsgmangeVo.setAppid(appid);
            upBMsgmangeVo.setSysid(sysid);
            upBMsgmangeVo.setBankno(sendclearbank);
            upBMsgmangeVo.setOrigmsgtype(msgtype);
            upBMsgmangeVo.setMsgtype("MC00");
            UpBMsgmangePo upBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoSe == null) {
                YuinLogUtils.getInst((Object)this).info("{}|{}:\u4e0d\u652f\u63011.6", javaDict.get("logPrefix"), (Object)sendclearbank);
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            upBMsgmangeVo.setBankno(recvclearbank);
            UpBMsgmangePo upBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoRe == null) {
                YuinLogUtils.getInst((Object)this).info("{}|{}:\u4e0d\u652f\u63011.6", javaDict.get("logPrefix"), (Object)recvclearbank);
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            javaDict.set("sendmsgtype", (Object)upBMsgmangePoSe.getOrigmsgtype());
        } else if (javaDict.hasKey("authcode") && ("ibps.103.001.02".equals(msgtype) || "ibps.105.001.02".equals(msgtype) || "ibps.335.001.02".equals(msgtype) || "ibps.339.001.02".equals(msgtype))) {
            UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
            upBMsgmangeVo.setAppid(appid);
            upBMsgmangeVo.setSysid(sysid);
            upBMsgmangeVo.setBankno(sendclearbank);
            upBMsgmangeVo.setOrigmsgtype(msgtype);
            upBMsgmangeVo.setAuthcode(authcode);
            upBMsgmangeVo.setMsgtype("MC00");
            UpBMsgmangePo upBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoSe == null) {
                YuinLogUtils.getInst((Object)this).info("{}|{}:\u4e0d\u652f\u63011.6", javaDict.get("logPrefix"), (Object)sendclearbank);
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            upBMsgmangeVo.setBankno(recvclearbank);
            UpBMsgmangePo upBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoRe == null) {
                YuinLogUtils.getInst((Object)this).info("{}|{}:\u4e0d\u652f\u63011.6", javaDict.get("logPrefix"), (Object)recvclearbank);
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            javaDict.set("sendmsgtype", (Object)upBMsgmangePoSe.getOrigmsgtype());
        } else {
            return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
        }
        YuinLogUtils.getInst((Object)this).info("{}|\u6700\u65b0\u7248\u672c\u62a5\u6587\u7f16\u53f7\u4e3a{}", javaDict.get("logPrefix"), (Object)msgtype);
        return YuinResult.newSuccessResult(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public YuinResult getEndorserName(JavaDict javaDict) {
        Object result = null;
        try {
            List list;
            Map param;
            String endorserName = "";
            if (javaDict.hasKey("tradecode") && "UPP01021".equals(javaDict.getString("tradecode"))) {
                if (!javaDict.hasKey("circle")) return YuinResult.newSuccessResult(null);
                List dealCircle = (List)javaDict.get("circle");
                for (Map item : dealCircle) {
                    if (!item.containsKey("endorsername")) continue;
                    endorserName = endorserName + "," + item.get("endorsername");
                }
                javaDict.set("endorsername", (Object)endorserName.substring(1));
                return YuinResult.newSuccessResult(null);
            }
            if (!javaDict.hasKey("tradecode") || !"UPP01061".equals(javaDict.getString("tradecode"))) return YuinResult.newSuccessResult(null);
            if (!javaDict.hasKey("listResult")) {
                YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)"\u7f3a\u5c11listResult\u6570\u636e"));
            }
            if (!(param = BeanUtils.beanToMap((list = (List)javaDict.get("listResult")).get(0))).containsKey("circle")) return YuinResult.newSuccessResult(null);
            List dealCircle = (List)param.get("circle");
            for (Map item : dealCircle) {
                if (!item.containsKey("endorsername")) continue;
                endorserName = endorserName + ",";
            }
            param.put("endorsername", endorserName);
            list.add(0, param);
            javaDict.set("listResult", (Object)list);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newExeptionResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)("\u83b7\u53d6\u80cc\u4e66\u4eba\u4fe1\u606f, \u80cc\u4e66\u4eba\u4fe1\u606f\u5408\u5e76\u5f02\u5e38" + e.getMessage())));
        }
    }

    public YuinResult getDrealAmt(JavaDict javaDict, String[] listInPara, String[] listOutPara) {
        BigDecimal initAmt = new BigDecimal(0.0);
        if (listInPara.length < 2) {
            return YuinResult.newFailureResult((String)"S9001", (String)"B_Get_RealTradeAmt\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u5165\u53c2");
        }
        for (String inParm : listInPara) {
            if (javaDict.hasKey(inParm)) continue;
            javaDict.set(inParm, (Object)"0");
        }
        YuinLogUtils.getInst((Object)this).info("{}|\u4ea4\u6613\u91d1\u989d\uff1a{}", (Object)javaDict.getString("logPrefix"), (Object)javaDict.getBigDecimal(listInPara[0]));
        YuinLogUtils.getInst((Object)this).info("{}|\u624b\u7eed\u8d39\uff1a{}", (Object)javaDict.getString("logPrefix"), (Object)javaDict.getBigDecimal(listInPara[1]));
        if (javaDict.getBigDecimal(listInPara[0]).compareTo(initAmt) <= 0) {
            return YuinResult.newFailureResult((String)"O1022", (String)PayErrorCode.getErrmsg((String)"O1022"));
        }
        if (javaDict.hasKey("feemode") && "0".equals(javaDict.getString("feemode"))) {
            BigDecimal intAmt = javaDict.getBigDecimal(listInPara[0]).subtract(javaDict.getBigDecimal(listInPara[1]));
            javaDict.set(listOutPara[0], (Object)intAmt);
        } else {
            javaDict.set(listOutPara[0], (Object)javaDict.getBigDecimal(listInPara[0]));
        }
        YuinLogUtils.getInst((Object)this).info("{}|\u5b9e\u9645\u4ea4\u6613\u91d1\u989d\uff1a{}", (Object)javaDict.getString("logPrefix"), (Object)javaDict.getBigDecimal(listOutPara[0]));
        return YuinResult.newSuccessResult(null);
    }

    public static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    public String calcDate(String strDate, String strDtUnt, int strDtStp) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            Date dtDate = format.parse(strDate);
            Calendar calender = Calendar.getInstance();
            calender.setTime(dtDate);
            int month = calender.get(2) + strDtStp;
            int year = calender.get(1) + month / 12;
            month %= 12;
            int day = Math.min(calender.get(5), calender.getActualMaximum(5));
            if ("TU02".equals(strDtUnt)) {
                day += strDtStp;
                day = Math.min(calender.get(5), calender.getActualMaximum(5));
                day = Math.max(day, 1);
                return String.format("%04d%02d%02d", year, month, day);
            }
            if ("TU01".equals(strDtUnt)) {
                day = 1;
                return String.format("%04d%02d%02d", year, month, day);
            }
            if ("TU00".equals(strDtUnt)) {
                month = 0;
                day = 1;
                return String.format("%04d%02d%02d", year, month, day);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public YuinResult getUpMsgGood(JavaDict javaDict, String[] listInPara) {
        try {
            if ("UPP14065".equals(javaDict.getString("tradecode"))) {
                return YuinResult.newSuccessResult(null);
            }
            if (javaDict.hasKey("origmsgtype") && "ibps.335.001.03".equals(javaDict.getString("origmsgtype")) && javaDict.hasKey("authcode") && "AC03".equals(javaDict.getString("authcode"))) {
                javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.02");
                YuinResult.newSuccessResult(null);
            }
            if (listInPara.length < 5) {
                return YuinResult.newFailureResult((String)"S9001", (String)"B_Get_RealTradeAmt\u81f3\u5c11\u9700\u89815\u4e2a\u5165\u53c2");
            }
            String appid = javaDict.getString("appid");
            String authcode = javaDict.hasKey(listInPara[4]) ? javaDict.getString(listInPara[4]) : "";
            String sysid = javaDict.getString(listInPara[0]);
            String sendmsgtype = javaDict.hasKey(listInPara[1]) ? javaDict.getString(listInPara[1]) : "";
            String sendclearbank = javaDict.hasKey(listInPara[2]) ? javaDict.getString(listInPara[2]) : "";
            String recvclearbank = javaDict.hasKey(listInPara[3]) ? javaDict.getString(listInPara[3]) : "";
            String msgtype = sendmsgtype.substring(0, sendmsgtype.length() - 2);
            String msgtype1 = sendmsgtype.substring(0, sendmsgtype.length() - 2);
            YuinLogUtils.getInst((Object)this).info("sysid:{}", (Object)sysid);
            YuinLogUtils.getInst((Object)this).info("sendmsgtype:{}", (Object)sendmsgtype);
            YuinLogUtils.getInst((Object)this).info("sendclearbank:{}", (Object)sendclearbank);
            YuinLogUtils.getInst((Object)this).info("recvclearbank:{}", (Object)recvclearbank);
            if ("ibps.337.001.01".equals(javaDict.getString("sendmsgtype"))) {
                UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
                upBMsgmangeVo.setAppid(appid);
                upBMsgmangeVo.setSysid(sysid);
                upBMsgmangeVo.setBankno(sendclearbank);
                upBMsgmangeVo.setOrigmsgtype(msgtype1);
                upBMsgmangeVo.setMsgtype("MC00");
                UpBMsgmangePo upBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
                upBMsgmangeVo.setBankno(recvclearbank);
                UpBMsgmangePo upBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
                if (upBMsgmangePoSe != null && upBMsgmangePoRe != null) {
                    if (Integer.valueOf(upBMsgmangePoSe.getOrigmsgtype()) > Integer.valueOf(upBMsgmangePoRe.getOrigmsgtype())) {
                        javaDict.set("__sendmsgtype__", (Object)upBMsgmangePoRe.getOrigmsgtype());
                    } else {
                        javaDict.set("__sendmsgtype__", (Object)upBMsgmangePoSe.getOrigmsgtype());
                    }
                } else {
                    javaDict.set("__sendmsgtype__", (Object)(msgtype + "01"));
                }
                return YuinResult.newSuccessResult(null);
            }
            if ("UPP14052".equals(javaDict.getString("tradecode"))) {
                if ("ibps.335.001.03".equals(javaDict.getString("origmsgtype"))) {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.02");
                } else {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.01");
                }
                return YuinResult.newSuccessResult(null);
            }
            UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
            upBMsgmangeVo.setAppid(appid);
            upBMsgmangeVo.setSysid(sysid);
            upBMsgmangeVo.setBankno(sendclearbank);
            upBMsgmangeVo.setOrigmsgtype(msgtype1);
            upBMsgmangeVo.setAuthcode(authcode);
            upBMsgmangeVo.setMsgtype("MC00");
            UpBMsgmangePo resultUpBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            upBMsgmangeVo.setBankno(recvclearbank);
            UpBMsgmangePo reslutUpBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (resultUpBMsgmangePoSe != null && reslutUpBMsgmangePoRe != null) {
                if (Integer.valueOf(resultUpBMsgmangePoSe.getOrigmsgtype()) > Integer.valueOf(reslutUpBMsgmangePoRe.getOrigmsgtype())) {
                    javaDict.set("__sendmsgtype__", (Object)reslutUpBMsgmangePoRe.getOrigmsgtype());
                } else {
                    javaDict.set("__sendmsgtype__", (Object)resultUpBMsgmangePoSe.getOrigmsgtype());
                }
            } else {
                javaDict.set("__sendmsgtype__", (Object)(msgtype + "01"));
            }
            if (("ibps.335.001.01".equals(javaDict.getString("sendmsgtype")) || "ibps.335.001.02".equals(javaDict.getString("sendmsgtype"))) && "MT03".equals(javaDict.getString("protocoloptype"))) {
                YuinLogUtils.getInst((Object)this).info("{}", (Object)"\u5bf9\u624b\u884c\u4e0d\u652f\u6301\u6b64\u67e5\u8be2\u529f\u80fd");
                return YuinResult.newFailureResult((String)"S9001", (String)"\u5bf9\u624b\u884c\u4e0d\u652f\u6301\u6b64\u67e5\u8be2\u529f\u80fd");
            }
            if ("ibps.335.001.03".equals(javaDict.getString("sendmsgtype")) && "MT03".equals(javaDict.getString("protocoloptype"))) {
                javaDict.set("authcode", (Object)"AC01");
                YuinLogUtils.getInst((Object)this).info("\u7ba1\u7406\u7c7b\u578b\u4e3a\u67e5\u8be2\u65f6\uff0c\u8ba4\u8bc1\u65b9\u5f0f\u56fa\u5b9a\u586b\u5199\uff1aAC01");
            }
            if ("UPP14051".equals(javaDict.getString("tradecode"))) {
                if ("ibps.335.001.03".equals(javaDict.getString("origrefmsgtype"))) {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.02");
                } else {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.01");
                }
            }
            YuinLogUtils.getInst((Object)this).info("\u672c\u6b21\u4ea4\u6613\u652f\u6301\u62a5\u6587:" + javaDict.getString("sendmsgtype"));
            if ("UPP14051".equals(javaDict.getString("tradecode")) && "MT03".equals(javaDict.getString("protocoloptype"))) {
                if ("2".equals(javaDict.getString("effectflag"))) {
                    javaDict.set("__STEPSTATUS__", (Object)"2");
                    javaDict.set("errcode", (Object)"RJ1S");
                    javaDict.set("errmsg", (Object)"\u534f\u8bae\u5df2\u64a4\u9500");
                    YuinLogUtils.getInst((Object)this).info("\u534f\u8bae\u5df2\u8d85\u671f\u5931\u6548\uff0c\u4e0a\u4e00\u6b65\u9aa4\u4fee\u6539\u4e3a\uff1a2");
                }
                if (javaDict.hasKey("stopdate") && !"".equals(javaDict.getString("stopdate")) && Integer.valueOf(javaDict.getString("stopdate")) < Integer.valueOf(javaDict.getString("workdate"))) {
                    javaDict.set("__STEPSTATUS__", (Object)"2");
                    javaDict.set("errcode", (Object)"RJ1T");
                    javaDict.set("errmsg", (Object)"\u534f\u8bae\u5df2\u8d85\u671f\u5931\u6548");
                    YuinLogUtils.getInst((Object)this).info("\u672c\u6b21\u4ea4\u6613\u652f\u6301\u62a5\u6587" + javaDict.getString("sendmsgtype"));
                }
            }
            JavaDict javaDictcrt = new JavaDict();
            javaDictcrt.set("", (Object)("\u672c\u6b21\u4ea4\u6613\u652f\u6301\u62a5\u6587" + javaDict.getString("sendmsgtype")));
            return YuinResult.newSuccessResult((Object[])new Object[]{javaDictcrt});
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst((Object)this).info("\u83b7\u53d6sendmsgtype:" + e.getMessage());
            return YuinResult.newFailureResult((String)"S9400", (String)("\u83b7\u53d6sendmsgtype\u5f02\u5e38\uff1a%s" + e.getMessage()));
        }
    }

    public YuinResult getClearBankInfo(JavaDict request, List<String> list) {
        YuinResult result = new YuinResult();
        try {
            result = this.uppBankinfoService.getBankInfoByBank(request, request.getString("bankno"), "recvbank,recvbankname,recvclearbank,recvclearbankname".split(","));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!result.isSuccess()) {
            return result;
        }
        JavaDict javaDict = (JavaDict)result.getOutputParams().get(0);
        request.set(list.get(0), (Object)javaDict.getString(list.get(0)));
        request.set(list.get(1), (Object)javaDict.getString(list.get(1)));
        request.set(list.get(2), (Object)javaDict.getString(list.get(2)));
        request.set(list.get(3), (Object)javaDict.getString(list.get(3)));
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHeadMsg(JavaDict javaDict, List<String> listInParam, String javaDictMap) {
        try {
            String strClearBank = "";
            if (listInParam.size() != 2) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u8be5\u51fd\u6570\u5165\u53c2\u4e2a\u6570\u4e3a2\u4e2a");
            }
            if ("UPP99007".equals(javaDict.getString("tradecode"))) {
                strClearBank = listInParam.get(1).startsWith("#") ? listInParam.get(1).substring(1) : javaDict.getString(listInParam.get(1));
                javaDict.set(javaDictMap, (Object)strClearBank);
            }
            if (!javaDict.hasKey(listInParam.get(0))) {
                strClearBank = listInParam.get(1).startsWith("#") ? listInParam.get(1).substring(1) : javaDict.getString(listInParam.get(1));
                javaDict.set(javaDictMap, (Object)strClearBank);
            } else {
                javaDict.set(javaDictMap, (Object)javaDict.getString(listInParam.get(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getBanknoByBrno(JavaDict javaDict, List<String> listInParam, List<String> outParam) {
        UpPBankmapQueryVo upPBankmapQueryVo = null;
        try {
            upPBankmapQueryVo = new UpPBankmapQueryVo();
            upPBankmapQueryVo.setSysid(javaDict.getString(listInParam.get(0)));
            upPBankmapQueryVo.setAppid(javaDict.getString(listInParam.get(1)));
            upPBankmapQueryVo.setBrno(javaDict.getString(listInParam.get(2)));
            UpPBankmapPo upPBankmapPo = this.upPBankmapRepo.selectById(upPBankmapQueryVo);
            if (upPBankmapPo == null) {
                return YuinResult.newFailureResult((String)"", (String)"\u83b7\u53d6\u652f\u4ed8\u884c\u53f7\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!"1".equals(upPBankmapPo.getStatus())) {
                return YuinResult.newFailureResult((String)"O3048", (String)"\u7f51\u70b9\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            if (outParam == null) {
                return YuinResult.newSuccessResult((Object[])new Object[]{upPBankmapPo.getCorpbankno()});
            }
            javaDict.set(outParam.get(0), (Object)upPBankmapPo.getCorpbankno());
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newSuccessResult(null);
        }
    }

    public YuinResult getBankBrno(JavaDict javaDict, List<String> listInParam, List<String> outParam) {
        UpPBankmapQueryVo upPBankmapQueryVo = null;
        try {
            upPBankmapQueryVo = new UpPBankmapQueryVo();
            upPBankmapQueryVo.setSysid(javaDict.getString(listInParam.get(0)));
            upPBankmapQueryVo.setCorpbankno(javaDict.getString(listInParam.get(1)));
            UpPBankmapPo upPBankmapPo = this.upPBankmapRepo.selectById(upPBankmapQueryVo);
            if (upPBankmapPo == null) {
                return YuinResult.newFailureResult((String)"", (String)"\u83b7\u53d6\u652f\u4ed8\u884c\u53f7\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!"1".equals(upPBankmapPo.getStatus())) {
                return YuinResult.newFailureResult((String)"O3048", (String)"\u7f51\u70b9\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            if (outParam == null) {
                return YuinResult.newSuccessResult((Object[])new Object[]{upPBankmapPo.getBrno()});
            }
            javaDict.set(outParam.get(0), (Object)upPBankmapPo.getBrno());
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newSuccessResult(null);
        }
    }

    public YuinResult getCrtMsgBLOB(JavaDict javaDict, String listInPara, String listOutPara) {
        String[] listInParaArry = listInPara.split(",");
        String listOutParaValue = "";
        for (String param : listInParaArry) {
            if (param.split(":").length < 2) {
                return YuinResult.newFailureResult((String)"E3101", (String)PayErrorCode.getErrmsg((String)"E3101"));
            }
            if (!javaDict.hasKey(param.split(":")[0])) continue;
            listOutParaValue = StringUtils.isBlank((CharSequence)listOutParaValue) ? param.split(":")[1] + ":" + javaDict.getString(param.split(":")[0]) : listOutParaValue + "," + param.split(":")[1] + ":" + javaDict.getString(param.split(":")[0]);
        }
        javaDict.set(listOutPara, (Object)listOutParaValue);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getNCSPyee(JavaDict javaDict) {
        try {
            boolean boolflg;
            String structtype = javaDict.getString("structtype", "");
            String tradecode = javaDict.getString("tradecode", "");
            String workseqid = javaDict.getString("workseqid");
            String workdate = javaDict.getString("workdate");
            String protocolno = "";
            if ("BUP03051".equals(tradecode) || "BUP03057".equals(tradecode) || "BUP03059".equals(tradecode)) {
                protocolno = javaDict.getString("protocolno", "");
                javaDict.set("authinfo", (Object)protocolno);
            } else {
                protocolno = "".equals(javaDict.getString("authinfo", "")) ? javaDict.getString("protocolno", "") : javaDict.getString("authinfo", "");
            }
            YuinLogUtils.getInst((Object)this).info("tradecode:{},structtype:{},protocolno:{}", new Object[]{tradecode, structtype, protocolno});
            boolean bl = boolflg = !(!"BUP03051".equals(tradecode) && !"BUP03057".equals(tradecode) && !"BUP03059".equals(tradecode) || !"C101".equals(javaDict.getString("busitype")) || !"0".equals(javaDict.getString("payeeaccno", "")) && !"0".equals(javaDict.getString("payeename", "")));
            if (("BUP03053".equals(tradecode) || "BUP03058".equals(tradecode)) && !"".equals(protocolno) || boolflg) {
                YuinResult result = this.uPPChkService.chkNCSChkProtocol(javaDict);
                if (!result.isSuccess()) {
                    return result;
                }
                return YuinResult.newSuccessResult(null);
            }
            if ("BUP03051".equals(tradecode) || "BUP03057".equals(tradecode) || "BUP03059".equals(tradecode)) {
                YuinLogUtils.getInst((Object)this).debug("\u3010\u4e0d\u6821\u9a8c\u534f\u8bae\u6b63\u5e38\u7ed3\u675f\u3011");
                return YuinResult.newSuccessResult(null);
            }
            return YuinResult.newFailureResult((String)"S9400", (String)"\u83b7\u53d6\u9884\u6388\u6743\u767b\u8bb0\u7c3f\u5f02\u5e38\u5f02\u5e38");
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u8d26\u6237\u9a8c\u8bc1\u7279\u6b8a\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
            return YuinResult.newFailureResult((String)"S9400", (String)"\u901a\u5151\u6765\u8d26\u68c0\u67e5\u5f02\u5e38");
        }
    }

    public YuinResult getChangeBatchno(JavaDict javaDict, List<String> listInPara) {
        String batchid = javaDict.getString(listInPara.get(0));
        String centerflag = javaDict.getString(listInPara.get(1));
        YuinLogUtils.getInst((Object)this).info("=====\u6279\u6b21\u53f7:{},\u4e2d\u5fc3\u6807\u5fd7centerflag\u4e3a:{}=====", (Object)batchid, (Object)centerflag);
        javaDict.set("batchid", (Object)(centerflag + batchid));
        YuinLogUtils.getInst((Object)this).info("=====\u65b0\u6279\u6b21\u53f7:{},===", (Object)javaDict.getString("batchid"));
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getBankBrnoInfo(JavaDict javaDict, List<String> listInParam) {
        YuinResult result = new YuinResult();
        try {
            UpPBankmapQueryVo data;
            String bankNo;
            String sysId;
            if (listInParam.size() != 3) {
                return YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)"\u5165\u53c2\u4e2a\u6570\u4e0d\u5408\u6cd5"));
            }
            String appId = javaDict.getString(listInParam.get(0));
            result = this.upPBankmapRepo.getBankStatus(appId, sysId = javaDict.getString(listInParam.get(1)), bankNo = javaDict.getString(listInParam.get(2)));
            if (result.isSuccess()) {
                data = (UpPBankmapQueryVo)result.getOutputParams().get(0);
                if (!"1".equals(data.getStatus())) {
                    return YuinResult.newFailureResult((String)"E1105", (String)PayErrorCode.getErrmsg((String)"E1105"));
                }
            } else {
                return YuinResult.newFailureResult((String)"O6046", (String)PayErrorCode.getErrmsg((String)"O6046"));
            }
            javaDict.set("brno", (Object)data.getBrno());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubStr(JavaDict javaDict, List<String> listInPara) {
        Object result = null;
        if (listInPara.size() != 3) {
            return YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsg((String)""));
        }
        String strStr = listInPara.get(0).toString().startsWith("#") ? listInPara.get(0).toString().substring(1) : javaDict.getString(listInPara.get(0));
        String strStar = listInPara.get(1).toString().startsWith("#") ? listInPara.get(1).toString().substring(1) : javaDict.getString(listInPara.get(1));
        String strEnd = listInPara.get(2).toString().startsWith("#") ? listInPara.get(2).toString().substring(1) : javaDict.getString(listInPara.get(2));
        String strSub = strStr.substring(Integer.valueOf(strStar), Integer.valueOf(strEnd));
        return YuinResult.newSuccessResult(null);
    }

    @Transactional
    public YuinResult getOrigBrno(JavaDict request, String key) {
        YuinResult result = new YuinResult();
        try {
            UpMTranjnlVo upMTranjnlVo = new UpMTranjnlVo();
            upMTranjnlVo.setAppid(request.getString("appid"));
            upMTranjnlVo.setSysid(request.getString("sysid"));
            UpMTranjnlVo updateVo = new UpMTranjnlVo();
            updateVo.setTradebusistep("24");
            if ("HVPS".equals(request.getString("sysid")) && "01105".equals(request.getString("extbusitype"))) {
                if ("2".equals(request.getString("sysflag"))) {
                    upMTranjnlVo.setMsgid(request.getString("origmsgid"));
                    upMTranjnlVo.setMsgtype(request.getString("origmsgtype"));
                    upMTranjnlVo.setSendbank(request.getString("origsendbank"));
                } else {
                    upMTranjnlVo.setBusidate("origbusidate");
                    upMTranjnlVo.setMsgid(request.getString("origmsgid"));
                    upMTranjnlVo.setSendbank(request.getString("payeebank"));
                }
                UpMTranjnlVo operBrnoVo = this.upMTranjnlRepo.getOperBrnoInfo(upMTranjnlVo);
                if (operBrnoVo != null) {
                    updateVo.setWorkdate(operBrnoVo.getWorkdate());
                    updateVo.setWorkseqid(operBrnoVo.getWorkseqid());
                    this.upMTranjnlRepo.updateTradeBusiStep(updateVo);
                    if (StringUtils.isBlank((CharSequence)key)) {
                        request.set(key, (Object)operBrnoVo.getOperbrno());
                    }
                }
            } else if ("BEPS".equals(request.getString("sysid")) && "01105".equals(request.getString("extbusitype"))) {
                if ("2".equals(request.getString("sysflag"))) {
                    upMTranjnlVo.setMsgid(request.getString("origmsgid"));
                    upMTranjnlVo.setDetailno("origdetailno");
                    upMTranjnlVo.setMsgtype(request.getString("origmsgtype"));
                    upMTranjnlVo.setSendclearbank("recvclearbank");
                } else {
                    upMTranjnlVo.setBusidate("origbusidate");
                    upMTranjnlVo.setDetailno("origdetailno");
                    upMTranjnlVo.setPayeeaccno(request.getString("payeraccno"));
                    String amt = request.getString("amt");
                    BigDecimal formatAmt = new BigDecimal(amt);
                    upMTranjnlVo.setAmt(formatAmt);
                    upMTranjnlVo.setSendclearbank(request.getString("recvclearbank"));
                }
                UpMTranjnlVo operBrnoVo = this.upMTranjnlRepo.getOperBrnoInfo(upMTranjnlVo);
                updateVo.setWorkdate(operBrnoVo.getWorkdate());
                updateVo.setWorkseqid(operBrnoVo.getWorkseqid());
                this.upMTranjnlRepo.updateTradeBusiStep(updateVo);
                if (operBrnoVo != null && StringUtils.isBlank((CharSequence)key)) {
                    request.set(key, (Object)operBrnoVo.getOperbrno());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getNMGetErrMsg(JavaDict javaDict) {
        try {
            JavaDict rtdDict = javaDict.getDict("__RCVSELMSG__");
            rtdDict.set("acctcls", (Object)"1");
            String rtnmsg = rtdDict.getString("rtnmsg", "").trim();
            String rtncode = rtdDict.getString("rtncode", "").trim();
            if ("\u624b\u673a\u53f7\u7801\u4e0d\u7b26".equals(rtnmsg) || "SVS0033".equals(rtncode)) {
                rtdDict.set("rtncode", (Object)"ESS2012");
                rtdDict.set("rtnmsg", (Object)"\u624b\u673a\u53f7\u7801\u4e0d\u7b26");
                YuinLogUtils.getInst((Object)this).info("\u624b\u673a\u53f7\u7801\u4e0d\u7b26\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if ("\u5ba2\u6237\u59d3\u540d\u4e0d\u7b26".equals(rtnmsg)) {
                rtdDict.set("rtncode", (Object)"RSS0503");
                rtdDict.set("rtnmsg", (Object)"\u5ba2\u6237\u59d3\u540d\u4e0d\u7b26");
                YuinLogUtils.getInst((Object)this).info("\u5ba2\u6237\u59d3\u540d\u4e0d\u7b26\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if ("CDS0904".equals(rtncode)) {
                rtdDict.set("rtncode", (Object)"GLS1119");
                rtdDict.set("rtnmsg", (Object)"\u5df2\u9500\u6237");
                YuinLogUtils.getInst((Object)this).info("\u5df2\u9500\u6237\uff1a{}", (Object)rtdDict.getString("rtncode"));
            }
            YuinLogUtils.getInst((Object)this).info("\u9519\u8bef\u7801\uff1a{}", (Object)rtdDict.getString("rtncode"));
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u9519\u8bef\u7801\u8f6c\u5316\u5f02\u5e38:{}", (Object)e.getMessage());
            return YuinResult.newFailureResult((String)"S9400", (String)"\u9519\u8bef\u7801\u8f6c\u5316\u5f02\u5e38");
        }
    }

    public YuinResult getNMGetErrCode(JavaDict javaDict) {
        try {
            JavaDict rtdDict = javaDict.getDict("__RCVSELMSG__");
            String accsts = rtdDict.getString("accsts");
            if (!"0".equals(accsts.substring(0, 1))) {
                rtdDict.set("rtncode", (Object)"DPS0010");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u51ed\u8bc1\u6302\u5931");
                YuinLogUtils.getInst((Object)this).info("\u51ed\u8bc1\u6302\u5931\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"0".equals(accsts.substring(1, 2))) {
                rtdDict.set("rtncode", (Object)"DPS0010");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u5bc6\u7801\u6302\u5931");
                YuinLogUtils.getInst((Object)this).info("\u5bc6\u7801\u6302\u5931\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"0".equals(accsts.substring(2, 3))) {
                rtdDict.set("rtncode", (Object)"DPS0241s");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u51bb\u7ed3");
                YuinLogUtils.getInst((Object)this).info("\u51bb\u7ed3\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"0".equals(accsts.substring(3, 4))) {
                rtdDict.set("rtncode", (Object)"CDS0904");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u8d28\u62bc");
                YuinLogUtils.getInst((Object)this).info("\u8d28\u62bc\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"1".equals(accsts.substring(4, 5))) {
                rtdDict.set("rtncode", (Object)"DPS0008");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u6ce8\u9500");
                YuinLogUtils.getInst((Object)this).info("\u8d26\u6237\u5df2\u6ce8\u9500\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"2".equals(accsts.substring(4, 5))) {
                rtdDict.set("rtncode", (Object)"DPS0010");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u6302\u5931\u7ed3\u6e05");
                YuinLogUtils.getInst((Object)this).info("\u8d26\u6237\u5df2\u6302\u5931\u7ed3\u6e05\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"3".equals(accsts.substring(4, 5))) {
                rtdDict.set("rtncode", (Object)"RJ15");
                rtdDict.set("rtnmsg", (Object)"\u4e0d\u52a8\u6237");
                YuinLogUtils.getInst((Object)this).info("\u4e0d\u52a8\u6237\uff1a{}", (Object)rtdDict.getString("rtncode"));
            } else if (!"2".equals(accsts.substring(5, 6))) {
                rtdDict.set("rtncode", (Object)"CDS0425");
                rtdDict.set("rtnmsg", (Object)"\u8d26\u6237\u5df2\u6b62\u4ed8");
                YuinLogUtils.getInst((Object)this).info("\u8d26\u6237\u5df2\u6b62\u4ed8\uff1a{}", (Object)rtdDict.getString("rtncode"));
            }
            YuinLogUtils.getInst((Object)this).info("\u8d26\u6237\u72b6\u6001\uff1a{}", (Object)rtdDict.getString("rtncode"));
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u9519\u8bef\u7801\u8f6c\u5316\u5f02\u5e38:{}", (Object)e.getMessage());
            return YuinResult.newFailureResult((String)"S9400", (String)"\u9519\u8bef\u7801\u8f6c\u5316\u5f02\u5e38");
        }
    }

    public YuinResult getMessageSnd(JavaDict javaDict) {
        try {
            JavaDict reqPack = new JavaDict();
            JavaDict rspPack = new JavaDict();
            javaDict.set("__SNDMESSAGE__", (Object)reqPack);
            javaDict.set("__RCVMESSAGE__", (Object)rspPack);
            javaDict.set("__acctflow__", (Object)"HostAcct");
            javaDict.set("__acctscne__", (Object)javaDict.getString("__ACCTSCENE2__"));
            YuinResult result = this.hostDealCommonService.packAndComm(javaDict, reqPack, rspPack, javaDict.getString("__acctscne__"));
            if (result.isSuccess()) {
                return YuinResult.newSuccessResult(null);
            }
            return YuinResult.newFailureResult((String)"O9015", (String)"\u77ed\u4fe1\u9a8c\u8bc1\u5931\u8d25");
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u77ed\u4fe1\u9a8c\u8bc1\u5931\u8d25");
            return YuinResult.newFailureResult((String)"O9015", (String)"\u77ed\u4fe1\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public YuinResult getNMDeadTime(JavaDict javaDict, List<String> inPara, List<String> outPara) {
        try {
            int deadtime = Integer.parseInt(inPara.get(0)) + Integer.parseInt(inPara.get(1).substring(1));
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(6);
            String deadtimes = nf.format(deadtime).replace(",", "");
            Date date = DateUtils.parseDate((String)javaDict.getString("workdate"), (String)"yyyyMMdd");
            String deadDay = DateUtils.addDay((Date)date, (int)8).toString();
            javaDict.set(outPara.get(0), (Object)deadtimes);
            javaDict.set(outPara.get(1), (Object)deadDay);
            YuinLogUtils.getInst((Object)this).info("\u5931\u6548\u65e5\u671f:{}", (Object)deadDay);
            YuinLogUtils.getInst((Object)this).info("\u5931\u6548\u65f6\u95f4:{}", (Object)deadtimes);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u83b7\u53d6\u77ed\u4fe1\u5931\u6548\u65f6\u95f4\u5f02\u5e38");
            return YuinResult.newFailureResult((String)"S9400", (String)"\u83b7\u53d6\u77ed\u4fe1\u5931\u6548\u65f6\u95f4\u5f02\u5e38");
        }
    }

    public YuinResult getNMContent(JavaDict javaDict) {
        try {
            String sendclearbank = javaDict.getString("sendclearbank", "");
            String msgvrfy = javaDict.getString("msgvrfy", "");
            String ptcchnl = javaDict.getString("ptcchnl", "");
            String busidate = javaDict.getString("busidate", "");
            String protocolno = javaDict.getString("protocolno", "");
            String hour = javaDict.getString("worktime").substring(0, 2);
            String minute = javaDict.getString("worktime").substring(2, 4);
            int length = javaDict.getString("payeraccno").length();
            String tailno = javaDict.getString("payeraccno", "").substring(length - 4);
            String payeeBankName = javaDict.getString("payeeBankName", "");
            String content = "";
            YuinLogUtils.getInst((Object)this).info("\u6536\u6b3e\u65b9\u884c\u540d:{}", (Object)payeeBankName);
            UpDLimitadmVo upDLimitadmVo = new UpDLimitadmVo();
            upDLimitadmVo.setAppid(javaDict.getString("appid"));
            upDLimitadmVo.setSysid(javaDict.getString("sysid"));
            upDLimitadmVo.setProtocolchannel(javaDict.getString("payerclearbank"));
            List<UpDLimitadmVo> list = this.upDLimitadmRepo.getAllInfo(upDLimitadmVo);
            if (list.size() == 0) {
                YuinResult result = this.getmsgvrfy(javaDict, busidate, ptcchnl, protocolno);
                if (!result.isSuccess()) {
                    return result;
                }
                msgvrfy = javaDict.getString("msgvrfy");
                content = "\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                javaDict.set("content", (Object)content);
                YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                javaDict.set("sendmsgflag", (Object)"1");
                return YuinResult.newSuccessResult(null);
            }
            YuinLogUtils.getInst((Object)this).info("\u662f\u5426\u751f\u6210\u53d1\u9001\u9a8c\u8bc1\u7801:{}", (Object)list.get(0).getMsgsnedtype());
            if ("1".equals(list.get(0).getMsgsnedtype())) {
                YuinLogUtils.getInst((Object)this).info("\u751f\u6210\uff0c\u53d1\u9001");
                javaDict.set("sendmsgflag", (Object)"1");
                YuinResult result = this.getmsgvrfy(javaDict, busidate, ptcchnl, protocolno);
                if (!result.isSuccess()) {
                    return result;
                }
                msgvrfy = javaDict.getString("msgvrfy");
                if (!"".equals(ptcchnl)) {
                    if ("01".equals(ptcchnl)) {
                        content = "\u8d22\u4ed8\u901a\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                        javaDict.set("content", (Object)content);
                        YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                        return YuinResult.newSuccessResult(null);
                    }
                    if ("02".equals(ptcchnl)) {
                        content = "\u5fae\u4fe1\u652f\u4ed8\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                        javaDict.set("content", (Object)content);
                        YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                        return YuinResult.newSuccessResult(null);
                    }
                    if ("03".equals(ptcchnl)) {
                        content = "\u624b\u673aQQ\u652f\u4ed8\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                        javaDict.set("content", (Object)content);
                        YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                        return YuinResult.newSuccessResult(null);
                    }
                    content = "\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                    javaDict.set("content", (Object)content);
                    YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                    return YuinResult.newSuccessResult(null);
                }
                content = "\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                javaDict.set("content", (Object)content);
                YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                return YuinResult.newSuccessResult(null);
            }
            if ("2".equals(list.get(0).getMsgsnedtype())) {
                YuinLogUtils.getInst((Object)this).info("\u4e0d\u751f\u6210\uff0c\u53d1\u9001");
                javaDict.set("sendmsgflag", (Object)"1");
                if (!"".equals(ptcchnl)) {
                    if ("01".equals(ptcchnl)) {
                        content = "\u8d22\u4ed8\u901a\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                        javaDict.set("content", (Object)content);
                        YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                        return YuinResult.newSuccessResult(null);
                    }
                    if ("02".equals(ptcchnl)) {
                        content = "\u5fae\u4fe1\u652f\u4ed8\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                        javaDict.set("content", (Object)content);
                        YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                        return YuinResult.newSuccessResult(null);
                    }
                    if ("03".equals(ptcchnl)) {
                        content = "\u624b\u673aQQ\u652f\u4ed8\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                        javaDict.set("content", (Object)content);
                        YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                        return YuinResult.newSuccessResult(null);
                    }
                    content = "\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                    javaDict.set("content", (Object)content);
                    YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                    return YuinResult.newSuccessResult(null);
                }
                content = "\u9a8c\u8bc1\u7801:" + msgvrfy + "\uff08\u6cc4\u6f0f\u6709\u98ce\u9669\uff09\uff0c\u60a8\u4e8e" + hour + "\u65f6" + minute + "\u5206\u7533\u8bf7\u5f00\u901a\u5c3e\u53f7\u4e3a" + tailno + "\u7684\u94f6\u884c\u5361\u8de8\u884c\u6536\u6b3e\u4e1a\u52a1";
                javaDict.set("content", (Object)content);
                YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)content);
                return YuinResult.newSuccessResult(null);
            }
            YuinLogUtils.getInst((Object)this).info("\u4e0d\u751f\u6210\uff0c\u4e0d\u53d1\u9001");
            javaDict.set("sendmsgflag", (Object)"0");
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u83b7\u53d6\u77ed\u4fe1\u5185\u5bb9\u5f02\u5e38");
            return YuinResult.newFailureResult((String)"S9400", (String)"\u83b7\u53d6\u77ed\u4fe1\u5185\u5bb9\u5f02\u5e38");
        }
    }

    public YuinResult getmsgvrfy(JavaDict javaDict, String busidate, String ptcchnl, String protocolno) {
        try {
            String msgvrfy = String.valueOf((int)(Math.random() * 9.0 + 1.0) * 100000);
            UpMChkvrfyVo upMChkvrfyVo = new UpMChkvrfyVo();
            upMChkvrfyVo.setSysid(javaDict.getString("sysid"));
            upMChkvrfyVo.setSysid(javaDict.getString("appid"));
            upMChkvrfyVo.setProtocolno(protocolno);
            upMChkvrfyVo.setBusidate(busidate);
            upMChkvrfyVo.setWorktime(javaDict.getString("worktime"));
            upMChkvrfyVo.setMsgvrfy(msgvrfy);
            upMChkvrfyVo.setPtcchnl(ptcchnl);
            List<UpMChkvrfyVo> list = this.upMChkvrfyRepo.getAllInfo(upMChkvrfyVo);
            if (list.size() > 0) {
                this.upMChkvrfyRepo.updateById(upMChkvrfyVo);
            } else {
                int result = this.upMChkvrfyRepo.save(upMChkvrfyVo);
                if (result == 1) {
                    YuinLogUtils.getInst((Object)this).info("\u9a8c\u8bc1\u7801\u751f\u6210\u6210\u529f");
                }
            }
            javaDict.set("msgvrfy", (Object)msgvrfy);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).error("\u83b7\u53d6\u5c0f\u989d\u89c4\u5219\u8868\u6570\u636e\u5f02\u5e38");
            return YuinResult.newFailureResult((String)"S9400", (String)"\u83b7\u53d6\u5c0f\u989d\u89c4\u5219\u8868\u6570\u636e\u5f02\u5e38");
        }
    }

    public YuinResult getNMInputCtrl(JavaDict javaDict) {
        String[] listInputctrl = new String[]{"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"};
        if ("06".equals(javaDict.getString("chnlcode")) && "NPS.372.001.01".equals(javaDict.getString("msgtype"))) {
            listInputctrl[0] = "1";
        }
        if (!"".equals(javaDict.getString("chkflg"))) {
            if (!"NPS.372.001.01".equals(javaDict.getString("msgtype")) && "Y".equals(javaDict.getString("chkflg").substring(1, 2))) {
                listInputctrl[1] = "1";
            }
            if ("Y".equals(javaDict.getString("chkflg").substring(2, 3))) {
                listInputctrl[10] = "1";
            }
            if ("Y".equals(javaDict.getString("chkflg").substring(3, 4))) {
                listInputctrl[2] = "1";
            }
        }
        javaDict.set("inputctrl", (Object)String.valueOf(listInputctrl));
        YuinLogUtils.getInst((Object)this).error("\u670d\u52a1\u516c\u5171\u8f93\u5165\u63a7\u5236\u6807\u5fd7\u6237\u540dinputctrl:{}", (Object)javaDict.getString("inputctrl"));
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult busiTrustGetMsgContent(JavaDict javaDict) {
        String sCardNo = javaDict.getString("payeraccno").substring(javaDict.getString("payeraccno").length() - 4);
        javaDict.set("content", (Object)("\u60a8\u5c3e\u53f7" + sCardNo + "\u7684\u5361\u7247\u7b7e\u7ea6\u7533\u8bf7\u5df2\u751f\u6548\uff0c\u8bf7\u60a8\u5728\u4e03\u4e2a\u5de5\u4f5c\u65e5\u5185\u8fd4\u56de\u7b7e\u7ea6\u786e\u8ba4\u7ed3\u679c"));
        if ("BUP14074".equals(javaDict.getString("tradecode"))) {
            javaDict.set("content", (Object)("\u60a8\u5c3e\u53f7" + sCardNo + "\u7684\u5361\u7247\u89e3\u7ea6\u7533\u8bf7\u5df2\u751f\u6548\uff0c\u8bf7\u60a8\u5728\u4e03\u4e2a\u5de5\u4f5c\u65e5\u5185\u8fdb\u884c\u89e3\u7ea6\u786e\u8ba4"));
            YuinLogUtils.getInst((Object)this).info("\u77ed\u4fe1\u5185\u5bb9content:{}", (Object)javaDict.getString("content"));
        }
        javaDict.set("sendmsgflag", (Object)"1");
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getOneBusiMap(JavaDict javaDict) {
        if ("BEPS".equals(javaDict.getString("appid")) && "1".equals(javaDict.getString("sysflag")) && "A105".equals(javaDict.getString("busitype"))) {
            javaDict.set("busitype", (Object)"00108");
            javaDict.set("mainclass", (Object)"00108");
            if ("02108".equals(javaDict.getString("busikind"))) {
                javaDict.remove("busikind");
            }
        }
        if ("HVPS".equals(javaDict.getString("appid")) && "1".equals(javaDict.getString("sysflag")) && "A105".equals(javaDict.getString("busitype"))) {
            javaDict.set("busitype", (Object)"CMT108");
            javaDict.set("mainclass", (Object)"CMT108");
            if ("02108".equals(javaDict.getString("busikind"))) {
                javaDict.remove("busikind");
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getNMGetPaySelProtocol(JavaDict javaDict) {
        try {
            if ("MT02".equals(javaDict.getString("protocoloptype"))) {
                ProtoSignReqDto protoSignReqDto = new ProtoSignReqDto();
                protoSignReqDto.setSysid(javaDict.getString("sysid"));
                protoSignReqDto.setAppid(javaDict.getString("appid"));
                protoSignReqDto.setPrototype(javaDict.getString("tradecode"));
                String protoinfo = javaDict.getString("protoinfo", "");
                JSONObject protoinfomap = JSON.parseObject((String)protoinfo);
                protoSignReqDto.setProtoinfo((Map)protoinfomap);
                YuinResultDto yuinResultDto = this.paySignClient.protoSign(protoSignReqDto);
            } else {
                ProtoChangeReqDto protoChangeReqDto = new ProtoChangeReqDto();
                protoChangeReqDto.setAppid(javaDict.getString("appid"));
                protoChangeReqDto.setSysid(javaDict.getString("sysid"));
                protoChangeReqDto.setProtono(javaDict.getString("protocolno"));
                protoChangeReqDto.setPrototype("UPPT0301");
                YuinResultDto yuinResultDto = this.paySignClient.protoChange(protoChangeReqDto);
            }
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            return YuinResult.newSuccessResult(null);
        }
    }

    public String getHeadMsg(JavaDict request, List<String> inParam) {
        String clearBank = "";
        try {
            if ("BUP99007".equals(request.getString("tradecode"))) {
                clearBank = inParam.get(1).startsWith("#") ? inParam.get(1).substring(1) : request.getString(inParam.get(1));
                return clearBank;
            }
            if (!request.hasKey(inParam.get(0))) {
                clearBank = inParam.get(1).startsWith("#") ? inParam.get(1).substring(1) : request.getString(inParam.get(1));
                return clearBank;
            }
            clearBank = request.getString(inParam.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clearBank;
    }
}

