/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.domain.service.pub;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpBPkginfoRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpDPkgruleRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpBPkginfoVo;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpDPkgruleVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.StringUtilEx;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.payment.common.component.business.service.TradeInitService;
import cn.com.yusys.yusp.payment.common.flow.domain.constant.ETradeBusiStep;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPPGetBepsService {
    @Autowired
    private UpDPkgruleRepo upDPkgruleRepo;
    @Autowired
    private TradeInitService tradeInitService;
    @Autowired
    private UpBPkginfoRepo upBPkginfoRepo;

    public YuinResult getBepsSeqMsgid(JavaDict request) {
        String msgtype = request.getString("__sendmsgtype__");
        String busitype = request.getString("busitype", "PUB");
        YuinLogUtils.getInst((Object)this).info("{}|\u5c0f\u989d\u7cfb\u7edf\u83b7\u53d6\u62a5\u6587\u6807\u8bc6\u53f7\u65f6\u68c0\u67e5\u53d1\u5305\u89c4\u5219 msgtype[{}] busitype[{}]", new Object[]{request.getString("logPrefix", ""), msgtype, busitype});
        if (StringUtilEx.isNullOrEmpty((String)msgtype)) {
            return YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)String.format("\u7b2c\u4e09\u65b9\u62a5\u6587\u7c7b\u578b[%s]\u672a\u914d\u7f6e", "__sendmsgtype__")));
        }
        YuinResult result = this.getBepsPkgRule(request, msgtype, busitype);
        if (!result.isSuccess()) {
            return result;
        }
        JavaDict packrule = request.getDict("__packrule__");
        String rulemsgtype = packrule.getString("__msgtype__");
        String rulebusitype = packrule.getString("__busitype__");
        String seqmod = packrule.getString("__seqmod__");
        String crtpackrule = packrule.getString("__crtpackrule__");
        String sndpackrule = packrule.getString("__sndpackrule__");
        String maxwaittime = packrule.getString("__maxwaittime__");
        String forcessndtime = packrule.getString("__forcessndtime__");
        String countsum = packrule.getString("__countsum__");
        if ("1".equals(sndpackrule)) {
            request.set("crtmsgid", (Object)this.tradeInitService.getSeqMsgid(request.getString("appid"), request.getString("busidate", request.getString("__busidate__")), request.getString("sendclearbank"), request.getString("crtdetailno")));
            YuinLogUtils.getInst((Object)this).info("{}|\u5f53\u524d\u4ea4\u6613\u53d1\u5305\u89c4\u5219\u4e3a[1-\u5b9e\u65f6\u5355\u7b14\u53d1\u9001], \u76f4\u63a5\u751f\u6210\u62a5\u6587\u6807\u8bc6\u53f7[{}][{}]", new Object[]{request.getString("logPrefix", ""), "crtmsgid", request.getString("crtmsgid")});
            return YuinResult.newSuccessResult(null);
        }
        YuinLogUtils.getInst((Object)this).info("{}|\u5f53\u524d\u4ea4\u6613\u53d1\u5305\u89c4\u5219\u4e3a[0-\u5b9a\u65f6\u8fbe\u91cf], \u67e5\u8be2\u662f\u5426\u5b58\u5728\u521d\u59cb\u72b6\u6001\u7684\u5305\u4fe1\u606f", (Object)request.getString("logPrefix", ""));
        String seqMsgid = "";
        UpBPkginfoVo upBPkginfoVoSel = new UpBPkginfoVo();
        upBPkginfoVoSel.setSysid(request.getString("sysid"));
        upBPkginfoVoSel.setAppid(request.getString("appid"));
        upBPkginfoVoSel.setMsgtype(rulemsgtype);
        upBPkginfoVoSel.setBusitype(rulebusitype);
        upBPkginfoVoSel.setRecvclearbank(request.getString("recvclearbank"));
        upBPkginfoVoSel.setPackstatus("0");
        upBPkginfoVoSel.setPacklimitcount(countsum);
        List<UpBPkginfoVo> upBPkginfoVoList = this.upBPkginfoRepo.selectListPackDeal(upBPkginfoVoSel);
        if (upBPkginfoVoList.size() < 1) {
            seqMsgid = request.getString("crtmsgid", this.tradeInitService.getSeqMsgid(request.getString("appid"), request.getString("busidate"), request.getString("sendclearbank"), null));
            YuinLogUtils.getInst((Object)this).info("{}|\u672a\u67e5\u5230\u521d\u59cb\u72b6\u6001\u7684\u5305\u4fe1\u606f, \u767b\u8bb0\u65b0\u7684\u5305\u4fe1\u606f, \u5e76\u751f\u6210\u65b0\u7684\u62a5\u6587\u6807\u8bc6\u53f7:[{}]", (Object)request.getString("logPrefix", ""), (Object)seqMsgid);
            result = this.insPkginfo(request, seqmod, maxwaittime, seqMsgid, rulemsgtype, rulebusitype, countsum);
            if (!result.isSuccess()) {
                return result;
            }
        } else {
            seqMsgid = upBPkginfoVoList.get(0).getMsgid();
            YuinLogUtils.getInst((Object)this).info("{}|\u5df2\u67e5\u5230\u521d\u59cb\u72b6\u6001\u7684\u5305\u4fe1\u606f, \u8bfb\u53d6\u62a5\u6587\u6807\u8bc6\u53f7:[{}], \u5e76\u66f4\u65b0\u5305\u767b\u8bb0\u7b14\u6570packcount+1", (Object)request.getString("logPrefix", ""), (Object)seqMsgid);
            UpBPkginfoVo upBPkginfoVoUpd = new UpBPkginfoVo();
            upBPkginfoVoUpd.setMsgid(upBPkginfoVoList.get(0).getMsgid());
            upBPkginfoVoUpd.setMsgtype(upBPkginfoVoList.get(0).getMsgtype());
            upBPkginfoVoUpd.setSendclearbank(upBPkginfoVoList.get(0).getSendclearbank());
            upBPkginfoVoUpd.setMbflag(upBPkginfoVoList.get(0).getMbflag());
            upBPkginfoVoUpd.setPackstatus(upBPkginfoVoList.get(0).getPackstatus());
            int i = this.upBPkginfoRepo.updatePackcount(upBPkginfoVoUpd, Boolean.TRUE);
            if (i != 1) {
                seqMsgid = request.getString("crtmsgid", this.tradeInitService.getSeqMsgid(request.getString("appid"), request.getString("busidate"), request.getString("sendclearbank"), null));
                YuinLogUtils.getInst((Object)this).info("{}|\u66f4\u65b0\u5931\u8d25, \u767b\u8bb0\u65b0\u7684\u5305\u4fe1\u606f, \u5e76\u751f\u6210\u65b0\u7684\u62a5\u6587\u6807\u8bc6\u53f7:[{}]==========", (Object)request.getString("logPrefix", ""), (Object)seqMsgid);
                result = this.insPkginfo(request, seqmod, maxwaittime, seqMsgid, rulemsgtype, rulebusitype, countsum);
                if (!result.isSuccess()) {
                    return result;
                }
            }
        }
        request.set("crtmsgid", (Object)seqMsgid);
        YuinLogUtils.getInst((Object)this).info("{}|\u5c0f\u989d\u7cfb\u7edf\u5f53\u524d\u4ea4\u6613\u83b7\u53d6\u62a5\u6587\u6807\u8bc6\u53f7[{}][{}]", new Object[]{request.getString("logPrefix", ""), "crtmsgid", request.getString("crtmsgid")});
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getBepsPkgRule(JavaDict request, String msgtype, String busitype) {
        UpDPkgruleVo upDPkgruleVo = new UpDPkgruleVo();
        upDPkgruleVo.setMsgtype(msgtype);
        String seqmod = this.getBepsPackSeqmod(msgtype, busitype, request.getString("origtradecode"));
        if (!StringUtils.isBlank((CharSequence)seqmod)) {
            upDPkgruleVo.setSeqmod(seqmod);
        }
        List<UpDPkgruleVo> list = this.upDPkgruleRepo.selectListByMsgtype(upDPkgruleVo);
        UpDPkgruleVo upDPkgruleVoRes = null;
        boolean intPower = false;
        for (UpDPkgruleVo upDPkgruleVotmp : list) {
            if ("PUB".equals(upDPkgruleVotmp.getBusitype()) && !intPower) {
                upDPkgruleVoRes = upDPkgruleVotmp;
                continue;
            }
            if ("PUB".equals(upDPkgruleVotmp.getBusitype()) || intPower >= true || !msgtype.equals(upDPkgruleVotmp.getBusitype())) continue;
            intPower = true;
            upDPkgruleVoRes = upDPkgruleVotmp;
        }
        if (upDPkgruleVoRes == null) {
            return YuinResult.newFailureResult((String)"S9001", (String)String.format("\u7ec4\u5305\u89c4\u5219\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5\u62a5\u6587[%s]\u53ca\u4e1a\u52a1\u7c7b\u578b[%s]\u76f8\u5339\u914d\u7684\u914d\u7f6e", msgtype, busitype));
        }
        JavaDict packrule = new JavaDict();
        packrule.set("__msgtype__", (Object)upDPkgruleVoRes.getMsgtype());
        packrule.set("__busitype__", (Object)upDPkgruleVoRes.getBusitype());
        packrule.set("__seqmod__", (Object)upDPkgruleVoRes.getSeqmod());
        packrule.set("__crtpackrule__", (Object)upDPkgruleVoRes.getCrtpackrule());
        packrule.set("__sndpackrule__", (Object)upDPkgruleVoRes.getSndpackrule());
        packrule.set("__maxwaittime__", (Object)upDPkgruleVoRes.getMaxwaittime());
        packrule.set("__forcessndtime__", (Object)upDPkgruleVoRes.getForcessndtime());
        packrule.set("__countsum__", (Object)upDPkgruleVoRes.getCountsum());
        request.set("__packrule__", (Object)packrule);
        return YuinResult.newSuccessResult(null);
    }

    private String getBepsPackSeqmod(String msgtype, String busitype, String origtradecode) {
        if ("PKG008".equals(msgtype)) {
            if ("UPP01065".equals(origtradecode)) {
                return "1";
            }
            return "2";
        }
        if ("beps.127.001.01".equals(msgtype) && "B308".equals(busitype)) {
            return "3";
        }
        return null;
    }

    private YuinResult insPkginfo(JavaDict request, String seqmod, String maxwaittime, String seqMsgid, String msgtype, String busitype, String countsum) {
        UpBPkginfoVo upBPkginfoVoIns = new UpBPkginfoVo();
        upBPkginfoVoIns.setSysid(request.getString("sysid"));
        upBPkginfoVoIns.setAppid(request.getString("appid"));
        upBPkginfoVoIns.setWorkdate(request.getString("workdate"));
        upBPkginfoVoIns.setWorktime(request.getString("worktime"));
        upBPkginfoVoIns.setTradecode(request.getString("tradecode"));
        upBPkginfoVoIns.setBusidate(request.getString("busidate"));
        upBPkginfoVoIns.setCommsgid(request.getString("crtcommsgid"));
        upBPkginfoVoIns.setMsgid(seqMsgid);
        upBPkginfoVoIns.setMsgtype(msgtype);
        upBPkginfoVoIns.setBusitype(busitype);
        upBPkginfoVoIns.setMbflag(request.getString("mbflag"));
        upBPkginfoVoIns.setDcflag(request.getString("dcflag"));
        upBPkginfoVoIns.setSendclearbank(request.getString("sendclearbank"));
        upBPkginfoVoIns.setRecvclearbank(request.getString("recvclearbank"));
        upBPkginfoVoIns.setOrigentrustdate(request.getString("origentrustdate"));
        upBPkginfoVoIns.setOrigmsgtype(request.getString("origmsgtype"));
        upBPkginfoVoIns.setOrigmsgid(request.getString("origmsgid"));
        upBPkginfoVoIns.setOrigcountsum(request.getString("origcountsum"));
        upBPkginfoVoIns.setOrigrecvclearbank(request.getString("origrecvclearbank"));
        upBPkginfoVoIns.setOrigsendclearbank(request.getString("origsendclearbank"));
        upBPkginfoVoIns.setEntrustdate(request.getString("entrustdate"));
        upBPkginfoVoIns.setCurcode(request.getString("curcode"));
        upBPkginfoVoIns.setAmountsum(BigDecimal.ZERO);
        upBPkginfoVoIns.setCountsum("0");
        upBPkginfoVoIns.setPkgsucamt(BigDecimal.ZERO);
        upBPkginfoVoIns.setPkgsuccount("0");
        upBPkginfoVoIns.setTradebusistep(ETradeBusiStep.TRADEBUSISTEP_INIT.getCode());
        upBPkginfoVoIns.setPackstatus("0");
        upBPkginfoVoIns.setSeqmod(seqmod);
        upBPkginfoVoIns.setBatcnt(request.getString("batcnt"));
        upBPkginfoVoIns.setPacklimitcount(countsum);
        upBPkginfoVoIns.setPackcount("1");
        upBPkginfoVoIns.setPackdate(request.getString("workdate"));
        upBPkginfoVoIns.setPacktime(request.getString("worktime"));
        upBPkginfoVoIns.setMaxwaittime(maxwaittime);
        upBPkginfoVoIns.setSysflag(request.getString("sysflag"));
        upBPkginfoVoIns.setRespperiod(request.getString("respperiod"));
        int i = this.upBPkginfoRepo.save(upBPkginfoVoIns);
        if (i != 1) {
            return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u767b\u8bb0\u5305\u4fe1\u606f\u5931\u8d25:[%s]", seqMsgid));
        }
        YuinLogUtils.getInst((Object)this).info("{}|\u65b0\u589e\u521d\u59cb\u72b6\u6001\u7684\u5305\u4fe1\u606f{}\u6761[{}]", new Object[]{request.getString("logPrefix", ""), i, seqMsgid});
        return YuinResult.newSuccessResult(null);
    }
}

