/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.domain.service.pub;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.stereotype.Service;

@Service
public class UPPFileService {
    public String listFileToString(List<Map<String, Object>> fileinfolist, String[] fieldstrs, String fieldsplitstr, String rowsplitstr) {
        StringBuilder sbfileinfo = new StringBuilder();
        for (Map<String, Object> rowinfomap : fileinfolist) {
            for (String fieldstr : fieldstrs) {
                sbfileinfo.append(rowinfomap.getOrDefault(fieldstr, "").toString());
                sbfileinfo.append(fieldsplitstr);
            }
            sbfileinfo.append(rowsplitstr);
        }
        return sbfileinfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YuinResult writeFileContext(String filename, String context) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(filename);
            bw = new BufferedWriter(fw);
            bw.write(context);
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            YuinResult yuinResult = YuinResult.newFailureResult((String)"S1003", (String)PayErrorCode.getErrmsgAdd((String)"S1003", (String)filename));
            return yuinResult;
        }
        finally {
            try {
                bw.close();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return YuinResult.newFailureResult((String)"S1005", (String)PayErrorCode.getErrmsgAdd((String)"S1005", (String)filename));
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult isFileEx(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return YuinResult.newSuccessResult(null);
        }
        return YuinResult.newFailureResult((String)"S1006", (String)String.format("\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a%s", filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YuinResult ftpFileUpload(String ip, int port, String username, String password, String uploadfile, String dstpath) {
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(5000);
        ftp.setControlEncoding("utf-8");
        ftp.enterLocalPassiveMode();
        FileInputStream input = null;
        try {
            ftp.connect(ip, port);
            if (!ftp.login(username, password)) {
                throw new Exception("FTP\u7528\u6237\u540d\u5bc6\u7801\u914d\u7f6e\u6709\u8bef\u5bfc\u81f4\u767b\u9646\u5931\u8d25");
            }
            input = new FileInputStream(uploadfile);
            if (!ftp.changeWorkingDirectory(dstpath)) {
                if (!ftp.makeDirectory(dstpath)) {
                    throw new Exception("FTP\u8fdc\u7aef\u76ee\u6807\u8def\u5f84\u4e0d\u5b58\u5728\u4e14\u65b0\u5efa\u5f02\u5e38");
                }
                ftp.changeWorkingDirectory(dstpath);
            }
            ftp.setFileType(2);
            if (!ftp.storeFile(new File(uploadfile).getName(), (InputStream)input)) {
                throw new Exception("FTP\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinResult yuinResult = YuinResult.newFailureResult((String)"E1901", (String)PayErrorCode.getErrmsgAdd((String)"E1901", (String)e.getMessage()));
            return yuinResult;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (ftp.isConnected()) {
                    ftp.logout();
                    ftp.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return YuinResult.newFailureResult((String)"S9999", (String)PayErrorCode.getErrmsgAdd((String)"S9999", (String)e.getMessage()));
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YuinResult ftpFileDownload(String ip, int port, String username, String password, String downloadfile, String dstpath) {
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(5000);
        ftp.setControlEncoding("utf-8");
        ftp.enterLocalPassiveMode();
        FileOutputStream output = null;
        try {
            ftp.connect(ip, port);
            if (!ftp.login(username, password)) {
                throw new Exception("FTP\u7528\u6237\u540d\u5bc6\u7801\u914d\u7f6e\u6709\u8bef\u5bfc\u81f4\u767b\u9646\u5931\u8d25");
            }
            ftp.setFileType(2);
            String localfilename = new File(downloadfile).getName();
            File file = new File(dstpath + localfilename);
            output = new FileOutputStream(file);
            if (!ftp.retrieveFile(downloadfile, (OutputStream)output)) {
                throw new Exception("FTP\u8fdc\u7aef\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinResult yuinResult = YuinResult.newFailureResult((String)"S9002", (String)e.getMessage());
            return yuinResult;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (ftp.isConnected()) {
                    ftp.logout();
                    ftp.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return YuinResult.newFailureResult((String)"S9002", (String)e.getMessage());
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult fileCreatOrDel(List<String> fileList, boolean flag) {
        Object result = null;
        try {
            if (flag) {
                for (String path : fileList) {
                    File file = new File(path);
                    String warnHint = String.format("%s\u6587\u4ef6\u5df2\u5b58\u5728", path);
                    if (file.exists() && file.isFile()) {
                        return YuinResult.newFailureResult((String)"S1999", (String)PayErrorCode.getErrmsgAdd((String)"S1999", (String)warnHint));
                    }
                    file.createNewFile();
                }
            }
            for (String path : fileList) {
                File file = new File(path);
                String warnHint = String.format("%s\u6587\u4ef6\u4e0d\u5b58\u5728", path);
                if (!file.exists() || !file.isFile()) {
                    return YuinResult.newFailureResult((String)"S1999", (String)PayErrorCode.getErrmsgAdd((String)"S1006", (String)warnHint));
                }
                if (!file.exists() || !file.isFile()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst((Object)this).error("\u6587\u4ef6\u521b\u5efa/\u5220\u9664\u5f02\u5e38", (Throwable)e);
            String warnHint = String.format("\u6587\u4ef6\u521b\u5efa/\u5220\u9664\u5f02\u5e38:%s", e.getMessage());
            return YuinResult.newFailureResult((String)"S1001", (String)warnHint);
        }
        return YuinResult.newSuccessResult(null);
    }
}

