/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g52;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g52.UPP52000SubService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP52000Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private OrigInfoService origInfoService;
    @Autowired
    private UPP52000SubService upp52000SubService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.upp52000SubService.initIBPS601AddFlag(request);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        String __sel_originfo__ = null;
        String __map_originfo__ = null;
        switch (addflag) {
            case "1": {
                __sel_originfo__ = "sel_tranjnl_52100_csr";
                __map_originfo__ = "map_bup52100_csr";
                break;
            }
            case "2": 
            case "5": {
                __sel_originfo__ = "sel_tranjnl_52100_02";
                __map_originfo__ = "map_bup_52100_02";
                break;
            }
            case "3": {
                __sel_originfo__ = "sel_bupmtranjnl_52100_03";
                __map_originfo__ = "map_bup_52100_03";
                break;
            }
            case "4": {
                __sel_originfo__ = "sel_bupmtranjnl_52100_4";
                __map_originfo__ = "map_bup52100_4";
                break;
            }
            default: {
                return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u67e5\u8be2\u539f\u4e1a\u52a1\u9519\u8befaddflag:[%s]", addflag));
            }
        }
        UPP52000Service uPP52000Service = this;
        String localIp = uPP52000Service.uppGetService.getLinuxLocalIp();
        request.set("localip", (Object)localIp);
        request.set("createtime", (Object)request.getString("workdate").concat(request.getString("worktime")));
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        try {
            YuinResult yuinResult = this.uppChkService.chkRetRemittance(request);
        }
        catch (Exception e) {
            YuinLogUtils.getInst((Object)this).info("{}|\u9519\u8bef\u4fe1\u606f: {}", request.get("logPrefix"), (Object)e.getStackTrace());
            return YuinResult.newFailureResult((String)"S9400", (String)"\u6302\u8d26\u9000\u6c47\u6821\u9a8c\u9519\u8bef ");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

