/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g50;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g50.UPP50004SubService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.DataProcService;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.chnlrsp.ChnlRspFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.chnlrsp.inter.IChnlRspTradeMethod;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UPP50004Service
implements IChnlRspTradeMethod {
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPInitService uppInitService;
    @Resource
    private OrigInfoService origInfoService;
    @Resource
    private DataProcService dataProcService;
    @Resource
    private UPP50004SubService upp50004SubService;
    @Resource
    private ChnlRspFlowService chnlRspFlowService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.chnlRspFlowService.tradeExec(yuinRequestDto, (IChnlRspTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = null;
        if ("IBPS".equals(request.getString("appid"))) {
            String localIp = UPPGetService.getLinuxLocalIp();
            request.set("__LOCALIP__", (Object)localIp);
            List<String> listInParam = Arrays.asList("cancelmsgid", "corpstatus", "mbflag", "corperrcode");
            result = this.uppInitService.initIBP308AddFlag(request, listInParam);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        if ("BEPS".equals(request.getString("appid"))) {
            JavaDict originfo = new JavaDict();
            this.origInfoService.getOrigInfoMap(request, originfo, "sel_bupmmsgjnl_50004", "map_bup50004");
            JavaDict cancelDict = new JavaDict();
            this.origInfoService.getOrigInfoMap(request, cancelDict, "sel_bupbcancel_50004", "map_bupbcancel_50004");
            List<String> inParam = Arrays.asList("#1", "msgid");
            List<String> outParam = Arrays.asList("busidate", "__submsgid__");
            this.uppInitService.initInBusinessDate(request, inParam, outParam);
            List<String> inStepParam = Arrays.asList("sysflag", "corpstatus", "returnflag");
            this.upp50004SubService.initBUP50004(request, inStepParam);
        }
        if ("IBPS".equals(request.getString("appid"))) {
            if (request.hasKey("addflag") && request.getString("addflag").equals("3")) {
                JavaDict origInfo = new JavaDict();
                this.origInfoService.getOrigInfoMap(request, origInfo, "sel_bupmmsgjnl_50004_01", "map_bup50004_01");
                JavaDict cancelOrigInfo = new JavaDict();
                this.origInfoService.getOrigInfoMap(request, cancelOrigInfo, "sel_bupmtranjnl_50004_02", "map_bup50004_03");
            } else if (request.getString("addflag").equals("1")) {
                JavaDict bepsOriginfo = new JavaDict();
                this.origInfoService.getOrigInfoMap(request, bepsOriginfo, "sel_bupmmsgjnl_50004_01", "map_bup50004_01");
            }
            List<String> listInParam = Arrays.asList("corperrcode", "#O9010", "corperrmsg", "#\u4e2d\u5fc3\u62d2\u7edd", "corpstatus", "#PR01");
            result = this.uppChkService.chkDefRspErrInfo(request, listInParam);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        if ("IBPS".equals(request.getString("appid"))) {
            YuinResult result = this.uppChkService.chkVerifierResult(request);
            if (!result.isSuccess()) {
                return result;
            }
            List<String> inParam = Arrays.asList("corperrcode", "#O9010", "corperrmsg", "#\u4e2d\u5fc3\u62d2\u7edd", "corpstatus", "#PR01");
            result = this.uppChkService.chkDefRspErrInfo(request, inParam);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        YuinResult result = null;
        try {
            result = this.dataProcService.updMainjnlByStepCtrl(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!result.isSuccess()) {
            return result;
        }
        if ("IBPS".equals(request.getString("appid"))) {
            result = this.upp50004SubService.hostRev50004(request);
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

