/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkBepsService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.payment.common.component.business.service.PubInitService;
import cn.com.yusys.yusp.payment.common.component.business.service.TradeInitService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPInitadmService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import cn.com.yusys.yusp.payment.common.flow.domain.tools.Tools;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15031Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private UPPChkBepsService uppChkBepsService;
    @Autowired
    private UpPInitadmService upPInitadmService;
    @Resource
    private TradeInitService tradeInitService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.uppGetService.getDictMap(request, "sysid,appid,#getAddflag,#M,tradecode,recvtype", "addflag");
        if (!result.isSuccess()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        String logPrefix = request.getString("logPrefix", "");
        if (!"0".equals(request.getString("addflag"))) {
            try {
                YuinLogUtils.getInst((Object)this).info("{}|{}", (Object)logPrefix, (Object)"UPP15031\u4ea4\u6613\u6839\u636eappflag\u91cd\u65b0\u521d\u59cb\u5316\u4fe1\u606f");
                JavaDict tradeValue = this.upPInitadmService.initAdmin(request, request.getString("sysid"), request.getString("appid"), request.getString("tradecode"), "UPP15031", "PUB", request.getString("addflag"), Boolean.FALSE);
                request.set((IDict)tradeValue);
                request.set((IDict)Tools.dealKeyValue((Object)this, (String)logPrefix, (JavaDict)tradeValue));
            }
            catch (Exception e) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u6839\u636eaddflag\u521d\u59cb\u5316\u5f02\u5e38");
            }
        }
        YuinResult result = new YuinResult();
        switch (addflag) {
            case "1": {
                result = this.pubInitService.getBrnoInfo(request);
                if (!result.isSuccess()) {
                    return result;
                }
                List<String> inParam = Arrays.asList("#1", "msgid");
                List<String> outParam = Arrays.asList("busidate", "__submsgid__");
                result = this.uppInitService.initInBusinessDate(request, inParam, outParam);
                if (!result.isSuccess()) {
                    return result;
                }
                String[] bankStrArr = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
                String[] bankNameStrArr = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
                try {
                    result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
                    if (!result.isSuccess()) {
                        return result;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
                }
            }
            case "2": {
                result = this.pubInitService.getBrnoInfo(request);
                if (!result.isSuccess()) {
                    return result;
                }
                List<String> inParam_2 = Arrays.asList("#1", "msgid");
                List<String> outParam_2 = Arrays.asList("busidate", "__submsgid__");
                result = this.uppInitService.initInBusinessDate(request, inParam_2, outParam_2);
                if (!result.isSuccess()) {
                    return result;
                }
                String[] bankStrArr_2 = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
                String[] bankNameStrArr_2 = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
                try {
                    result = this.upPBankinfoService.getBankName(request, bankStrArr_2, bankNameStrArr_2);
                    if (!result.isSuccess()) {
                        return result;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
                }
            }
        }
        if (!result.isSuccess()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        YuinResult result = new YuinResult();
        switch (addflag) {
            case "1": {
                result = this.uppChkService.chkVerifierResult(request);
                if (result.isSuccess()) break;
                return result;
            }
            case "2": {
                result = this.uppChkService.chkVerifierResult(request);
                if (result.isSuccess()) break;
                return result;
            }
        }
        result = this.uppChkBepsService.chkBUPProtocol(request);
        if (!result.isSuccess()) {
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
            request.set("__hostcommflag__", (Object)"0");
            return YuinResult.newSuccessResult(null);
        }
        result = this.uppChkService.chkVerifierResult(request);
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        if (!"1".equals(request.get("__stepstatus__"))) {
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

