/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15.UPP15051Service;
import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.PubInitService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15022Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    UPP15051Service upp15051Service;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.pubInitService.getBrnoInfo(request);
        if (!result.isSuccess()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String[] inParam = new String[]{"amt", "feeamt"};
        String[] outParam = new String[]{"realtradeamt"};
        YuinResult result = this.uppGetService.getRealTradeAmt(request, inParam, outParam);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.pubInitService.getBrnoInfo(request);
        if (!result.isSuccess()) {
            return result;
        }
        String[] bankStrArr = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
        String[] bankNameStrArr = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = this.uppChkService.chkVerifierResult(request);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        JavaDict hostAcctRsp;
        request.set("status", (Object)"0");
        if (request.hasKey("__host_acct_rsp__") && "000000".equals((hostAcctRsp = (JavaDict)request.get("__host_acct_rsp__")).get("transaction.header.status.retCd"))) {
            request.set("status", (Object)"1");
        }
        YuinResult result = this.uppGetService.getDictMap(request, "sysid,appid,#getRespStatus,#M,msgtype,status", "respstatus");
        return result;
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

