/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.PubInitService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15018Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.uppGetService.getDictMap(request, "sysid,#getAddflag,#M,#UPP15018,respstatus", "addflag");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppGetService.getDictMap(request, "sysid,#getAddflag,#M,#UPP15018,respstatus", "__stepaddflag__");
        if (!result.isSuccess()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        YuinResult result = new YuinResult();
        switch (addflag) {
            case "1": {
                String[] bankStrArr = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payeebank"};
                String[] bankNameStrArr = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payeebankname"};
                try {
                    result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
                    if (!result.isSuccess()) {
                        return result;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
                }
                result = this.pubInitService.getBrnoInfo(request);
                if (!result.isSuccess()) break;
                return result;
            }
            case "2": {
                String[] bankStrArr_2 = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payeebank"};
                String[] bankNameStrArr_2 = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payeebankname"};
                try {
                    result = this.upPBankinfoService.getBankName(request, bankStrArr_2, bankNameStrArr_2);
                    if (!result.isSuccess()) {
                        return result;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
                }
                result = this.pubInitService.getBrnoInfo(request);
                if (!result.isSuccess()) break;
                return result;
            }
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        YuinResult result = new YuinResult();
        switch (addflag) {
            case "1": {
                List<String> inParam = Arrays.asList("detailflag:#0:\u91cd\u590d\u7684\u4e1a\u52a1\u6302\u8d26\u5904\u7406");
                result = this.uppChkService.chkCompValue(request, inParam);
                if (result.isSuccess()) break;
                return result;
            }
            case "2": {
                List<String> inParam_2 = Arrays.asList("detailflag:#0:\u91cd\u590d\u7684\u4e1a\u52a1\u4e0d\u5904\u7406");
                result = this.uppChkService.chkCompValue(request, inParam_2);
                if (result.isSuccess()) break;
                return result;
            }
        }
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return null;
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

