/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.PubInitService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.custom.CustomFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.custom.inter.ICustomTradeMethod;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15014Service
implements ICustomTradeMethod {
    @Autowired
    private CustomFlowService customFlowService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private TradeStatusService tradeStatusService;
    @Resource
    private TradeOperDbService tradeOperDbService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.customFlowService.tradeExec(yuinRequestDto, (ICustomTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCustomDealHandler(JavaDict request) {
        YuinResult result = this.pubInitService.getBrnoInfo(request);
        if (!result.isSuccess()) {
            return result;
        }
        String[] bankStrArr = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payerclearbank", "payeraccbank", "payeebank", "payeeclearbank", "payeeaccbank"};
        String[] bankNameStrArr = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payerclearbankname", "payeraccbankname", "payeebankname", "payeeclearbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        try {
            result = this.tradeStatusService.updateTradeStep(request, request.getString("tradebusistep"), request.getString("__stepstatus__"));
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

