/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g14;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPCrtService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP14061Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPInitService uPPInitService;
    @Resource
    private OrigInfoService origInfoService;
    @Resource
    private UPPCrtService uppCrtService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        if ("MPS".equals(request.getString("appid")) || "IBPS".equals(request.getString("appid"))) {
            YuinResult resultcrt = this.uppGetService.getDictMap(request, "sysid,#getAddflag,#S,#Addflag,protocoloptype", "addflag");
            if (!resultcrt.isSuccess()) {
                return resultcrt;
            }
            resultcrt = this.uppGetService.getBankBrno(request, Arrays.asList("sysid,payeraccbank".split(",")), Arrays.asList("brno"));
            if (!resultcrt.isSuccess()) {
                return resultcrt;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        if ("MPS".equals(request.getString("appid")) || "IBPS".equals(request.getString("appid"))) {
            YuinResult resultcrt = this.uppGetService.getDictMap(request, "sysid,#IBPSTypeChk,#S,#AcctLtdTypeCode,acclmdtype", "acclmdtype");
            if (!resultcrt.isSuccess()) {
                return resultcrt;
            }
            String sysFlag = request.getString("sysflag");
            String inParamStr = "#" + sysFlag + ",msgid";
            resultcrt = this.uPPInitService.initInBusinessDate(request, Arrays.asList(inParamStr.split(",")), Arrays.asList("busidate"));
            if (!resultcrt.isSuccess()) {
                return resultcrt;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult resultcrt;
        if (("MPS".equals(request.getString("appid")) || "IBPS".equals(request.getString("appid"))) && !(resultcrt = this.origInfoService.getOrigInfoMap(request, request, "sel_bupbprotocol_06", "map_bup14061")).isSuccess()) {
            return resultcrt;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        if ("MPS".equals(request.getString("appid")) || "IBPS".equals(request.getString("appid"))) {
            this.uppCrtService.crtIBPSMsgId(request, request.getString("origrecver"), request.getString("busidate"));
            YuinResult resultcrt = this.uppCrtService.crtIBPSUrl(request, Arrays.asList("#https://ebank.nmgnxs.com.cn:467/,#BSNCode=340b,TranId,OlnTranSeqNb,TranAmt,MerchtCd,MerchtNm".split(",")));
            request.set("authinfo", (Object)((String)resultcrt.getOutputParams().get(0)));
            resultcrt = this.uppGetService.getDictMap(request, "sysid,appid,#IBPSChnlMap,#M,#AccType,replyacctype", "replyacctype");
            if (!resultcrt.isSuccess()) {
                return resultcrt;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

