/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g04;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPBatService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkBepsService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPPkgService;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.chnlreq.ChnlReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.chnlreq.inter.IChnlReqTradeMethod;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UPP04014Service
implements IChnlReqTradeMethod {
    @Resource
    private ChnlReqFlowService chnlReqFlowService;
    @Resource
    private UPPBatService uppBatService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private UPPChkBepsService uppChkBepsService;
    @Resource
    private TradeStatusService tradeStatusService;
    @Resource
    private UPPPkgService uppPkgService;
    @Resource
    private UpPBankinfoService upPBankinfoService;

    public YuinResultDto tradeFlow(YuinRequestDto yuinRequestDto) {
        return this.chnlReqFlowService.tradeExec(yuinRequestDto, (IChnlReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppGetService.getMsgtypeMap(request);
        if (!result.isSuccess()) {
            return result;
        }
        String[] bankStrArr = new String[]{"recvbank", "payerbank", "payeraccbank"};
        String[] bankNameStrArr = new String[]{"recvbankname", "payerbankname", "payeraccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppChkService.chkBankTranAuth(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkService.chkBEPTranAuth(request);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        YuinResult result = null;
        try {
            result = this.tradeStatusService.updateTradeStep(request, request.getString("tradebusistep"), request.getString("__stepstatus__"));
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        this.uppPkgService.chkAndDealBepsCorpCom(request);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

