/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g03;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP03062Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result;
        if ("BEPS".equals(request.getString("appid"))) {
            List<String> outParam;
            List<String> inParam = Arrays.asList("#1", "msgid", "pkgdate");
            YuinResult result2 = this.uppInitService.initInBusinessDate(request, inParam, outParam = Arrays.asList("busidate", "__submsgid__"));
            if (!result2.isSuccess()) {
                return result2;
            }
            String[] listInPara = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank", "payeeaccbank", "payeraccbank"};
            String[] listOutPara = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname", "payeeaccbankname", "payeraccbankname"};
            result2 = this.upPBankinfoService.getBankName(request, listInPara, listOutPara);
            if (!result2.isSuccess()) {
                return result2;
            }
            result2 = this.uppGetService.getMsgtypeMap(request);
            if (!result2.isSuccess()) {
                return result2;
            }
            String[] listInpara = "sendclearbank:sendbank,payerbank:recvbank,recvclearbank:payerclearbank,sendclearbank:payeeclearbank".split(",");
            result2 = this.uppInitService.initAddFiledArray(request, listInpara);
            if (!result2.isSuccess()) {
                return result2;
            }
        }
        if ("IBPS".equals(request.getString("appid")) && !(result = this.uppGetService.getDictMap(request, "sysid,appid,#PlateDictMap,#M,#Priority,priority", "priority")).isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        if ("BEPS".equals(request.getString("appid")) && !"04205".equals(request.getString("extbusitype"))) {
            return YuinResult.newFailureResult((String)"E1301", (String)PayErrorCode.getErrmsgAdd((String)"E1301", (String)"\u76ee\u524d\u53ea\u5f00\u901a\u672c\u7968"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        if ("BEPS".equals(request.getString("appid"))) {
            YuinResult result = this.uppGetService.getDictMap(request, "sysid,appid,#ThirdDictMap,#M,#CurCode,curcode", "curcode");
            if (!result.isSuccess()) {
                return result;
            }
            if ("000000".equals(request.getString("bankerrcode"))) {
                request.set("status", (Object)"1");
            }
            if (!(result = this.uppGetService.getDictMap(request, "sysid,appid,#getRespStatus,#M,#beps.132.001.01,status", "respstatus")).isSuccess()) {
                return result;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

