/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g03;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g03.UPP03057SubService;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.service.UpPErrinfoService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankmapService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP03057Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UpPBankmapService upPBankmapService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private OrigInfoService origInfoService;
    @Autowired
    private UPP03057SubService upp03057SubService;
    @Autowired
    private UpPErrinfoService upPErrinfoService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.upPBankmapService.getBankMapByBankno(request, "payeebank", new String[]{"brno", "brname", "clearbrno", "bankno", "bankname"});
        if (result.isSuccess() && result.getOutputParams() != null) {
            request.set("brno", (Object)((JavaDict)result.getOutputParams().get(0)).getString("brno"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = this.uppGetService.getRealTradeAmt(request, new String[]{"clearamt", "agentfee"}, new String[]{"realtradeamt"});
        if (!result.isSuccess()) {
            return result;
        }
        result = this.upPBankinfoService.getBankName(request, new String[]{"payeraccbank", "payerclearbank", "payeeaccbank", "payeeclearbank", "sendbank", "sendclearbank", "recvbank", "recvclearbank"}, new String[]{"payeraccbankname", "payerclearbankname", "payeeaccbankname", "payeeclearbankname", "sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname"});
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppInitService.initGetThirdClearBank(request, "payerclearbank");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = this.uppChkService.chkVerifierResult(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.upp03057SubService.initNCSBUP03053(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.upp03057SubService.chkNCSBUP03057(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppGetService.getNCSPyee(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkService.chkWhitelist(request, "payeeaccno");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result = this.upPErrinfoService.transRetCode(request, "sysid,appid,#PUB,errcode,errmsg,#1");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

