/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g52;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpMAsynjnlRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g52.UPP52000SubService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g52.UPP52100SubService;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpMAsynjnlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.DateUtils;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP52100Service
implements ICorpReqTradeMethod {
    @Autowired
    UpMAsynjnlRepo upMAsynjnlRepo;
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPP52000SubService upp52000SubService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private UPP52100SubService upp52100SubService;
    @Autowired
    private OrigInfoService origInfoService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.upp52000SubService.initIBPS601AddFlag(request);
        if (!result.isSuccess()) {
            return result;
        }
        if ("2".equals(request.getString("addflag"))) {
            String sysTime = DateUtils.getSysDate((String)"yyyyMddHHmmss");
            UpMAsynjnlVo updateMAsynjnlVo = new UpMAsynjnlVo();
            updateMAsynjnlVo.setAppid(request.getString("appid"));
            updateMAsynjnlVo.setSysid(request.getString("sysid"));
            updateMAsynjnlVo.setProcesstime(sysTime);
            updateMAsynjnlVo.setWorkseqid(request.getString("workseqid"));
            updateMAsynjnlVo.setStatus("1");
            Integer updateNum = this.upMAsynjnlRepo.updateStatus(updateMAsynjnlVo);
            if (updateNum == 0) {
                return YuinResult.newFailureResult((String)"S5004", (String)PayErrorCode.getErrmsgAdd((String)"S5004", (String)"\u66f4\u65b0\u65e0\u8bb0\u5f55"));
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        String __sel_originfo__ = null;
        String __map_originfo__ = null;
        switch (addflag) {
            case "1": {
                __sel_originfo__ = "sel_tranjnl_52100_csr";
                __map_originfo__ = "map_bup52100_csr";
                break;
            }
            case "2": 
            case "7": 
            case "5": {
                __sel_originfo__ = "sel_tranjnl_52100_02";
                __map_originfo__ = "map_bup_52100_02";
                break;
            }
            case "3": {
                __sel_originfo__ = "sel_bupmtranjnl_52100_03";
                __map_originfo__ = "map_bup_52100_03";
                break;
            }
            case "4": {
                __sel_originfo__ = "sel_bupmtranjnl_52100_4";
                __map_originfo__ = "map_bup52100_4";
                break;
            }
            default: {
                return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u67e5\u8be2\u539f\u4e1a\u52a1\u9519\u8befaddflag:[%s]", addflag));
            }
        }
        String listInPara = "origmsgid:\u539f\u62a5\u6587\u6807\u8bc6\u53f7,origsendbank:\u539f\u53d1\u8d77\u53c2\u4e0e\u673a\u6784,origmsgtype:\u539f\u62a5\u6587\u7f16\u53f7,corpstatus:\u4e2d\u5fc3\u72b6\u6001,corperrcode:\u4e2d\u5fc3\u62d2\u7edd\u7801,corperrmsg:\u4e2d\u5fc3\u62d2\u7edd\u539f\u56e0,cleardate:\u5904\u7406\u65e5\u671f,nettinground:\u8f67\u5dee\u573a\u6b21";
        String listOutPara = "notifymsg";
        YuinResult result = this.uppGetService.getCrtMsgBLOB(request, listInPara, listOutPara);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        String addflag;
        switch (addflag = request.getString("addflag")) {
            case "1": {
                try {
                    this.uppChkService.chkRetRemittance(request);
                    break;
                }
                catch (Exception e) {
                    YuinLogUtils.getInst((Object)this).info("{}|\u9519\u8bef\u4fe1\u606f: {}", request.get("logPrefix"), (Object)e.getStackTrace());
                    return YuinResult.newFailureResult((String)"S9400", (String)"\u6302\u8d26\u9000\u6c47\u6821\u9a8c\u9519\u8bef ");
                }
            }
            case "2": {
                YuinResult result = this.upp52100SubService.chkBUP5210002CCSScne(request);
                if (result.isSuccess()) break;
                return result;
            }
            default: {
                return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u67e5\u8be2\u539f\u4e1a\u52a1\u9519\u8befaddflag:[%s]", addflag));
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        YuinResult result;
        request.set("tradecode", (Object)(request.getString("origtradecode") + "|" + request.getString("tradecode")));
        String addflag = request.getString("addflag");
        if ("1".equals(addflag) || "4".equals(addflag)) {
            YuinResult result2 = this.upp52100SubService.IBPS90001(request);
            if (!result2.isSuccess()) {
                return YuinResult.newFailureResult((String)"E9008", (String)PayErrorCode.getErrmsg((String)"\u8c03\u7528IBPS90001\u5b50\u4ea4\u6613\u5931\u8d25"));
            }
        } else if ("2".equals(addflag) || "5".equals(addflag)) {
            YuinResult result3 = this.upp52100SubService.IBPS90002(request);
            if (!result3.isSuccess()) {
                return YuinResult.newFailureResult((String)"E9008", (String)PayErrorCode.getErrmsg((String)"\u8c03\u7528IBPS90002\u5b50\u4ea4\u6613\u5931\u8d25"));
            }
        } else if (("3".equals(addflag) || "7".equals(addflag)) && !(result = this.upp52100SubService.IBPS90003(request)).isSuccess()) {
            return YuinResult.newFailureResult((String)"E9008", (String)PayErrorCode.getErrmsg((String)"\u8c03\u7528IBPS90003\u5b50\u4ea4\u6613\u5931\u8d25"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

