/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g50;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g50.UPP50051SubService;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.service.UpPErrinfoService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP50051Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPInitService uppInitService;
    @Resource
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private OrigInfoService origInfoService;
    @Resource
    private UPP50051SubService upp50051SubService;
    @Autowired
    private UpPErrinfoService upPErrinfoService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult resultcrt = this.uppGetService.getBankBrno(request, Arrays.asList("sysid,recvbank".split(",")), Arrays.asList("brno"));
        if (!resultcrt.isSuccess()) {
            return resultcrt;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String[] bankNo = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank"};
        String[] bankName = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname"};
        try {
            YuinResult result = this.upPBankinfoService.getBankName(request, bankNo, bankName);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        List<String> inCodeParam = Arrays.asList("verifierResultCode", "#0000");
        YuinResult result = this.uppChkService.chkVerifierResult(request);
        if (!result.isSuccess()) {
            return result;
        }
        JavaDict origInfo = new JavaDict();
        result = this.origInfoService.getOrigInfoMap(request, origInfo, "sel_bupmtranjnl_msg", "map_bup50051_01");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.upp50051SubService.errorcheckcom(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkService.chkOrigInfo(request, "origInfo", "chk_bup03054");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

