/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g22;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkCupService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPCupSignService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPUtilCupService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g22.UPP22010SubService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CUP22010Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private UPP22010SubService upp22010SubService;
    @Resource
    private UPPChkCupService uppChkCupService;
    @Resource
    private UPPUtilCupService uppUtilCupService;
    @Resource
    private OrigInfoService origInfoService;
    @Resource
    private UPPCupSignService uPPCupSignService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        String[] listInPara = "msgtype".split(",");
        YuinResult result = this.upp22010SubService.cUPGetCUP22010AddFlag(request, listInPara);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = this.uppChkCupService.chkField(request, new String[]{"F43", "#2"});
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF60(request, "F60", null);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF63(request, "F63", null);
        if (!result.isSuccess()) {
            return result;
        }
        String[] inparamfamt = "sendbank,cardamt,clearamt,amt".split(",");
        result = this.uppUtilCupService.GetForeignAmt(request, inparamfamt, "amt");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        String inparam = "accno";
        YuinResult result = this.uppChkCupService.cUPChkDoubtfulCard(request, inparam);
        if (!result.isSuccess()) {
            return result;
        }
        JavaDict originfo = null;
        result = this.origInfoService.getOrigInfoMap(request, originfo, "sel_cupbpreauth", "map_cup22010");
        if (!result.isSuccess()) {
            return result;
        }
        List<String> inParam = Arrays.asList("origtradebusistep:TradeBusiStep.Success:\u539f\u4ea4\u6613\u8bb0\u8d26\u6210\u529f:CUP210091:1");
        result = this.uppChkService.chkCompValue(request, inParam);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        String[] listinparam = "amt,#2,#12".split(",");
        YuinResult resultcrt = this.uppChkCupService.ChkFillChar(request, listinparam, "F4");
        if (!resultcrt.isSuccess()) {
            return resultcrt;
        }
        String[] listF60 = request.getString("custom").split(",");
        resultcrt = this.uppUtilCupService.cUPF60(request, listF60);
        if (!resultcrt.isSuccess()) {
            return resultcrt;
        }
        String[] listInParaf61 = "cardauthinfo".split(",");
        resultcrt = this.uppUtilCupService.cUPPackRspF61(request, listInParaf61, "cardauthinfo");
        if (!resultcrt.isSuccess()) {
            return resultcrt;
        }
        String[] listinparamf14 = "expiredate".split(",");
        resultcrt = this.uppUtilCupService.cUPPackRspF14(request, listinparamf14, "expiredate");
        if (!resultcrt.isSuccess()) {
            return resultcrt;
        }
        resultcrt = this.uPPCupSignService.cupGenMac(request);
        if (!resultcrt.isSuccess()) {
            return resultcrt;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

