/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g21;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkCupService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPUtilCupService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP21020Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Resource
    private UPPChkCupService uppChkCupService;
    @Resource
    private UPPUtilCupService uppUtilCupService;
    @Resource
    private OrigInfoService origInfoService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppChkCupService.cUPChkField(request, new String[]{"F43", "#2"}, "merchantname");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF60(request, "F60", "custom");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF104(request, "F104", "adddata");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF48(request, "F48", "addtradedata");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF61(request, "F61", "cardauthinfo");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF90(request, "origdata");
        if (!result.isSuccess()) {
            return result;
        }
        String[] inparamfamt = "sendbank,cardamt,clearamt,amt".split(",");
        result = this.uppUtilCupService.GetForeignAmt(request, inparamfamt, null);
        if (!result.isSuccess()) {
            return result;
        }
        JavaDict origInfo = new JavaDict();
        result = this.origInfoService.getOrigInfoMap(request, origInfo);
        if (!result.isSuccess() && !"E1412".equals(result.getErrorCode())) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppChkCupService.cUPChkBusiStepNeExit(request, Arrays.asList("origtradebusistep:TradeBusiStep.None:\u539f\u4ea4\u6613\u4e0d\u5b58\u5728:A4:0"));
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkCupService.cUPChkBusiStepNeExit(request, Arrays.asList("origtradebusistep:TradeBusiStep.Success:\u539f\u4ea4\u6613\u5df2\u6210\u529f:00:1"));
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkCupService.cUPChkBusiStepNeExit(request, Arrays.asList("origtradebusistep:TradeBusiStep.Sure:\u539f\u4ea4\u6613\u5df2\u786e\u8ba4:15:2"));
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkCupService.cUPChkBusiStepNeExit(request, Arrays.asList("origtradebusistep:TradeBusiStep.Refuse:\u539f\u4ea4\u6613\u5df2\u62d2\u7edd:A5:3"));
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkCupService.cUPChkBusiStepNeExit(request, Arrays.asList("origtradebusistep:TradeBusiStep.AcctChk:\u539f\u4ea4\u6613\u5df2\u786e\u8ba4:A5:3"));
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppChkCupService.cUPChkNoCardauthinfoChk(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkCupService.cUPChkRangeChk(request, new String[]{"cardauthinfo", "#1"});
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkCupService.cUPChkCardauthinfoChk(request, new String[]{"cardtype", "cardnum", "phonenum", "custname", "cardauthinfo", "#1"});
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

