/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g21;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkCupService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPUtilCupService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP21006Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Resource
    private UPPChkCupService uppChkCupService;
    @Resource
    private UPPUtilCupService uppUtilCupService;
    @Resource
    private UPPChkService uppChkService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.uppChkCupService.cUPChkAddFlagOfATM(request, "F18", "F4");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppChkCupService.cUPChkField(request, new String[]{"F43", "#2"}, "merchantname");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF63(request, "F63", "virtual");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF60(request, "F60", "custom");
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppUtilCupService.cUPParseF61(request, "F61", "cardauthinfo");
        if (!result.isSuccess()) {
            return result;
        }
        if (Arrays.asList("0,1,2").contains(request.getString("addflag")) && !(result = this.uppUtilCupService.GetForeignAmt(request, new String[]{"sendbank", "cardamt", "clearamt", "amt"}, "amt")).isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        if ("0".equals(request.getString("addflag"))) {
            result = this.uppChkService.chkIcCardArqc(request);
            if (!result.isSuccess()) {
                return result;
            }
        } else if ("1".equals(request.getString("addflag"))) {
            result = this.uppChkCupService.cUPChkDoubtfulCard(request, "accno");
            if (!result.isSuccess()) {
                return result;
            }
            result = this.uppChkCupService.cUPAmtLimit(request, Arrays.asList("amt", "tradecode"));
            if (!result.isSuccess()) {
                return result;
            }
            result = this.uppChkService.chkIcCardArqc(request);
            if (!result.isSuccess()) {
                return result;
            }
        } else if ("2".equals(request.getString("addflag"))) {
            result = this.uppChkCupService.cUPChkDoubtfulCard(request, "accno");
            if (!result.isSuccess()) {
                return result;
            }
            result = this.uppChkCupService.cUPChkCounterDrawChkFlag(request);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result;
        if ("2".equals(request.getString("addflag")) && !(result = this.uppChkCupService.cUPChkcustinfo(request, Arrays.asList("hostidtype", "hostidno", "custname"))).isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

