/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.busideal.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPBatService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkBepsService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.business.service.PubInitService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.batch.BatchReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.batch.inter.IBatchReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15005Service
implements IBatchReqTradeMethod {
    @Autowired
    private BatchReqFlowService batchReqFlowService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UPPChkBepsService uppChkBepsService;
    @Autowired
    private UPPBatService uppBatService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private TradeStatusService tradeStatusService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.batchReqFlowService.tradeExec(yuinRequestDto, (IBatchReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        List<String> inParam = Arrays.asList("msgid");
        List<String> outParam = Arrays.asList("busidate");
        YuinResult result = this.uppInitService.rInitInBusinessDate(request, inParam, null);
        if (!result.isSuccess()) {
            return result;
        }
        List<String> inParam2 = Arrays.asList("#1", "msgid", "pkgdate");
        List<String> outParam2 = Arrays.asList("pkgdate", "__submsgid__");
        result = this.uppInitService.initInBusinessDate(request, inParam2, outParam2);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.pubInitService.getBrnoInfo(request);
        if (!result.isSuccess()) {
            return result;
        }
        String[] bankStrArr = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payerclearbank", "payeraccbank", "payeebank", "payeeclearbank", "payeeaccbank"};
        String[] bankNameStrArr = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payerclearbankname", "payeraccbankname", "payeebankname", "payeeclearbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = this.uppChkBepsService.chkDSFProtocol(request);
        if (!result.isSuccess()) {
            return result;
        }
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDealHandler(JavaDict request) {
        this.uppBatService.BatReqDown(request);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

