/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g03;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g03.UPP03051SubService;
import cn.com.yusys.yusp.payment.common.base.component.fieldmap.service.UpPErrinfoService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankmapService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP03051Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private UpPErrinfoService upPErrinfoService;
    @Autowired
    private UpPBankmapService upPBankmapService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UPP03051SubService upp03051SubService;

    public void tradeFlow(YuinRequestDto yuinRequestDto) {
        this.corpReqFlowService.tradeExec(yuinRequestDto, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.upPBankmapService.getBankMapByBankno(request, "payeeaccbank", new String[]{"brno", "brname", "clearbrno", "bankno", "bankname"});
        if (result.isSuccess() && result.getOutputParams() != null) {
            request.set("brno", (Object)((JavaDict)result.getOutputParams().get(0)).getString("brno"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = this.uppGetService.getCityCode(request, request.getString("payeeaccbank"), "payeecitycode");
        if (!result.isSuccess()) {
            return result;
        }
        try {
            String[] arraybankstr = new String[]{"payeraccbank", "payerclearbank", "payeeaccbank", "payeeclearbank", "sendbank", "sendclearbank", "recvbank", "recvclearbank"};
            String[] arraybanknamestr = new String[]{"payeraccbankname", "payerclearbankname", "payeeaccbankname", "payeeclearbankname", "sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname"};
            result = this.upPBankinfoService.getBankName(request, arraybankstr, arraybanknamestr);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YuinLogUtils.getInst((Object)this).info("{}|\u9519\u8bef\u4fe1\u606f: {}", request.get("logPrefix"), (Object)e.getStackTrace());
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = new YuinResult();
        result = this.upp03051SubService.chKIbpsBup03051(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkService.chkVerifierResult(request);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result = new YuinResult();
        if ("000000".equals(request.getString("bankerrcode"))) {
            request.set("status", (Object)"1");
        } else {
            request.set("status", (Object)"0");
            result = this.upPErrinfoService.transRetCode(request, "sysid,appid,#PUB,errcode,errmsg,#1");
            if (!result.isSuccess()) {
                return result;
            }
        }
        result = this.uppGetService.getDictMap(request, "sysid,appid,#getRspStatus,#S,#ibps.102.001.01,status", "respstatus");
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

