/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g01;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g01.UPP01062SubService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.batch.BatchReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.batch.inter.IBatchReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UPP01062Service
implements IBatchReqTradeMethod {
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private UPP01062SubService upp01062SubService;
    @Resource
    private BatchReqFlowService batchReqFlowService;

    public YuinResultDto tradeFlow(YuinRequestDto yuinRequestDto) {
        return this.batchReqFlowService.tradeExec(yuinRequestDto, (IBatchReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppGetService.getRealTradeAmt(request, new String[]{"amt", "feeamt"}, new String[]{"realtradeamt"});
        if (!result.isSuccess()) {
            return result;
        }
        if (request.hasKey("curcode") && "01".equals(request.getString("curcode")) && !(result = this.uppGetService.getDictMap(request, "sysid,appid,#PlateDictMap,#M,#CurCode,curcode", "curcode")).isSuccess()) {
            return result;
        }
        String[] bankNo = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payeraccbank", "sendclearbank", "payeeaccbank", "recvclearbank", "payeraccbank", "payeeaccbank"};
        String[] bankName = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payeeclearbankname", "payeebankname", "payerclearbankname", "payeraccbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankNo, bankName);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        List<String> inParam = Arrays.asList("detailflag:#0:\u91cd\u590d\u7684\u4e1a\u52a1\u4e0d\u5904\u7406");
        result = this.uppChkService.chkCompValue(request, inParam);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result = null;
        result = this.upp01062SubService.dataProcess01062(request);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

