/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g01;

import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPCrtService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPMapService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPPkgService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g01.UPP01021SubService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.payment.common.flow.application.service.chnlreq.ChnlReqFlowService;
import cn.com.yusys.yusp.payment.common.flow.application.service.chnlreq.inter.IChnlReqTradeMethod;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UPP01021Service
implements IChnlReqTradeMethod {
    @Resource
    private ChnlReqFlowService chnlReqFlowService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPPkgService uppPkgService;
    @Resource
    private UPPMapService uppMapService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private UPPCrtService uppCrtService;
    @Resource
    private UPP01021SubService upp01021SubService;
    @Resource
    private UpPBankinfoService upPBankinfoService;

    public YuinResultDto tradeFlow(YuinRequestDto yuinRequestDto) {
        return this.chnlReqFlowService.tradeExec(yuinRequestDto, (IChnlReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppGetService.getRealTradeAmt(request, new String[]{"amt", "feeamt"}, new String[]{"realtradeamt"});
        if (!result.isSuccess()) {
            return result;
        }
        if (request.hasKey("payeeaccbrno")) {
            try {
                result = this.upPBankinfoService.getBankInfoByBank(request, String.valueOf(request.getString("payeeaccbrno")));
                if (!result.isSuccess()) {
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.uppMapService.getKeyMap(request, request, request.getString("mapinparamlist", ""));
        result = this.uppGetService.getMsgtypeMap(request);
        if (!result.isSuccess()) {
            return result;
        }
        String[] bankNo = new String[]{"payeraccbank"};
        String[] bankName = new String[]{"payeraccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankNo, bankName);
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> paramList = Arrays.asList("PICK_circle", "infoseqno", "totalamt", "sendfisccode", "recvfisccode", "reportdate", "reportseqno", "budgetlevel", "indicatorcode", "budgetkind", "detailcnt", "paydate", "paypin", "purpose", "endorsetimes", "duedate", "acceptprotocolno", "acceptdate", "acceptor", "applyaccname", "applyaccno", "billpayername", "billpayeraccno", "tradecontractno", "billimgtype", "billimgfrontlen", "billimgfrontdata", "billimgbacklen", "billimgbackdata", "origpayeename", "billpayerbankno", "billpayeraccno", "billpayeeaccno", "agentpayerbankno", "billpayeraccbankname", "billpayeeaccbankname", "billpayerbankname", "addinfo1");
        result = this.uppCrtService.crtPayBLOB(request, paramList, Collections.singletonList("message"));
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppGetService.getEndorserName(request);
        if (!result.isSuccess()) {
            return result;
        }
        request.set("origrecver", (Object)request.getString("sendclearbank", "origsendclearbank"));
        request.set("origsender", (Object)request.getString("recvclearbank", "origrecvclearbank"));
        request.set("sendtime", (Object)LocalDateTime.now());
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppChkService.chkBEPTranAuth(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkService.chkBankBranchAuth(request);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.uppChkService.chkBankTranAuth(request);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        YuinResult result = null;
        result = this.upp01021SubService.dataDeal01021(request);
        if (!result.isSuccess()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

