/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.schedule.beps;

import cn.com.yusys.udp.cloud.message.exception.PlatformException;
import cn.com.yusys.udp.cloud.message.listener.AbstractMessageEventHandler;
import cn.com.yusys.yusp.commons.util.BeanToMapUtils;
import cn.com.yusys.yusp.pay.center.busideal.application.dto.upp.g15.UPP15007ReqDto;
import cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15.UPP15007Service;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpMTranjnlRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkBepsService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g15.UPP15007SubService;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpMTranjnlVo;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.YuinBeanUtil;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.Message;

public class UPP15007Schedule
extends AbstractMessageEventHandler<Message<Map<String, Object>>> {
    private static final Logger logger = LoggerFactory.getLogger(TradeStatusService.class);
    @Autowired
    private UPP15007Service upp15007Service;
    @Resource
    private UpMTranjnlRepo upMTranjnlRepo;
    @Resource
    private UPP15007SubService upp15007SubService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPChkBepsService uppChkBepsService;
    @Value(value="${payment.cmq.topic}")
    private String topic;

    public void handleMessage(Message<Map<String, Object>> exceptionInfoDtoMessage) throws PlatformException {
        try {
            UpMTranjnlVo upMTranjnlVo = new UpMTranjnlVo();
            upMTranjnlVo.setTradebusistep("41");
            upMTranjnlVo.setSysid("UPP");
            upMTranjnlVo.setAppid("BEPS");
            upMTranjnlVo.setMbflag("2");
            List rsptraninfo = this.upMTranjnlRepo.selectReceiptMsg2(upMTranjnlVo);
            YuinLogUtils.getInst((Object)((Object)this)).info(((Map)exceptionInfoDtoMessage.getPayload()).toString());
            if (rsptraninfo.size() > 0) {
                for (Map upMTranjnlPo : rsptraninfo) {
                    JavaDict itemDict = new JavaDict();
                    Map map = BeanToMapUtils.beanToMap((Object)upMTranjnlPo);
                    itemDict.setMap(map);
                    if ("beps.380.001.02".equals(upMTranjnlPo.get("msgtype"))) {
                        this.uppChkBepsService.chkDSFProtocol(itemDict);
                    } else {
                        this.uppChkBepsService.chkDJTreaty(itemDict);
                    }
                    itemDict.set("__CHKAUTHFLAG__", (Object)"1");
                    itemDict.set("totalcnt", (Object)"1");
                    itemDict.set("chnlcode", (Object)"06");
                    itemDict.set("origtradecode", (Object)"UPP15001");
                    itemDict.set("tradecode", (Object)"UPP15007");
                    itemDict.set("originalbusimap", (Object)map);
                    List<String> constList = Arrays.asList("appid", "sysid", "payeebank");
                    this.uppGetService.getBankBrnoInfo(itemDict, constList);
                    YuinRequestDto requestDto = new YuinRequestDto();
                    YuinRequestHead head = new YuinRequestHead();
                    YuinBeanUtil.mapToBean((Map)itemDict.get(), (Object)head);
                    requestDto.setSysHead(head);
                    UPP15007ReqDto body = new UPP15007ReqDto();
                    BigDecimal amt = new BigDecimal("0.00");
                    if (itemDict.hasKey("amt") && itemDict.hasKey("totalamt")) {
                        amt = new BigDecimal(itemDict.getString("amt"));
                        itemDict.set("amt", (Object)amt);
                        amt = new BigDecimal(itemDict.getString("totalamt"));
                        itemDict.set("totalamt", (Object)amt);
                    }
                    YuinBeanUtil.mapToBean((Map)itemDict.get(), (Object)body);
                    requestDto.setBody((Object)body);
                    this.upp15007Service.tradeFlow(requestDto);
                }
            } else {
                logger.info("\u65e0\u5f53\u524d\u53ef\u6267\u884c\u56de\u6267\u5904\u7406");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String eventName() {
        return String.format("*.%s.UPP15007", this.topic);
    }
}

