/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.resources.upp.g15;

import cn.com.yusys.yusp.commons.util.BeanToMapUtils;
import cn.com.yusys.yusp.pay.center.busideal.application.dto.upp.g15.UPP15001ReqDto;
import cn.com.yusys.yusp.pay.center.busideal.application.dto.upp.g15.UPP15007ReqDto;
import cn.com.yusys.yusp.pay.center.busideal.application.dto.upp.g15.UPP15007RspDto;
import cn.com.yusys.yusp.pay.center.busideal.application.service.upp.g15.UPP15007Service;
import cn.com.yusys.yusp.pay.center.busideal.domain.repo.data.UpMTranjnlRepo;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPChkBepsService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.busideal.domain.service.upp.g15.UPP15007SubService;
import cn.com.yusys.yusp.pay.center.busideal.domain.vo.data.UpMTranjnlVo;
import cn.com.yusys.yusp.payment.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.util.YuinBeanUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UPP15001"})
@RestController
public class UPP15007Resource {
    private static final Logger logger = LoggerFactory.getLogger(TradeStatusService.class);
    @Autowired
    private UPP15007Service upp15007Service;
    @Resource
    private UpMTranjnlRepo upMTranjnlRepo;
    @Resource
    private UPP15007SubService upp15007SubService;
    @Autowired
    private UPPChkBepsService uppChkBepsService;
    @Resource
    private UPPGetService uppGetService;

    @ApiOperation(value="\u7edf\u4e00\u652f\u4ed8\u6279\u91cf\u4ee3\u6536\u4e1a\u52a1\u6765\u8d26\u5904\u7406(\u4ed8\u6b3e\u884c)")
    @PostMapping(value={"/api/UPP15007"})
    public YuinResultDto<UPP15007RspDto> uPP15007(@RequestBody @Validated YuinRequestDto<UPP15001ReqDto> yuinRequestDto) {
        try {
            UpMTranjnlVo upMTranjnlVo = new UpMTranjnlVo();
            upMTranjnlVo.setTradebusistep("41");
            upMTranjnlVo.setSysid("UPP");
            upMTranjnlVo.setAppid("BEPS");
            upMTranjnlVo.setMbflag("2");
            List rsptraninfo = this.upMTranjnlRepo.selectReceiptMsg2(upMTranjnlVo);
            if (rsptraninfo.size() > 0) {
                for (Map upMTranjnlPo : rsptraninfo) {
                    JavaDict itemDict = new JavaDict();
                    Map map = BeanToMapUtils.beanToMap((Object)upMTranjnlPo);
                    itemDict.setMap(map);
                    if ("beps.380.001.02".equals(upMTranjnlPo.get("msgtype"))) {
                        this.uppChkBepsService.chkDSFProtocol(itemDict);
                    } else {
                        this.uppChkBepsService.chkDJTreaty(itemDict);
                    }
                    itemDict.set("__CHKAUTHFLAG__", (Object)"1");
                    itemDict.set("totalcnt", (Object)"1");
                    itemDict.set("chnlcode", (Object)"06");
                    itemDict.set("origtradecode", (Object)"UPP15001");
                    itemDict.set("tradecode", (Object)"UPP15007");
                    itemDict.set("originalbusimap", (Object)map);
                    List<String> constList = Arrays.asList("appid", "sysid", "payeebank");
                    this.uppGetService.getBankBrnoInfo(itemDict, constList);
                    YuinRequestDto requestDto = new YuinRequestDto();
                    YuinRequestHead head = new YuinRequestHead();
                    YuinBeanUtil.mapToBean((Map)itemDict.get(), (Object)head);
                    requestDto.setSysHead(head);
                    UPP15007ReqDto body = new UPP15007ReqDto();
                    BigDecimal amt = new BigDecimal("0.00");
                    if (itemDict.hasKey("amt") && itemDict.hasKey("totalamt")) {
                        amt = new BigDecimal(itemDict.getString("amt"));
                        itemDict.set("amt", (Object)amt);
                        amt = new BigDecimal(itemDict.getString("totalamt"));
                        itemDict.set("totalamt", (Object)amt);
                    }
                    YuinBeanUtil.mapToBean((Map)itemDict.get(), (Object)body);
                    requestDto.setBody((Object)body);
                    this.upp15007Service.tradeFlow(requestDto);
                }
            } else {
                logger.info("\u65e0\u5f53\u524d\u53ef\u6267\u884c\u56de\u6267\u5904\u7406");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

