/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.busideal.application.listener;

import cn.com.yusys.udp.cloud.message.listener.AbstractMessageEventHandler;
import cn.com.yusys.yusp.commons.autoconfigure.data.route.PropertyUtil;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.util.TradeUtils;
import cn.com.yusys.yusp.payment.common.base.util.YuinBeanUtil;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class OutCenterInMessageListener
extends AbstractMessageEventHandler<Message<Map<String, Object>>> {
    private final Map<String, String> serviceMap = new HashMap<String, String>();
    @Value(value="${payment.cmq.topic}")
    private String topic;

    public void handleMessage(Message<Map<String, Object>> message) throws PlatformException {
        try {
            YuinLogUtils.getInst((Object)((Object)this)).info("\u63a5\u6536\u62a5\u6587:{}", (Object)((Map)message.getPayload()).toString());
            String tradecode = ((Map)message.getPayload()).getOrDefault("tradecode", "").toString();
            YuinRequestDto requestDto = new YuinRequestDto();
            YuinRequestHead head = new YuinRequestHead();
            YuinBeanUtil.mapToBean((Map)((Map)message.getPayload()), (Object)head);
            requestDto.setSysHead(head);
            requestDto.setBody(message.getPayload());
            String service = this.serviceMap.get(tradecode);
            if (StringUtils.isEmpty((String)service)) {
                Properties properties = new Properties();
                properties.load(PropertyUtil.class.getClassLoader().getResourceAsStream("config/servicemap.properties"));
                service = properties.getProperty(tradecode);
                if (StringUtils.isEmpty((String)service)) {
                    throw new Exception(String.format("\u672a\u83b7\u53d6\u5230tradecode[%s]\u5bf9\u5e94\u7684\u65b9\u6cd5\u7c7b\u914d\u7f6e", tradecode));
                }
                this.serviceMap.put(tradecode, service);
            }
            TradeUtils.P_Trade_ReflectionCall((String)"tradeFlow", (String)service, (Object[])new Object[]{requestDto});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String eventName() {
        return String.format("*.%s.recv", this.topic);
    }
}

