/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g99;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.enumeration.Action99072Enum;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpBSuspendRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpBSuspendVo;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UPP99072SubService {
    private static List<String> reserved = Arrays.asList("DPS0189", "DPS0190", "DPS0192", "DPS0271", "DPS0272", "DPS0275", "DPS0276", "DPS0279", "DPS0001", "BIS0052", "DPS0280", "DPS5200", "DPS5201", "DPS5202", "BIS0067");
    @Resource
    private UpBSuspendRepo upBSuspendRepo;
    @Resource
    private TradeOperDbService tradeOperDbService;

    public YuinResult dataDeal99072(JavaDict request) {
        YuinResult result = null;
        try {
            YuinResult method = new YuinResult();
            if ("BUP99014".equals(request.getString("tradecode"))) {
                int month3ago;
                int bankrspdate = request.getInt("bankrspdate");
                if (bankrspdate >= (month3ago = request.getInt("month3ago"))) {
                    request.set("__SELACTIONKEY__", (Object)"sel_bupmtranjnl_99014");
                } else {
                    request.set("__SELACTIONKEY__", (Object)"sel_his_bupmtranjnl_99014");
                }
            }
            HashMap<String, Function<Object, Object>> actionsMap = new HashMap<String, Function<Object, Object>>();
            actionsMap.put(Action99072Enum.BEPS_SUSPEND.getKey(), item -> this.listBepsSuspend(request));
            actionsMap.put(Action99072Enum.BEPS_SUSPEND_HIS.getKey(), item -> this.listBepsSuspendHis(request));
            actionsMap.put(Action99072Enum.HVPS_SUSPEND.getKey(), item -> this.listHvpsSuspend(request));
            actionsMap.put(Action99072Enum.HVPS_SUSPEND_HIS.getKey(), item -> this.listHvpsSuspendHis(request));
            actionsMap.put(Action99072Enum.IBPS_SUSPEND.getKey(), item -> this.listIbpsSuspend(request));
            actionsMap.put(Action99072Enum.IBPS_SUSPEND_HIS.getKey(), item -> this.listIbpsSuspendHis(request));
            String listKey = request.getString("appid").toLowerCase() + "_" + request.getString("__SELACTIONKEY__");
            result = (YuinResult)((Function)actionsMap.get(listKey)).apply(method);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult listHvpsSuspendHis(JavaDict request) {
        List<UpBSuspendVo> list;
        try {
            UpBSuspendVo vo = new UpBSuspendVo();
            this.dataValuation(request, vo);
            vo.setOrigpayeeaccno("0");
            ArrayList<String> subBrno = new ArrayList<String>();
            list = this.upBSuspendRepo.listHvpsSuspendHis(vo, reserved, subBrno);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)PayErrorCode.getErrmsg((String)"O6049"));
        }
        YuinResult result = this.dataDeal99072(request, list);
        return result;
    }

    private YuinResult listHvpsSuspend(JavaDict request) {
        List<UpBSuspendVo> list;
        try {
            UpBSuspendVo vo = new UpBSuspendVo();
            this.dataValuation(request, vo);
            vo.setOrigpayeeaccno("0");
            vo.setOrigbusitype("A105");
            vo.setOrigmsgtype("hvps.144.001.01");
            ArrayList<String> subBrno = new ArrayList<String>();
            list = this.upBSuspendRepo.listHvpsSuspend(vo, reserved, subBrno);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)PayErrorCode.getErrmsg((String)"O6049"));
        }
        YuinResult result = this.dataDeal99072(request, list);
        return result;
    }

    private YuinResult listIbpsSuspendHis(JavaDict request) {
        List<UpBSuspendVo> list;
        try {
            UpBSuspendVo vo = new UpBSuspendVo();
            this.dataValuation(request, vo);
            list = this.upBSuspendRepo.listIbpsSuspendHis(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)PayErrorCode.getErrmsg((String)"O6049"));
        }
        YuinResult result = this.dataDeal99072(request, list);
        return result;
    }

    private YuinResult listIbpsSuspend(JavaDict request) {
        List<UpBSuspendVo> list;
        try {
            UpBSuspendVo vo = new UpBSuspendVo();
            this.dataValuation(request, vo);
            list = this.upBSuspendRepo.listIbpsSuspend(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)PayErrorCode.getErrmsg((String)"O6049"));
        }
        YuinResult result = this.dataDeal99072(request, list);
        return result;
    }

    private YuinResult listBepsSuspendHis(JavaDict request) {
        List<UpBSuspendVo> list;
        try {
            UpBSuspendVo vo = new UpBSuspendVo();
            this.dataValuation(request, vo);
            vo.setOrigpayeeaccno("0");
            vo.setAmt(request.getBigDecimal("amt", null));
            vo.setAmt(request.getBigDecimal("minamt", null));
            vo.setAmt(request.getBigDecimal("maxamt", null));
            ArrayList<String> subBrno = new ArrayList<String>();
            list = this.upBSuspendRepo.listBepsSuspendHis(vo, reserved, subBrno);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)PayErrorCode.getErrmsg((String)"O6049"));
        }
        YuinResult result = this.dataDeal99072(request, list);
        return result;
    }

    private YuinResult listBepsSuspend(JavaDict request) {
        List<UpBSuspendVo> list;
        try {
            UpBSuspendVo vo = new UpBSuspendVo();
            this.dataValuation(request, vo);
            vo.setOrigpayeeaccno("0");
            ArrayList<String> subBrno = new ArrayList<String>();
            list = this.upBSuspendRepo.listBepsSuspend(vo, reserved, subBrno);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)PayErrorCode.getErrmsg((String)"O6049"));
        }
        YuinResult result = this.dataDeal99072(request, list);
        return result;
    }

    private YuinResult dataDeal99072(JavaDict request, List<UpBSuspendVo> detailList) {
        YuinResult result = new YuinResult();
        if (CollectionUtils.isEmpty(detailList)) {
            return YuinResult.newFailureResult((String)"E2042", (String)PayErrorCode.getErrmsg((String)"E2042"));
        }
        if (detailList.size() > 50) {
            return YuinResult.newFailureResult((String)"E0303", (String)PayErrorCode.getErrmsg((String)"\u8bbf\u95ee\u6570\u636e\u91cf\u592a\u5927"));
        }
        List pageList = detailList.stream().skip((request.getInt("pageNum") - 1) * request.getInt("pageSize")).limit(request.getInt("pageSize")).collect(Collectors.toList());
        request.set("result", pageList);
        request.set("_totalrownum_", (Object)detailList.size());
        return YuinResult.newSuccessResult(null);
    }

    private void dataValuation(JavaDict request, UpBSuspendVo vo) {
        vo.setSysid(request.getString("sysid"));
        vo.setAppid(request.getString("appid"));
        vo.setWorkdate(request.getString("origworkdate", ""));
        vo.setWorkseqid(request.getString("origworkseqid", ""));
        vo.setOrigmsgid(request.getString("msgid", ""));
        vo.setOrigdetailno(request.getString("detailno", ""));
        vo.setStartdate(request.getString("startdate", ""));
        vo.setStopdate(request.getString("stopdate", ""));
        vo.setSuspclearseqno(request.getString("suspclearseqno", ""));
        vo.setOrigsendbank(request.getString("qrysendbank", ""));
        vo.setAmt(request.getBigDecimal("amt", null));
        vo.setAmt(request.getBigDecimal("minamt", null));
        vo.setAmt(request.getBigDecimal("maxamt", null));
    }
}

