/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g91;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.pay.center.beps.dao.po.UpDBankinfoPo;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpBPkginfoRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpDBankinfoRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPMapService;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpBPkginfoVo;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpDBankinfoVo;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.component.fieldmap.service.UpPDictService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.TradeInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.communication.service.CorpComService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.dao.po.UpPSysadmPo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.repo.UpPSysadmServiceRepo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.vo.UpPSysadmQueryVo;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ETradeBusiStatus;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ETradeBusiStep;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP91101SubService {
    private static List<String> SYS_STATUS_NORMAL = Arrays.asList("1", "5");
    private static List<String> SYS_LOGINSTATUS_NORMAL = Arrays.asList("1");
    private static List<String> BANK_STATUS_NORMAL = Arrays.asList("1");
    private static List<String> BANK_LOGINSTATUS_NORMAL = Arrays.asList("1");
    private static Map<String, BiFunction> functionPackMap = new HashMap<String, BiFunction>();
    @Autowired
    private UpBPkginfoRepo upBPkginfoRepo;
    @Autowired
    private UpPDictService upPDictService;
    @Autowired
    private TradeOperDbService tradeOperDbService;
    @Autowired
    private UpPSysadmServiceRepo upPSysadmServiceRepo;
    @Autowired
    private UpDBankinfoRepo upDBankinfoRepo;
    @Autowired
    private TradeInitService tradeInitService;
    @Autowired
    private CorpComService corpComService;
    @Autowired
    private UPPMapService uppMapService;

    private static YuinResult supplePkgDataBeps12100101(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps12200101(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps12500101(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busitype"))) {
            packdata.set("busitype", (Object)detaildata.getString("busitype"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busikind"))) {
            packdata.set("busikind", (Object)detaildata.getString("busikind"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraccno"))) {
            packdata.set("payeraccno", (Object)detaildata.getString("payeraccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payername"))) {
            packdata.set("payername", (Object)detaildata.getString("payername"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraddr"))) {
            packdata.set("payeraddr", (Object)detaildata.getString("payeraddr"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payerbank"))) {
            packdata.set("payerbank", (Object)detaildata.getString("payerbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraccbank"))) {
            packdata.set("payeraccbank", (Object)detaildata.getString("payeraccbank"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps12700101(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("endorsername"))) {
            String[] namelist = detaildata.getString("endorsername", "").split(",");
            Map[] circle = new Map[namelist.length];
            for (int j = 0; j < namelist.length; ++j) {
                circle[j] = (Map)((Object)new HashMap<String, String>().put("endorsername", namelist[j]));
            }
            packdata.set("circle", (Object)circle.toString());
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("chnlcode"))) {
            packdata.set("chnlcode", (Object)detaildata.getString("chnlcode"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("chnldate"))) {
            packdata.set("chnldate", (Object)detaildata.getString("chnldate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("chnlseqno"))) {
            packdata.set("chnlseqno", (Object)detaildata.getString("chnlseqno"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps12800101(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps13000101(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps13300101(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busitype"))) {
            packdata.set("busitype", (Object)detaildata.getString("busitype"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busikind"))) {
            packdata.set("busikind", (Object)detaildata.getString("busikind"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaccno"))) {
            packdata.set("payeeaccno", (Object)detaildata.getString("payeeaccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeename"))) {
            packdata.set("payeename", (Object)detaildata.getString("payeename"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaddr"))) {
            packdata.set("payeeaddr", (Object)detaildata.getString("payeeaddr"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeebank"))) {
            packdata.set("payeebank", (Object)detaildata.getString("payeebank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaccbank"))) {
            packdata.set("payeeaccbank", (Object)detaildata.getString("payeeaccbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("respperiod"))) {
            packdata.set("respperiod", (Object)detaildata.getString("respperiod"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps13400101(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps38100101(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("batno"))) {
            packdata.set("batno", (Object)detaildata.getString("batno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("respperiod"))) {
            packdata.set("respperiod", (Object)detaildata.getString("respperiod"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaccno"))) {
            packdata.set("payeeaccno", (Object)detaildata.getString("payeeaccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeename"))) {
            packdata.set("payeename", (Object)detaildata.getString("payeename"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeebank"))) {
            packdata.set("payeebank", (Object)detaildata.getString("payeebank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("corptrantodate"))) {
            packdata.set("corptrantodate", (Object)detaildata.getString("corptrantodate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbatno"))) {
            packdata.set("origbatno", (Object)detaildata.getString("origbatno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbusitype"))) {
            packdata.set("origbusitype", (Object)detaildata.getString("origbusitype"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origsendbank"))) {
            packdata.set("origsendbank", (Object)detaildata.getString("origsendbank"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps38100102(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("batno"))) {
            packdata.set("batno", (Object)detaildata.getString("batno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("respperiod"))) {
            packdata.set("respperiod", (Object)detaildata.getString("respperiod"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaccno"))) {
            packdata.set("payeeaccno", (Object)detaildata.getString("payeeaccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeename"))) {
            packdata.set("payeename", (Object)detaildata.getString("payeename"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeebank"))) {
            packdata.set("payeebank", (Object)detaildata.getString("payeebank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("corptrantodate"))) {
            packdata.set("corptrantodate", (Object)detaildata.getString("corptrantodate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbatno"))) {
            packdata.set("origbatno", (Object)detaildata.getString("origbatno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbusitype"))) {
            packdata.set("origbusitype", (Object)detaildata.getString("origbusitype"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origsendbank"))) {
            packdata.set("origsendbank", (Object)detaildata.getString("origsendbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeecdtrnm"))) {
            packdata.set("payeecdtrnm", (Object)detaildata.getString("payeecdtrnm"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeecdtracct"))) {
            packdata.set("payeecdtracct", (Object)detaildata.getString("payeecdtracct"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeunisocode"))) {
            packdata.set("payeeunisocode", (Object)detaildata.getString("payeeunisocode"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("regionid"))) {
            packdata.set("regionid", (Object)detaildata.getString("regionid"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeechgflag"))) {
            packdata.set("payeechgflag", (Object)detaildata.getString("payeechgflag"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("creditagrmt"))) {
            packdata.set("creditagrmt", (Object)detaildata.getString("creditagrmt"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps38300101(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origsendclearbank"))) {
            packdata.set("origsendbank", (Object)detaildata.getString("origsendclearbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("batno"))) {
            packdata.set("batno", (Object)detaildata.getString("batno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payerbank"))) {
            packdata.set("payerbank", (Object)detaildata.getString("payerbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payername"))) {
            packdata.set("payername", (Object)detaildata.getString("payername"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraccno"))) {
            packdata.set("payeraccno", (Object)detaildata.getString("payeraccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbatno"))) {
            packdata.set("origbatno", (Object)detaildata.getString("origbatno"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataBeps38800101(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("sendclearbank"))) {
            packdata.set("sendclearbank", (Object)detaildata.getString("sendclearbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbatno"))) {
            packdata.set("origbatno", (Object)detaildata.getString("origbatno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origmsgid"))) {
            packdata.set("origmsgid", (Object)detaildata.getString("origmsgid"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origsendbank"))) {
            packdata.set("origsendbank", (Object)detaildata.getString("origsendbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("respstatus"))) {
            packdata.set("respstatus", (Object)detaildata.getString("respstatus"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("rejectcode"))) {
            packdata.set("rejectcode", (Object)detaildata.getString("rejectcode"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("rejectinfo"))) {
            packdata.set("rejectinfo", (Object)detaildata.getString("rejectinfo"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("addinfo"))) {
            packdata.set("addinfo", (Object)detaildata.getString("addinfo"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG001(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG002(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG005(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busitype"))) {
            packdata.set("busitype", (Object)detaildata.getString("busitype"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busikind"))) {
            packdata.set("busikind", (Object)detaildata.getString("busikind"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraccno"))) {
            packdata.set("payeraccno", (Object)detaildata.getString("payeraccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payername"))) {
            packdata.set("payername", (Object)detaildata.getString("payername"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraddr"))) {
            packdata.set("payeraddr", (Object)detaildata.getString("payeraddr"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payerbank"))) {
            packdata.set("payerbank", (Object)detaildata.getString("payerbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeraccbank"))) {
            packdata.set("payeraccbank", (Object)detaildata.getString("payeraccbank"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG006(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("endorsername"))) {
            String[] namelist = detaildata.getString("endorsername", "").split(",");
            Map[] circle = new Map[namelist.length];
            for (int j = 0; j < namelist.length; ++j) {
                circle[j] = (Map)((Object)new HashMap<String, String>().put("endorsername", namelist[j]));
            }
            packdata.set("circle", (Object)circle.toString());
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("chnlcode"))) {
            packdata.set("chnlcode", (Object)detaildata.getString("chnlcode"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("chnldate"))) {
            packdata.set("chnldate", (Object)detaildata.getString("chnldate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("chnlseqno"))) {
            packdata.set("chnlseqno", (Object)detaildata.getString("chnlseqno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busitype"))) {
            packdata.set("busitype", (Object)detaildata.getString("busitype"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busikind"))) {
            packdata.set("busikind", (Object)detaildata.getString("busikind"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("busidate"))) {
            packdata.set("busidate", (Object)detaildata.getString("busidate"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaccno"))) {
            packdata.set("payeeaccno", (Object)detaildata.getString("payeeaccno"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeename"))) {
            packdata.set("payeename", (Object)detaildata.getString("payeename"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaddr"))) {
            packdata.set("payeeaddr", (Object)detaildata.getString("payeeaddr"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeebank"))) {
            packdata.set("payeebank", (Object)detaildata.getString("payeebank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("payeeaccbank"))) {
            packdata.set("payeeaccbank", (Object)detaildata.getString("payeeaccbank"));
        }
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("respperiod"))) {
            packdata.set("respperiod", (Object)detaildata.getString("respperiod"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG007(JavaDict packdata, JavaDict detaildata) {
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG008(JavaDict packdata, JavaDict detaildata) {
        if ("1".equals(packdata.getString("seqmod"))) {
            packdata.set("busiset", (Object)"007");
            packdata.set("origmsgtype", (Object)"999");
            packdata.set("origbusidate", (Object)detaildata.getString("entrustdate"));
            packdata.set("origmsgid", (Object)"99999999");
        } else {
            packdata.set("busiset", (Object)"006");
            if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbusidate"))) {
                packdata.set("origbusidate", (Object)detaildata.getString("origbusidate"));
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    private static YuinResult supplePkgDataPKG011(JavaDict packdata, JavaDict detaildata) {
        if (!StringUtils.isBlank((CharSequence)detaildata.getString("origbusidate"))) {
            packdata.set("origbusidate", (Object)detaildata.getString("origbusidate"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult bepsPackDeal(JavaDict request) {
        try {
            String uuid = UUID.randomUUID().toString();
            LogUtils.printInfo((Object)this, (String)"========\u987a\u5e8f\u7ec4\u5305\u6a21\u5f0f==========", (Object[])new Object[0]);
            UpBPkginfoVo upBPkginfoVoOrder = new UpBPkginfoVo();
            upBPkginfoVoOrder.setUuid(uuid);
            int ordernum = this.upBPkginfoRepo.updateAllMsgtypeOrderPackDeal(upBPkginfoVoOrder);
            LogUtils.printInfo((Object)this, (String)"\u987a\u5e8f\u7ec4\u5305\u6a21\u5f0f\u66f4\u65b0\u7b14\u6570:{}", (Object[])new Object[]{ordernum});
            LogUtils.printInfo((Object)this, (String)"==========\u56de\u6267\u7ec4\u5305\u6a21\u5f0f==========", (Object[])new Object[0]);
            UpBPkginfoVo upBPkginfoVoReceipt = new UpBPkginfoVo();
            upBPkginfoVoReceipt.setUuid(uuid);
            int receiptnum = this.upBPkginfoRepo.updateAllMsgtypeReceiptPackDeal(upBPkginfoVoReceipt);
            LogUtils.printInfo((Object)this, (String)"\u56de\u6267\u7ec4\u5305\u6a21\u5f0f\u66f4\u65b0\u7b14\u6570:{}", (Object[])new Object[]{receiptnum});
            LogUtils.printInfo((Object)this, (String)"==========\u6279\u91cf\u7ec4\u5305\u6a21\u5f0f==========", (Object[])new Object[0]);
            UpBPkginfoVo upBPkginfoVoBatch = new UpBPkginfoVo();
            upBPkginfoVoBatch.setUuid(uuid);
            int batchnum = this.upBPkginfoRepo.updateAllMsgtypeBatchPackDeal(upBPkginfoVoBatch);
            LogUtils.printInfo((Object)this, (String)"\u6279\u91cf\u7ec4\u5305\u6a21\u5f0f\u66f4\u65b0\u7b14\u6570:{}", (Object[])new Object[]{batchnum});
            LogUtils.printInfo((Object)this, (String)"==========\u67e5\u8be2\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u4e2d\u5305\u72b6\u6001\u4e3a1-\u7b49\u5f85\u7ec4\u5305\u7684\u4fe1\u606f==========", (Object[])new Object[0]);
            UpBPkginfoVo upBPkginfoVoSel = new UpBPkginfoVo();
            upBPkginfoVoSel.setPackstatus("1");
            upBPkginfoVoSel.setUuid(uuid);
            List<UpBPkginfoVo> list = this.upBPkginfoRepo.selectListInfo(upBPkginfoVoSel);
            if (list.size() < 1) {
                LogUtils.printInfo((Object)this, (String)"==========\u672a\u67e5\u8be2\u5230\u5305\u72b6\u6001\u4e3a1-\u7b49\u5f85\u7ec4\u5305\u7684\u4fe1\u606f, \u9000\u51fa\u5904\u7406==========", (Object[])new Object[0]);
                return YuinResult.newSuccessResult(null);
            }
            LogUtils.printInfo((Object)this, (String)"==========\u5faa\u73af\u5904\u7406\u5305\u72b6\u6001\u4e3a1-\u7b49\u5f85\u7ec4\u5305\u7684\u4fe1\u606f, \u5171\u8ba1[{}]\u7b14==========", (Object[])new Object[]{list.size()});
            for (int i = 0; i < list.size(); ++i) {
                UpBPkginfoVo upBPkginfoVo = list.get(i);
                LogUtils.printInfo((Object)this, (String)"=====\u5f00\u59cb\u5904\u7406\u7b2c[{}]\u5305 busidate[{}] msgtype[{}] msgid[{}] recvclearbank[{}]=====", (Object[])new Object[]{i + 1, upBPkginfoVo.getEntrustdate(), upBPkginfoVo.getMsgtype(), upBPkginfoVo.getMsgid(), upBPkginfoVo.getRecvclearbank()});
                UpBPkginfoVo upBPkginfoVoCond = new UpBPkginfoVo();
                upBPkginfoVoCond.setMsgid(upBPkginfoVo.getMsgid());
                upBPkginfoVoCond.setMsgtype(upBPkginfoVo.getMsgtype());
                upBPkginfoVoCond.setSendclearbank(upBPkginfoVo.getSendclearbank());
                upBPkginfoVoCond.setMbflag(upBPkginfoVo.getMbflag());
                YuinResult result = YuinResult.newSuccessResult(null);
                ArrayList<Map<String, Object>> datalist = new ArrayList();
                JavaDict packdata = new JavaDict();
                JavaDict senddict = new JavaDict();
                int stepnum = 0;
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u67e5\u8be2\u4ea4\u6613\u6d41\u6c34\u4fe1\u606f==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.selPkgTradejnl(request, upBPkginfoVo);
                }
                if (result.success()) {
                    datalist = (List)result.getOutputParams().get(0);
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u68c0\u67e5\u7cfb\u7edf\u72b6\u6001==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.chkSysStatus(request);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u68c0\u67e5\u63a5\u6536\u884c\u72b6\u6001==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.chkRecvclearbankStatus(request, upBPkginfoVo);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u5305\u4fe1\u606f\u6570\u636e\u6838\u5bf9==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.chkPkgData(request, upBPkginfoVo, datalist);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u7ec4\u5305\u524d\u66f4\u65b0\u5305\u72b6\u6001[9-\u5904\u7406\u4e2d]==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.updPackStatusBefPkg(request, upBPkginfoVoCond);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u7ec4\u5305\u6570\u636e\u8865\u5145\u5904\u7406==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.supplePkgData(request, packdata, upBPkginfoVo, datalist);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u7ec4\u5305\u6620\u5c04==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.mapPkgData(packdata, senddict);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u7ec4\u5305\u5b8c\u6210\u66f4\u65b0\u5305\u72b6\u6001[2-\u7ec4\u5305\u6210\u529f]==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.updPackStatusAftPkg(request, upBPkginfoVoCond);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6\u7684\u4e1a\u52a1\u6b65\u9aa4[31-\u5df2\u53d1\u9001]==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.updPkgTradejnl(request, upBPkginfoVo);
                }
                if (result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u7ec4\u5305\u62a5\u6587\u53d1\u9001==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    result = this.sendPkg(packdata, senddict);
                }
                if (!result.success()) {
                    LogUtils.printInfo((Object)this, (String)"==========\u7b2c[{}]\u5305 step-{} \u7ec4\u5305\u5931\u8d25\u66f4\u65b0\u5305\u72b6\u6001[3-\u7ec4\u5305\u5931\u8d25]==========", (Object[])new Object[]{i + 1, String.format("%02d", stepnum++)});
                    this.updPackStatusFail(request, upBPkginfoVoCond, result);
                }
                LogUtils.printInfo((Object)this, (String)"=====\u7ed3\u675f\u5904\u7406\u7b2c[{}]\u5305 \u7ec4\u5305{}[{}]=====", (Object[])new Object[]{i + 1, result.success() ? "\u6210\u529f" : "\u5931\u8d25", upBPkginfoVo.getMsgid()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)"\u5c0f\u989d\u7ec4\u5305\u5904\u7406\u5f02\u5e38");
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult selPkgTradejnl(JavaDict request, UpBPkginfoVo upBPkginfoVo) {
        YuinResult actionResult = this.upPDictService.getDictValue2ByKey(request, "sysid,appid,#SelPkg,#M,#msgtype,#" + upBPkginfoVo.getMsgtype());
        if (!actionResult.success()) {
            return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u672a\u83b7\u53d6\u5f53\u524d\u62a5\u6587\u7c7b\u578b[%s]\u7684\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6\u67e5\u8be2actionkey", upBPkginfoVo.getMsgtype()));
        }
        String actionKeySelJnl = (String)actionResult.getOutputParams().get(0);
        JavaDict actionDict = new JavaDict();
        actionDict.set("sysid", (Object)request.getString("sysid"));
        actionDict.set("appid", (Object)request.getString("appid"));
        actionDict.set("busidate", (Object)upBPkginfoVo.getEntrustdate());
        actionDict.set("msgid", (Object)upBPkginfoVo.getMsgid());
        actionDict.set("msgtype", (Object)upBPkginfoVo.getMsgtype());
        actionDict.set("sendclearbank", (Object)upBPkginfoVo.getSendclearbank());
        actionDict.set("mbflag", (Object)upBPkginfoVo.getMbflag());
        YuinResultDto resultDto = null;
        try {
            resultDto = this.tradeOperDbService.operDbaction(actionDict, request.getString("sysid"), request.getString("appid"), actionKeySelJnl);
            if (!resultDto.isSuccess()) {
                return YuinResult.newFailureResult((String)resultDto.getHead().getResponseCode(), (String)resultDto.getHead().getResponseMsg());
            }
            List datalist = (List)resultDto.getBody();
            if (datalist.size() < 1) {
                LogUtils.printInfo((Object)this, (String)"\u67e5\u8be2\u5931\u8d25, \u83b7\u53d6\u660e\u7ec6[{}]\u6761", (Object[])new Object[]{datalist.size()});
                return YuinResult.newFailureResult((String)"E2042", (String)String.format("\u67e5\u8be2\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6\u4e3a\u7a7a[]", upBPkginfoVo.getMsgid()));
            }
            LogUtils.printInfo((Object)this, (String)"\u67e5\u8be2\u6210\u529f, \u83b7\u53d6\u660e\u7ec6[{}]\u6761", (Object[])new Object[]{datalist.size()});
            return YuinResult.newSuccessResult((Object[])new Object[]{datalist});
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"O6049", (String)String.format("\u67e5\u8be2\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6\u5f02\u5e38[]", upBPkginfoVo.getMsgid()));
        }
    }

    private YuinResult chkSysStatus(JavaDict request) {
        UpPSysadmQueryVo upPSysadmQueryVo = new UpPSysadmQueryVo();
        upPSysadmQueryVo.setSysid(request.getString("sysid"));
        upPSysadmQueryVo.setAppid(request.getString("appid"));
        UpPSysadmPo upPSysadmPo = this.upPSysadmServiceRepo.selectById(upPSysadmQueryVo);
        if (upPSysadmPo == null) {
            return YuinResult.newFailureResult((String)"E0199", (String)"\u68c0\u67e5\u7cfb\u7edf\u4fe1\u606f\u5f02\u5e38");
        }
        if (!SYS_STATUS_NORMAL.contains(upPSysadmPo.getSysstatus())) {
            return YuinResult.newFailureResult((String)"E0103", (String)String.format("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u5904\u4e8e\u975e\u6b63\u5e38\u72b6\u6001[%s]", upPSysadmPo.getSysstatus()));
        }
        if (!SYS_LOGINSTATUS_NORMAL.contains(upPSysadmPo.getLoginstatus())) {
            return YuinResult.newFailureResult((String)"E0101", (String)String.format("\u5f53\u524d\u5e94\u7528\u7cfb\u7edf\u672a\u767b\u5f55[%s]", upPSysadmPo.getLoginstatus()));
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult chkRecvclearbankStatus(JavaDict request, UpBPkginfoVo upBPkginfoVo) {
        UpDBankinfoVo upDBankinfoVo = new UpDBankinfoVo();
        upDBankinfoVo.setSysid(request.getString("sysid"));
        upDBankinfoVo.setAppid(request.getString("appid"));
        upDBankinfoVo.setBankno(upBPkginfoVo.getRecvclearbank());
        UpDBankinfoPo upDBankinfoPo = this.upDBankinfoRepo.selectById(upDBankinfoVo);
        if (upDBankinfoPo == null) {
            return YuinResult.newFailureResult((String)"E1024", (String)PayErrorCode.getErrmsg((String)"E1024"));
        }
        if (!BANK_STATUS_NORMAL.contains(upDBankinfoPo.getStatus())) {
            return YuinResult.newFailureResult((String)"E1016", (String)String.format("%s[%s]", PayErrorCode.getErrmsgAdd((String)"E1016", (String)upBPkginfoVo.getRecvclearbank()), upDBankinfoPo.getStatus()));
        }
        if (!BANK_LOGINSTATUS_NORMAL.contains(upDBankinfoPo.getLoginstatus())) {
            return YuinResult.newFailureResult((String)"E1018", (String)String.format("%s[%s]", PayErrorCode.getErrmsgAdd((String)"E1018", (String)upBPkginfoVo.getRecvclearbank()), upDBankinfoPo.getLoginstatus()));
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult chkPkgData(JavaDict request, UpBPkginfoVo upBPkginfoVo, List<Map<String, Object>> datalist) {
        if (Integer.parseInt(upBPkginfoVo.getCountsum()) != datalist.size()) {
            return YuinResult.newFailureResult((String)"O6618", (String)PayErrorCode.getErrmsg((String)"O6618"));
        }
        BigDecimal toolamt = new BigDecimal(0.0);
        int totalsuccnt = 0;
        BigDecimal totalsucamt = new BigDecimal(0.0);
        YuinResult result = YuinResult.newSuccessResult(null);
        for (int j = 0; j < datalist.size(); ++j) {
            JavaDict detaildata = new JavaDict();
            detaildata.setMap(datalist.get(j));
            Boolean succFlag = Boolean.TRUE;
            if (!ETradeBusiStatus.BUSISTATUS_DEALING.getCode().equals(detaildata.getString("busistatus")) || !ETradeBusiStep.TRADEBUSISTEP_WAITINGSEND.getCode().equals(detaildata.getString("tradebusistep"))) {
                result = YuinResult.newFailureResult((String)"O1114", (String)PayErrorCode.getErrmsgAdd((String)"O1114", (String)"\u4e1a\u52a1\u72b6\u6001\u6838\u5bf9\u4e0d\u7b26"));
                succFlag = Boolean.FALSE;
                LogUtils.printInfo((Object)this, (String)"==========\u4e1a\u52a1\u72b6\u6001\u6838\u5bf9\u4e0d\u7b26 workdate[{}] workseqid[{}] busistatus[{}] tradebusistep[{}]", (Object[])new Object[]{detaildata.getString("workdate"), detaildata.getString("workseqid"), detaildata.getString("busistatus"), detaildata.getString("tradebusistep")});
            }
            toolamt = toolamt.add(detaildata.getBigDecimal("amt"));
            if (!succFlag.booleanValue() || !"2".equals(upBPkginfoVo.getSeqmod()) && !"beps.130.001.01".equals(upBPkginfoVo.getMsgtype()) || !"1".equals(detaildata.getString("respstatus"))) continue;
            ++totalsuccnt;
            totalsucamt.add(detaildata.getBigDecimal("amt"));
        }
        if (toolamt.compareTo(upBPkginfoVo.getAmountsum()) != 0) {
            return YuinResult.newFailureResult((String)"E1799", (String)PayErrorCode.getErrmsgAdd((String)"E1799", (String)"\u5305\u660e\u7ec6\u6c47\u603b\u91d1\u989d\u6838\u5bf9\u4e0d\u7b26"));
        }
        if (totalsuccnt != 0 && Integer.parseInt(upBPkginfoVo.getPkgsuccount()) != totalsuccnt) {
            return YuinResult.newFailureResult((String)"O6618", (String)PayErrorCode.getErrmsgAdd((String)"O6618", (String)"\u5305\u660e\u7ec6\u6210\u529f\u603b\u7b14\u6570\u6838\u5bf9\u4e0d\u7b26"));
        }
        if (totalsucamt.compareTo(BigDecimal.ZERO) != 0 && totalsucamt.compareTo(upBPkginfoVo.getPkgsucamt()) != 0) {
            return YuinResult.newFailureResult((String)"E1799", (String)PayErrorCode.getErrmsgAdd((String)"E1799", (String)"\u5305\u660e\u7ec6\u6210\u529f\u603b\u91d1\u989d\u6838\u5bf9\u4e0d\u7b26"));
        }
        return result;
    }

    private YuinResult updPackStatusBefPkg(JavaDict request, UpBPkginfoVo upBPkginfoVoCond) {
        UpBPkginfoVo upBPkginfoVoUpd = new UpBPkginfoVo();
        upBPkginfoVoUpd.setTradebusistep(ETradeBusiStep.TRADEBUSISTEP_WAITINGSEND.getCode());
        upBPkginfoVoUpd.setPackstatus("9");
        int updnum = this.upBPkginfoRepo.updatePkgInfo(upBPkginfoVoUpd, upBPkginfoVoCond);
        if (updnum < 1) {
            LogUtils.printInfo((Object)this, (String)"==========\u66f4\u65b0\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u72b6\u6001[9-\u5904\u7406\u4e2d]\u5f02\u5e38", (Object[])new Object[0]);
            return YuinResult.newFailureResult((String)"S5004", (String)"\u66f4\u65b0\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u72b6\u6001[9-\u5904\u7406\u4e2d]\u5f02\u5e38");
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult supplePkgData(JavaDict request, JavaDict packdata, UpBPkginfoVo upBPkginfoVo, List<Map<String, Object>> datalist) {
        packdata.set((IDict)request);
        packdata.setMap(BeanUtils.beanToMap((Object)((Object)upBPkginfoVo)));
        packdata.set("detaillist", datalist);
        packdata.set("crtcommsgid", packdata.get("crtcommsgid", (Object)this.tradeInitService.getSeqComMsgid(request.getString("workdate"))));
        request.set("crtcommsgid", (Object)packdata.getString("crtcommsgid"));
        packdata.set("__sendmsgtype__", (Object)this.getPkgMsgtype(upBPkginfoVo));
        LogUtils.printInfo((Object)this, (String)"\u7ec4\u5305\u62a5\u6587\u7c7b\u578b\u786e\u8ba4[{}], \u8865\u5145\u62a5\u6587\u6570\u636e\u4e2d...", (Object[])new Object[]{packdata.getString("__sendmsgtype__")});
        JavaDict detaildata = new JavaDict();
        detaildata.setMap(datalist.get(0));
        YuinResult result = (YuinResult)functionPackMap.get(packdata.getString("__sendmsgtype__")).apply(packdata, detaildata);
        return result;
    }

    private YuinResult mapPkgData(JavaDict packdata, JavaDict senddict) {
        YuinResult result = this.corpComService.corpPack(packdata, senddict);
        if (!result.success()) {
            LogUtils.printInfo((Object)this, (String)"==========\u7ec4\u5305\u6620\u5c04\u5904\u7406\u5931\u8d25:{}", (Object[])new Object[]{result.getErrorMsg()});
            result = YuinResult.newFailureResult((String)result.getErrorCode(), (String)String.format("\u7ec4\u5305\u6620\u5c04\u5904\u7406\u5931\u8d25[%s]", result.getErrorMsg()));
        }
        return result;
    }

    private YuinResult updPackStatusAftPkg(JavaDict request, UpBPkginfoVo upBPkginfoVoCond) {
        UpBPkginfoVo upBPkginfoVoUpd = new UpBPkginfoVo();
        upBPkginfoVoUpd.setTradebusistep(ETradeBusiStep.TRADEBUSISTEP_WAITSEND.getCode());
        upBPkginfoVoUpd.setPackstatus("2");
        upBPkginfoVoUpd.setErrcode("000000");
        upBPkginfoVoUpd.setErrmsg("\u7ec4\u5305\u6210\u529f");
        int updnum = this.upBPkginfoRepo.updatePkgInfo(upBPkginfoVoUpd, upBPkginfoVoCond);
        if (updnum < 1) {
            LogUtils.printInfo((Object)this, (String)"==========\u66f4\u65b0\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u72b6\u6001[2-\u7ec4\u5305\u6210\u529f]\u5f02\u5e38", (Object[])new Object[0]);
            return YuinResult.newFailureResult((String)"S5004", (String)"\u66f4\u65b0\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u72b6\u6001[2-\u7ec4\u5305\u6210\u529f]\u5f02\u5e38");
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult updPkgTradejnl(JavaDict request, UpBPkginfoVo upBPkginfoVo) {
        JavaDict actionDictSucc = new JavaDict();
        actionDictSucc.set("sysid", (Object)request.getString("sysid"));
        actionDictSucc.set("appid", (Object)request.getString("appid"));
        actionDictSucc.set("entrustdate", (Object)upBPkginfoVo.getEntrustdate());
        actionDictSucc.set("msgid", (Object)upBPkginfoVo.getMsgid());
        actionDictSucc.set("msgtype", (Object)upBPkginfoVo.getMsgtype());
        actionDictSucc.set("sendclearbank", (Object)upBPkginfoVo.getSendclearbank());
        actionDictSucc.set("mbflag", (Object)upBPkginfoVo.getMbflag());
        actionDictSucc.set("tradebusistep", (Object)ETradeBusiStep.TRADEBUSISTEP_WAITSEND.getCode());
        actionDictSucc.set("commsgid", (Object)request.getString("crtcommsgid"));
        YuinResultDto resultDto = null;
        YuinResult result = YuinResult.newSuccessResult(null);
        try {
            resultDto = this.tradeOperDbService.operDbaction(actionDictSucc, request.getString("sysid"), request.getString("appid"), request.getString("__upd_tranjnl_packsucc__"));
            if (!resultDto.isSuccess()) {
                result = YuinResult.newFailureResult((String)resultDto.getHead().getResponseCode(), (String)resultDto.getHead().getResponseMsg());
            } else {
                int num = Integer.parseInt(String.valueOf(resultDto.getBody()));
                LogUtils.printInfo((Object)this, (String)"\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6[{}]\u6210\u529f", (Object[])new Object[]{num});
            }
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"E2033", (String)String.format("\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u660e\u7ec6\u5f02\u5e38[]", upBPkginfoVo.getMsgid()));
        }
        return result;
    }

    private YuinResult sendPkg(JavaDict packdata, JavaDict senddict) {
        senddict.set("sysid", (Object)packdata.getString("sysid"));
        senddict.set("appid", (Object)packdata.getString("appid"));
        YuinResult result = this.corpComService.corpComm(packdata, senddict, new JavaDict());
        if (!result.success()) {
            LogUtils.printInfo((Object)this, (String)"==========\u7b2c\u4e09\u65b9\u901a\u8baf\u53d1\u9001\u7ec4\u5305\u62a5\u6587\u5931\u8d25:{}", (Object[])new Object[]{result.getErrorMsg()});
            result = YuinResult.newFailureResult((String)result.getErrorCode(), (String)String.format("\u7b2c\u4e09\u65b9\u901a\u8baf\u53d1\u9001\u7ec4\u5305\u62a5\u6587[%s]", result.getErrorMsg()));
        }
        return result;
    }

    private YuinResult updPackStatusFail(JavaDict request, UpBPkginfoVo upBPkginfoVoCond, YuinResult result) {
        UpBPkginfoVo upBPkginfoVoUpd = new UpBPkginfoVo();
        upBPkginfoVoUpd.setPackstatus("3");
        upBPkginfoVoUpd.setErrcode(result.getErrorCode());
        upBPkginfoVoUpd.setErrmsg(result.getErrorMsg());
        LogUtils.printInfo((Object)this, (String)"==========\u5305\u72b6\u6001[3-\u7ec4\u5305\u5931\u8d25] errcode[{}] errmsg[{}]", (Object[])new Object[]{result.getErrorCode(), result.getErrorMsg()});
        int updnum = this.upBPkginfoRepo.updatePkgInfo(upBPkginfoVoUpd, upBPkginfoVoCond);
        if (updnum < 1) {
            LogUtils.printInfo((Object)this, (String)"==========\u66f4\u65b0\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u72b6\u6001[3-\u7ec4\u5305\u5931\u8d25]\u5f02\u5e38", (Object[])new Object[0]);
            return YuinResult.newFailureResult((String)"S5004", (String)"\u66f4\u65b0\u5305\u4fe1\u606f\u767b\u8bb0\u7c3f\u72b6\u6001[3-\u7ec4\u5305\u5931\u8d25]\u5f02\u5e38");
        }
        return result;
    }

    private String getPkgMsgtype(UpBPkginfoVo upBPkginfoVo) {
        if (Arrays.asList("beps.381.001.01", "beps.381.001.02", "beps.383.001.01", "beps.383.001.02").contains(upBPkginfoVo.getMsgtype()) && upBPkginfoVo.getPkgsucamt().compareTo(new BigDecimal(0)) == 0) {
            LogUtils.printInfo((Object)this, (String)"\u6279\u91cf\u4ee3\u6536\u4ed8\u4e1a\u52a1\u56de\u6267\u62a5\u6587\u6210\u529f\u6c47\u603b\u91d1\u989d\u4e3a0\uff0c\u5168\u90e8\u62d2\u7edd\uff0c\u8f6c\u6362msgtype\u4e3a[{}]", (Object[])new Object[]{"beps.388.001.01"});
            return "beps.388.001.01";
        }
        return upBPkginfoVo.getMsgtype();
    }

    static {
        functionPackMap.put("beps.121.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps12100101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.122.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps12200101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.125.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps12500101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.127.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps12700101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.128.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps12800101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.130.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps13000101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.133.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps13300101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.134.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps13400101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.381.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps38100101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.381.001.02", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps38100102((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.383.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps38300101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("beps.388.001.01", (packdata, detaildata) -> UPP91101SubService.supplePkgDataBeps38800101((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG001", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG001((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG002", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG002((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG005", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG005((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG006", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG006((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG007", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG007((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG008", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG008((JavaDict)packdata, (JavaDict)detaildata));
        functionPackMap.put("PKG011", (packdata, detaildata) -> UPP91101SubService.supplePkgDataPKG011((JavaDict)packdata, (JavaDict)detaildata));
    }
}

