/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g70;

import cn.com.yusys.yusp.commons.util.BeanToMapUtils;
import cn.com.yusys.yusp.pay.center.beps.domain.config.FtpConfig;
import cn.com.yusys.yusp.pay.center.beps.domain.entity.upp.g70.UPP70122Do;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPComService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPFileService;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpBHvpschkdtlVo;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.YuinBeanUtil;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UPP70122SubService {
    @Value(value="${chkfile.path}")
    private String chkFilePath;
    @Autowired
    private FtpConfig ftpConfig;
    @Resource
    private UPPComService uppComService;
    @Resource
    private UPPFileService uppFileService;

    public YuinResult clearAfterData(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult fileCheck(JavaDict request) {
        Object result = null;
        try {
            Map ftpInfo = YuinBeanUtil.transBean2Map((Object)this.ftpConfig);
            request.setMap(ftpInfo);
            String dstPath = String.format("%s%s", this.ftpConfig.getDstpath(), this.chkFilePath);
            File file = new File(dstPath);
            if (!file.exists() && file.isDirectory()) {
                return YuinResult.newFailureResult((String)"E1901", (String)"\u5bf9\u8d26\u4e0a\u4f20\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            }
            String sumPath = dstPath + "/" + request.getString("chkdate") + "/" + request.getString("filename") + ".txt";
            File sumFile = new File(sumPath);
            if (sumFile.exists()) {
                sumFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u5bf9\u8d26\u6587\u4ef6\u68c0\u67e5\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDeal70122(JavaDict request) {
        Object result = null;
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            List listChk = (List)request.get("listChk");
            AtomicInteger listChkCount = new AtomicInteger(0);
            listChkCount.get();
            while (listChkCount.get() < listChk.size()) {
                LinkedHashMap param = (LinkedHashMap)listChk.get(listChkCount.get());
                List listDtl = (List)param.get("listDetail");
                AtomicInteger listDtlCount = new AtomicInteger(0);
                listDtlCount.get();
                while (listDtlCount.get() < listDtl.size()) {
                    LinkedHashMap item = (LinkedHashMap)listDtl.get(listDtlCount.get());
                    UpBHvpschkdtlVo vo = new UpBHvpschkdtlVo();
                    vo.setSysid(request.getString("sysid"));
                    vo.setAppid(request.getString("appid"));
                    vo.setChkdate(request.getString("chkdate"));
                    vo.setSendbank((String)item.get("origsendbank"));
                    vo.setMsgid((String)item.get("origmsgid"));
                    BigDecimal curAmt = new BigDecimal((String)item.get("curamt"));
                    BigDecimal curAmtFmt = curAmt.setScale(2, 2);
                    vo.setAmt(curAmtFmt);
                    if ("1".equals(item.get("dcflag"))) {
                        vo.setDcflag("1");
                    } else if ("2".equals(item.get("dcflag"))) {
                        vo.setDcflag("2");
                    } else {
                        vo.setDcflag("2");
                    }
                    vo.setMsgtype((String)param.get("msgtype"));
                    vo.setBusitype((String)param.get("busitype"));
                    vo.setCorpstatus((String)param.get("busistatus"));
                    if ("SR00".equals(param.get("mbflag"))) {
                        vo.setMbflag("1");
                    } else {
                        vo.setMbflag("2");
                    }
                    Map map = BeanToMapUtils.beanToMap((Object)((Object)vo));
                    list.add(map);
                    listDtlCount.addAndGet(1);
                }
                listChkCount.addAndGet(1);
            }
            request.set("chktabulatedtl", list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult chkDetailFileGeneration(JavaDict request) {
        YuinResult result = null;
        try {
            String fileName = request.getString("filename");
            List tabulateDateList = (List)request.get("chktabulatedtl");
            String tabulateDate = JSON.toJSONString((Object)tabulateDateList, (boolean)true);
            String tabulateDatePath = String.format("%s%s%s", this.ftpConfig.getDstpath(), this.chkFilePath, request.getString("chkdate"));
            result = UPPFileService.writeToFile(tabulateDate, tabulateDatePath, fileName);
            if (!result.success()) {
                return result;
            }
            String okPath = String.format("%s%s%s", this.ftpConfig.getDstpath(), this.chkFilePath, request.getString("chkdate"));
            result = UPPFileService.writeToFile("", okPath, "OK");
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult httpCheck(JavaDict request) {
        YuinResult result = null;
        try {
            UPP70122Do msgInfo = new UPP70122Do();
            YuinBeanUtil.mapToBean((Map)request.get(), (Object)msgInfo);
            Map reqMsg = YuinBeanUtil.transBean2Map((Object)msgInfo);
            result = this.uppComService.payCheckCommDeal(request.getString("sysid"), request.getString("appid"), request.getString("tradecode"), reqMsg);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }
}

