/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g70;

import cn.com.yusys.yusp.commons.util.BeanToMapUtils;
import cn.com.yusys.yusp.pay.center.beps.domain.config.FtpConfig;
import cn.com.yusys.yusp.pay.center.beps.domain.entity.upp.g70.UPP70101Do;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPComService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPFileService;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpBHvpschksumVo;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.YuinBeanUtil;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UPP70101SubService {
    @Value(value="${chkfile.path}")
    private String chkFilePath;
    @Autowired
    private FtpConfig ftpConfig;
    @Resource
    private UPPComService uppComService;
    @Resource
    private UPPFileService uppFileService;
    @Resource
    private TradeOperDbService tradeOperDbService;

    public YuinResult fileCheck(JavaDict request) {
        Object result = null;
        try {
            String dtlPath;
            File dtlFile;
            String sumDtlPath;
            File sumDtlFile;
            Map ftpInfo = YuinBeanUtil.transBean2Map((Object)this.ftpConfig);
            request.setMap(ftpInfo);
            String dstPath = String.format("%s%s", this.ftpConfig.getDstpath(), this.chkFilePath);
            File file = new File(dstPath);
            if (!file.exists() && file.isDirectory()) {
                return YuinResult.newFailureResult((String)"E1901", (String)"\u5bf9\u8d26\u4e0a\u4f20\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            }
            String[] split = request.getString("filename").split("|");
            String sumPath = dstPath + "/" + request.getString("chkdate") + "/" + split[0] + ".txt";
            File sumFile = new File(sumPath);
            if (sumFile.exists()) {
                sumFile.delete();
            }
            if ((sumDtlFile = new File(sumDtlPath = dstPath + "/" + request.getString("chkdate") + "/" + split[1] + ".txt")).exists()) {
                sumDtlFile.delete();
            }
            if ((dtlFile = new File(dtlPath = dstPath + "/" + request.getString("chkdate") + "/" + split[1] + ".txt")).exists()) {
                dtlFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u5bf9\u8d26\u6587\u4ef6\u68c0\u67e5\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult accountFileGeneration(JavaDict request) {
        YuinResult result = null;
        try {
            String fileName = request.getString("filename");
            String[] fileNames = fileName.split("\\|");
            List tabulateDateList = (List)request.get("chktabulatedata");
            String tabulateDate = JSON.toJSONString((Object)tabulateDateList, (boolean)true);
            String tabulateDatePath = String.format("%s%s%s", this.ftpConfig.getDstpath(), this.chkFilePath, request.getString("chkdate"));
            result = UPPFileService.writeToFile(tabulateDate, tabulateDatePath, fileNames[0]);
            if (!result.success()) {
                return result;
            }
            List businessDateList = (List)request.get("chkbusinessdate");
            String businessDate = JSON.toJSONString((Object)businessDateList, (boolean)true);
            String businessDatePath = String.format("%s%s%s", this.ftpConfig.getDstpath(), this.chkFilePath, request.getString("chkdate"));
            result = UPPFileService.writeToFile(businessDate, businessDatePath, fileNames[1]);
            if (!result.success()) {
                return result;
            }
            List tabulateDetailList = (List)request.get("chkbusinessdtl");
            String tabulateDetail = JSON.toJSONString((Object)tabulateDetailList, (boolean)true);
            String tabulateDetailPath = String.format("%s%s%s", this.ftpConfig.getDstpath(), this.chkFilePath, request.getString("chkdate"));
            result = UPPFileService.writeToFile(tabulateDetail, tabulateDetailPath, fileNames[2]);
            if (!result.success()) {
                return result;
            }
            String okPath = String.format("%s%s%s", this.ftpConfig.getDstpath(), this.chkFilePath, request.getString("chkdate"));
            result = UPPFileService.writeToFile("", okPath, "OK");
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u5bf9\u8d26\u6587\u4ef6\u751f\u6210\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult clearAfterData(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult httpCheck(JavaDict request) {
        YuinResult result = null;
        try {
            UPP70101Do msgInfo = new UPP70101Do();
            YuinBeanUtil.mapToBean((Map)request.get(), (Object)msgInfo);
            Map reqMsg = YuinBeanUtil.transBean2Map((Object)msgInfo);
            result = this.uppComService.payCheckCommDeal(request.getString("sysid"), request.getString("appid"), request.getString("msgtradecode"), reqMsg);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"E8999", (String)"\u8c03\u7528\u7edf\u4e00\u5bf9\u8d26\u5e73\u53f0\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult chkListDeal(JavaDict request) {
        Object result = null;
        ArrayList<Object> detailList = new ArrayList<Object>();
        try {
            List payList = (List)request.get("paylist");
            AtomicInteger payCount = new AtomicInteger(0);
            payCount.get();
            while (payCount.get() < payList.size()) {
                LinkedHashMap item = (LinkedHashMap)payList.get(payCount.get());
                item.put("sysid", request.getString("sysid"));
                item.put("appid", request.getString("appid"));
                item.put("chkdate", request.getString("chkdate"));
                item.put("chktype", "1");
                Integer count = Integer.valueOf(item.get("sendcnt").toString());
                this.addList(detailList, count, item, "1");
                count = Integer.valueOf(item.get("recvcnt").toString());
                this.addList(detailList, count, item, "2");
                payCount.addAndGet(1);
            }
            List msgList = (List)request.get("msglist");
            AtomicInteger msgCount = new AtomicInteger(0);
            msgCount.get();
            while (msgCount.get() < msgList.size()) {
                LinkedHashMap item = (LinkedHashMap)msgList.get(msgCount.get());
                item.put("sysid", request.getString("sysid"));
                item.put("appid", request.getString("appid"));
                item.put("chkdate", request.getString("chkdate"));
                item.put("chktype", "2");
                Integer count = Integer.valueOf(item.get("sendcnt").toString());
                this.addList(detailList, count, item, "1");
                count = Integer.valueOf(item.get("recvcnt").toString());
                this.addList(detailList, count, item, "2");
                msgCount.addAndGet(1);
            }
            request.set("chktabulatedata", detailList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"E8999", (String)"\u5bf9\u8d26\u603b\u63a7\u660e\u7ec6\u5904\u7406\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    private void addList(List<Object> detailList, Integer count, Map item, String mbFlag) {
        if (0 != count) {
            item.put("mbflag", mbFlag);
            UpBHvpschksumVo chkSum = new UpBHvpschksumVo();
            YuinBeanUtil.mapToBean((Map)item, (Object)((Object)chkSum));
            chkSum.setCorpstatus((String)item.get("busistatus"));
            if ("1".equals(mbFlag)) {
                chkSum.setTotalcnt(Integer.valueOf((String)item.get("sendcnt")).toString());
                BigDecimal sendAmt = new BigDecimal((String)item.get("sendamt"));
                BigDecimal sendAmtFmt = sendAmt.setScale(2, 2);
                chkSum.setTotalamt(sendAmtFmt);
            }
            if ("2".equals(mbFlag)) {
                chkSum.setTotalcnt(Integer.valueOf((String)item.get("recvcnt")).toString());
                BigDecimal recvAmt = new BigDecimal((String)item.get("recvamt"));
                BigDecimal recvAmtFmt = recvAmt.setScale(2, 2);
                chkSum.setTotalamt(recvAmtFmt);
            }
            chkSum.setChkresult("0");
            Map map = BeanToMapUtils.beanToMap((Object)((Object)chkSum));
            detailList.add(map);
        }
    }

    public YuinResult businessListDeal(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult businessDetailDeal(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

