/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g50;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPCrtService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.DataProcService;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.HostProcService;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ECorpStatus;
import cn.hutool.core.collection.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UPP50004SubService {
    @Resource
    private HostProcService hostProcService;
    @Resource
    private DataProcService dataProcService;
    @Resource
    private UPPCrtService uppCrtService;
    @Resource
    private TradeOperDbService tradeOperDbService;

    public YuinResult initBUP50004(JavaDict javaDict, List<String> inStepParam) {
        Object result = null;
        try {
            String sysFlag = javaDict.getString(inStepParam.get(0));
            if ("2".equals(sysFlag)) {
                if (javaDict.getString("origmsgtype").length() == 6) {
                    javaDict.set("origbusimsgid", (Object)javaDict.getString("origbusimsgid").substring(8));
                }
                if (ECorpStatus.MPS_CORPSTATUS_QUEUE.getCode().equals(javaDict.getString(inStepParam.get(1)))) {
                    javaDict.set("__STEPSTATUS__", (Object)"1");
                    List<String> list = Arrays.asList("HVZI0001", "BEZI0001", "SAZI0001");
                    if (list.contains(javaDict.get("corperrcode"))) {
                        javaDict.set("__stepaddflag__", (Object)"1");
                    }
                }
                if (ECorpStatus.MPS_CORPSTATUS_WASH.getCode().equals(inStepParam.get(1))) {
                    javaDict.set("__STEPSTATUS__", (Object)"2");
                }
            }
        }
        catch (Exception e) {
            LogUtils.printError((Object)this, (String)"\u83b7\u53d6\u4e1a\u52a1\u64a4\u9500\u7684\u6b65\u9aa4\u72b6\u6001\u5f02\u5e38", (Object[])new Object[]{e});
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult hostRev50004(JavaDict request) {
        JavaDict hostRequest = new JavaDict();
        hostRequest.set((IDict)request);
        try {
            if (StringUtils.isEmpty((String)request.getString("__acctflow__")) || StringUtils.isEmpty((String)request.getString("__acctscne__"))) {
                return YuinResult.newFailureResult((String)"O6468", (String)PayErrorCode.getErrmsg((String)"O6468"));
            }
            hostRequest.set("__acctflow__", (Object)request.getString("__acctflow__"));
            hostRequest.set("__acctscne__", (Object)hostRequest.getString("__acctscne__"));
            YuinResult result = this.dataProcService.updMainjnlByStepCtrl(hostRequest);
            if (!result.success()) {
                return result;
            }
            if ("00".equals(request.getString("acctflag"))) {
                return YuinResult.newSuccessResult(null);
            }
            result = this.hostProcService.hostComm(hostRequest);
            if (!result.success()) {
                return result;
            }
            JavaDict rspDict = (JavaDict)request.get("__host_acct_rsp__");
            Map hostAcctRsp = rspDict.get();
            if (hostAcctRsp.containsKey("rtncode") && "000000".equals(hostAcctRsp.get("rtncode"))) {
                request.set("bankstatus", (Object)"1");
                request.set("__stepstatus__", (Object)"1");
                result = this.dataProcService.updMainjnlByStepCtrl(hostRequest);
                if (!result.success()) {
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult hostRevBeps50004(JavaDict request) {
        YuinResult result = null;
        try {
            if (request.hasKey("corpstatus") && "PR07".equals(request.getString("corpstatus")) || request.hasKey("returnflag") && "1".equals(request.getString("returnflag"))) {
                List<String> msgTypeList = Arrays.asList("beps.125.001.01", "PKG005");
                result = request.hasKey("origmsgtype") && msgTypeList.contains(request.getString("origmsgtype")) ? this.timeCredit(request) : this.notTimeCredit(request);
            } else {
                request.set("__CHILTRADEFLAG__", (Object)"1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult notTimeCredit(JavaDict request) {
        YuinResult result = null;
        try {
            List<String> msgTypeList = Arrays.asList("beps.134.001.01", "beps.128.001.01", "PKG006", "PKG008");
            String actionKey = request.hasKey("origmsgtype") && msgTypeList.contains(request.getString("origmsgtype")) ? "__SELBUPMTRANJNL02__" : "__SELBUPMTRANJNL__";
            YuinResultDto selresult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), actionKey);
            if (!selresult.isSuccess()) {
                return YuinResult.newFailureResult((String)selresult.getHead().getResponseCode(), (String)selresult.getHead().getResponseMsg());
            }
            List selResultList = (List)selresult.getBody();
            if (CollectionUtil.isEmpty((Collection)selResultList)) {
                request.set("__CHILTRADEFLAG__", (Object)"1");
            }
            for (Map item : selResultList) {
                JavaDict hostRequest = new JavaDict();
                hostRequest.set((IDict)request);
                hostRequest.set("origbusiworkdate", item.get("workdate"));
                hostRequest.set("origbusiworkseqid", item.get("workseqid"));
                YuinResultDto detail = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), "__SELBUPMTRANACT__");
                if (!selresult.isSuccess()) {
                    return YuinResult.newFailureResult((String)selresult.getHead().getResponseCode(), (String)selresult.getHead().getResponseMsg());
                }
                List detailList = (List)selresult.getBody();
                Map firstMap = (Map)detailList.get(0);
                hostRequest.set("appid", firstMap.get("appid"));
                hostRequest.set("sysid", firstMap.get("sysid"));
                hostRequest.set("origworkdate", firstMap.get("workdate"));
                hostRequest.set("origworkseqid", firstMap.get("workseqid"));
                hostRequest.set("origbankdate", firstMap.get("bankdate"));
                hostRequest.set("origbankseqno", firstMap.get("bankseqno"));
                hostRequest.set("brno", firstMap.get("brno"));
                hostRequest.set("tellerno", firstMap.get("tellerno"));
                hostRequest.set("origbusikind", item.get("busikind"));
                hostRequest.set("origbusitype", firstMap.get("busitype"));
                hostRequest.set("__acctflow__", (Object)request.getString("__acctflow1__"));
                hostRequest.set("__acctscne__", (Object)hostRequest.getString("__acctscne1__"));
                result = this.hostDeal(hostRequest);
                if (result.success()) continue;
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult timeCredit(JavaDict request) {
        YuinResult result = null;
        try {
            YuinResultDto selresult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), request.getString("__SELBUPMTRANJNL01__"));
            if (!selresult.isSuccess()) {
                return YuinResult.newFailureResult((String)selresult.getHead().getResponseCode(), (String)selresult.getHead().getResponseMsg());
            }
            List selResultList = (List)selresult.getBody();
            if (!CollectionUtil.isEmpty((Collection)selResultList)) {
                Map firstMap = (Map)selResultList.get(0);
                request.set("appid", firstMap.get("appid"));
                request.set("sysid", firstMap.get("sysid"));
                request.set("origworkdate", firstMap.get("workdate"));
                request.set("origworkseqid", firstMap.get("workseqid"));
                request.set("curcode", firstMap.get("curcode"));
                request.set("amt", firstMap.get("amt"));
                request.set("realtradeamt", (Object)(StringUtils.isEmpty((String)((String)firstMap.get("realtradeamt"))) ? "" : firstMap.get("realtradeamt")));
                request.set("origbankdate", firstMap.get("bankdate"));
                request.set("origbankseqno", firstMap.get("bankseqno"));
                request.set("brno", firstMap.get("brno"));
                request.set("tellerno", firstMap.get("tellerno"));
                request.set("__acctflow__", (Object)request.getString("__acctflow2__"));
                request.set("__acctscne__", (Object)request.getString("__acctscne2__"));
                result = this.hostDeal(request);
                if (!result.success()) {
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"E0103", (String)PayErrorCode.getErrmsg((String)"E0103"));
        }
        return YuinResult.newSuccessResult(null);
    }

    private YuinResult hostDeal(JavaDict request) {
        YuinResult result = null;
        try {
            JavaDict hostRequest = new JavaDict();
            hostRequest.set((IDict)request);
            result = this.hostProcService.hostComm(request);
            JavaDict rspDict = (JavaDict)hostRequest.get("__host_acct_rsp__");
            Map hostAcctRsp = rspDict.get();
            if (hostAcctRsp.containsKey("rtncode") && "000000".equals(hostAcctRsp.get("rtncode"))) {
                result = this.dataProcService.updMainjnlByStepCtrl(hostRequest);
                if (!result.success()) {
                    return YuinResult.newFailureResult((String)"S5999", (String)"\u8bb0\u8d26\u6210\u529f\u4fee\u6539\u4e1a\u52a1\u8868\u5931\u8d25");
                }
            } else {
                return YuinResult.newFailureResult((String)"E8199", (String)"\u8c03\u7528\u6838\u5fc3\u901a\u8baf\u5931\u8d25");
            }
            request.set("__CHILTRADEFLAG__", (Object)"1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult hostRevHvps50004(JavaDict request) {
        YuinResult result = null;
        try {
            if (request.hasKey("corpstatus") && "PR07".equals(request.getString("corpstatus")) || request.hasKey("returnflag") && "1".equals(request.getString("returnflag"))) {
                YuinResultDto selresult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), request.getString("__SELBUPMTRANJNL__"));
                if (!selresult.isSuccess()) {
                    return YuinResult.newFailureResult((String)selresult.getHead().getResponseCode(), (String)selresult.getHead().getResponseMsg());
                }
                List selResultList = (List)selresult.getBody();
                if (!CollectionUtil.isEmpty((Collection)selResultList)) {
                    Map firstMap = (Map)selResultList.get(0);
                    request.set("appid", firstMap.get("appid"));
                    request.set("sysid", firstMap.get("sysid"));
                    request.set("brno", firstMap.get("brno"));
                    request.set("tellerno", firstMap.get("tellerno"));
                    request.set("origbankdate", firstMap.get("bankdate"));
                    request.set("origbankseqno", firstMap.get("bankseqno"));
                    request.set("__acctflow__", (Object)request.getString("__acctflow__"));
                    request.set("__acctscne__", (Object)request.getString("__acctscne__"));
                    result = this.hostDeal(request);
                    if (!result.success()) {
                        return result;
                    }
                } else {
                    request.set("__CHILTRADEFLAG__", (Object)"1");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getAcctFlag(JavaDict request, String addflag) {
        Object result = null;
        try {
            if ("1".equals(addflag)) {
                request.set("acctflag", (Object)"00");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }
}

