/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g15;

import cn.com.yusys.yusp.pay.base.sign.client.dto.ProtoListReqDto;
import cn.com.yusys.yusp.pay.base.sign.client.inter.PaySignClient;
import cn.com.yusys.yusp.pay.center.beps.domain.config.FtpConfig;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsPkgService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPFileService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.YuinBeanUtil;
import cn.com.yusys.yusp.pay.common.busideal.component.dataformat.service.MsgFieldMapCompentService;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15901SubService {
    @Autowired
    private BepsPkgService bepsPkgService;
    @Autowired
    private TradeStatusService tradeStatusService;
    @Autowired
    private TradeOperDbService tradeOperDbService;
    @Autowired
    private MsgFieldMapCompentService msgFieldMapCompentService;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPPFileService uppFileService;
    @Autowired
    private PaySignClient paySignClient;

    public YuinResult busiHandler(JavaDict request) {
        try {
            YuinResultDto selResult;
            if (request.getString("tradecode").equals("UPP15904")) {
                ProtoListReqDto protoListReqDto = new ProtoListReqDto();
                protoListReqDto.setSysid("UPP");
                protoListReqDto.setAppid("BEPS");
                protoListReqDto.setPrototype("UPPT0103");
                protoListReqDto.setProtono(request.getString("protocolno"));
                protoListReqDto.setPayeridno(request.getString("idno"));
                protoListReqDto.setPayername(request.getString("debtorname"));
                protoListReqDto.setPayeraccno(request.getString("debtoraccno"));
                protoListReqDto.setPayeraccbank(request.getString("issuer"));
                protoListReqDto.setPayeridtype(request.getString("idtype"));
                selResult = this.paySignClient.protoList(protoListReqDto);
            } else {
                selResult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), request.getString("__selectkey__"));
            }
            if (!selResult.isSuccess()) {
                return YuinResult.newFailureResult((String)selResult.getHead().getResponseCode(), (String)selResult.getHead().getResponseMsg());
            }
            List selectResults = (List)selResult.getBody();
            if (selectResults.size() <= 0) {
                return YuinResult.newFailureResult((String)"E2042", (String)ErrorCode.getErrmsg((String)"E2042"));
            }
            if (request.getString("chnlcode").equals("64")) {
                request.set("result", (Object)selectResults);
                request.set("_totalrownum_", (Object)selectResults.size());
                Map ftpInfo = YuinBeanUtil.transBean2Map((Object)this.ftpConfig);
                request.setMap(ftpInfo);
                UPP15901SubService uPP15901SubService = this;
                String localIp = uPP15901SubService.uppGetService.getLinuxLocalIp();
                request.set("ftpip", (Object)localIp);
                String filename = String.format("%s%s%s.txt", request.getString("chnlcode"), request.getString("chnldate"), request.getString("chnlseqno"));
                String srcFileName = String.format("%s%s", this.ftpConfig.getSrcpath(), filename);
                String port = this.ftpConfig.getPort();
                String localFile = String.format("%s%s", this.ftpConfig.getDstpath(), filename);
                request.set("filename", (Object)filename);
                request.set("srcfilename", (Object)srcFileName);
                request.set("port", (Object)port);
                request.set("username", (Object)this.ftpConfig.getUsername());
                request.set("password", (Object)this.ftpConfig.getPassword());
                request.set("localfile", (Object)localFile);
                YuinResult result = this.uppFileService.fileCreatOrDel(Collections.singletonList(localFile), true);
                if (result.failure()) {
                    return result;
                }
                String[] fieldList = request.getString("detailPara").split(",");
                ArrayList<Map<String, Object>> outList = new ArrayList<Map<String, Object>>();
                for (Object item : selectResults) {
                    Map itemMap = YuinBeanUtil.transBean2Map(item);
                    outList.add(itemMap);
                }
                String fileContext = this.uppFileService.listFileToString(outList, fieldList, "\u222b", String.format("%s%s", Character.valueOf('\u0017'), "\n"));
                result = this.uppFileService.writeFileContext(localFile, fileContext);
                if (result.failure()) {
                    return result;
                }
                request.set("srcpath", (Object)this.ftpConfig.getSrcpath());
            } else if (selectResults.size() <= 50) {
                request.set("result", (Object)selectResults);
                request.set("_totalrownum_", (Object)selectResults.size());
            }
            this.successInfoDeal(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    private void successInfoDeal(JavaDict request) {
        request.set("status", (Object)"1");
        request.set("errcode", (Object)"I0000");
        request.set("errmsg", (Object)"\u4ea4\u6613\u5904\u7406\u6210\u529f");
        request.set("errtype", (Object)"O00");
        request.set("infotype", (Object)"");
    }
}

