/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.pub;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.base.sign.client.inter.PaySignClient;
import cn.com.yusys.yusp.pay.center.beps.dao.po.UpBMsgmangePo;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.enumeration.ProdCodeEnum;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpBMsgmangeRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpDLimitadmRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpMChkvrfyRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.repo.data.UpMTranjnlRepo;
import cn.com.yusys.yusp.pay.center.beps.domain.service.data.UpDMsgtypemapService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpBMsgmangeVo;
import cn.com.yusys.yusp.pay.center.beps.domain.vo.data.UpMTranjnlVo;
import cn.com.yusys.yusp.pay.common.ability.domain.service.func.HostDealCommonService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.component.fieldmap.service.UpPDictService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.base.util.YuinBeanUtil;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.dao.po.UpPBankmapPo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.repo.UpPBankmapRepo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.domain.vo.UpPBankmapQueryVo;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBrnoBankInfoGetService;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ECorpStatus;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ErrorCode;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UPPGetService {
    @Autowired
    private UpPDictService upPDictService;
    @Autowired
    private UpPBrnoBankInfoGetService upPBrnoBankInfoGetService;
    @Autowired
    private UpDMsgtypemapService upDMsgtypemapService;
    @Autowired
    private TradeOperDbService tradeOperDbService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UpBMsgmangeRepo upBMsgmangeRepo;
    @Resource
    private UpPBankinfoService uppBankinfoService;
    @Autowired
    private UpPBankmapRepo upPBankmapRepo;
    @Autowired
    private UPPChkService uPPChkService;
    @Resource
    private UpMTranjnlRepo upMTranjnlRepo;
    @Resource
    private HostDealCommonService hostDealCommonService;
    @Resource
    private UpDLimitadmRepo upDLimitadmRepo;
    @Resource
    private UpMChkvrfyRepo upMChkvrfyRepo;
    @Resource
    private PaySignClient paySignClient;

    public static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    public YuinResult getDictMap(JavaDict javaDict, String dictInfo, String outStr) {
        YuinResult result = this.upPDictService.getDictValue2ByKey(javaDict, dictInfo);
        if (!result.success()) {
            LogUtils.printInfo((Object)this, (String)"{}-{}", (Object[])new Object[]{outStr, result.getErrorMsg()});
            return YuinResult.newFailureResult((String)result.getErrorCode(), (String)result.getErrorMsg());
        }
        LogUtils.printInfo((Object)this, (String)"[{}]|[{}]", (Object[])new Object[]{outStr, result.getOutputParams().get(0)});
        javaDict.set(outStr, result.getOutputParams().get(0));
        return YuinResult.newSuccessResult(null);
    }

    public String getDictKeyValue(JavaDict javaDict, String dictInfo, String key) {
        YuinResult result = this.upPDictService.getDictValue2ByKey(javaDict, dictInfo);
        if (result.success()) {
            return String.format("%s-%s", key, result.getOutputParams().get(0));
        }
        return String.format("%s", key);
    }

    public YuinResult getRealTradeAmt(JavaDict request, String[] listInPara, String[] listOutPara) {
        try {
            BigDecimal initAmt = new BigDecimal(0.0);
            for (String inParm : listInPara) {
                request.set(inParm, (Object)request.getBigDecimal(inParm, initAmt));
            }
            if (listInPara.length < 2) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u5b9e\u9645\u4ea4\u6613\u91d1\u989d\u81f3\u5c11\u5305\u542b\u4ea4\u6613\u91d1\u989d\u53ca\u624b\u7eed\u8d39\u91d1\u989d");
            }
            if (listInPara.length == 3) {
                LogUtils.printInfo((Object)this, (String)"\u4ea4\u6613\u91d1\u989d: {} \u624b\u7eed\u8d39: {} \u5de5\u672c\u8d39: {}", (Object[])new Object[]{request.get(listInPara[0]), request.get(listInPara[1]), request.get(listInPara[2])});
            } else {
                LogUtils.printInfo((Object)this, (String)"\u4ea4\u6613\u91d1\u989d: {} \u624b\u7eed\u8d39: {}", (Object[])new Object[]{request.get(listInPara[0]), request.get(listInPara[1])});
            }
            if (listOutPara.length < 1) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u81f3\u5c11\u5305\u542b\u4e00\u4e2a\u51fa\u53c2\u53d8\u91cf");
            }
            if ("1".equals(request.getString("mbflag")) && request.getBigDecimal(listInPara[0]).compareTo(initAmt) == 0) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u5f80\u8d26\u4ea4\u6613\u91d1\u989d\u4e0d\u80fd\u4e3a0");
            }
            if (request.getBigDecimal(listInPara[0]).compareTo(initAmt) < 0) {
                return YuinResult.newFailureResult((String)"O1022", (String)"\u4ea4\u6613\u91d1\u989d\u975e\u6cd5");
            }
            BigDecimal realTradeAmt = request.getBigDecimal(listInPara[0]).add(request.getBigDecimal(listInPara[1]));
            if (listInPara.length == 3) {
                realTradeAmt = realTradeAmt.add(request.getBigDecimal(listInPara[2]));
            }
            request.set(listOutPara[0], (Object)realTradeAmt);
            LogUtils.printInfo((Object)this, (String)"\u5b9e\u9645\u4ea4\u6613\u91d1\u989d: [{}][{}]", (Object[])new Object[]{listOutPara[0], realTradeAmt});
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u83b7\u53d6\u5b9e\u9645\u4ea4\u6613\u91d1\u989d\u5f02\u5e38: %s", e.getMessage()));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getAcctBankInfo(JavaDict request, String accbrno, String[] banknameList) {
        try {
            if (StringUtils.isBlank((CharSequence)accbrno)) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u5f00\u6237\u673a\u6784\u53f7\u4e0d\u5b58\u5728");
            }
            YuinResult result = this.upPBrnoBankInfoGetService.getAcctBankInfoByBrno(request, accbrno, banknameList);
            if (!result.success()) {
                return result;
            }
            JavaDict valueDict = (JavaDict)result.getOutputParams().get(0);
            request.set((IDict)valueDict);
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u67e5\u8be2\u5f00\u6237\u673a\u6784\u884c\u540d\u884c\u53f7\u4fe1\u606f\u5f02\u5e38: %s", e.getMessage()));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getMsgtypeMap(JavaDict request) {
        try {
            if ("2".equals(request.getString("sysflag"))) {
                return YuinResult.newSuccessResult(null);
            }
            YuinResult result = this.upDMsgtypemapService.getMsgtypeMap(request);
            if (!result.success()) {
                return result;
            }
            String mapmsgtype = ((JavaDict)result.getOutputParams().get(0)).getString("mapmsgtype");
            request.set("__sendmsgtype__", (Object)mapmsgtype);
            LogUtils.printInfo((Object)this, (String)"\u4e00\u4e8c\u4ee3\u62a5\u6587\u6620\u5c04\u7c7b\u578b\u8f6c\u6362[{}]|[{}]", (Object[])new Object[]{"__sendmsgtype__", mapmsgtype});
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u652f\u4ed8\u7cfb\u7edf\u4e00\u4e8c\u4ee3\u62a5\u6587\u7c7b\u578b\u6620\u5c04\u5f02\u5e38: %s", e.getMessage()));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCityCodeNew(JavaDict javaDict, String[] listInPara) {
        String defaultCityCode = "150100";
        if (!javaDict.hasKey(listInPara[0])) {
            return YuinResult.newSuccessResult((Object[])new Object[]{defaultCityCode});
        }
        String sendbrno = javaDict.getString(listInPara[0]);
        LogUtils.printInfo((Object)this, (String)"\u5f00\u6237\u884c\u673a\u6784\u53f7\u662f: {}", (Object[])new Object[]{sendbrno});
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sel_clearbrno");
        javaDict.set("sendbrno", (Object)sendbrno);
        try {
            YuinResultDto result = this.tradeOperDbService.operDbaction(javaDict, javaDict.get("sysid").toString(), javaDict.get("appid").toString(), arrayList);
            List Qryresult = (List)result.getBody();
            if (CollectionUtils.isEmpty((Collection)Qryresult)) {
                return YuinResult.newSuccessResult((Object[])new Object[]{defaultCityCode});
            }
            Map itemMap = YuinBeanUtil.transBean2Map(Qryresult.get(0));
            javaDict.setMap(itemMap);
            ArrayList<String> arrayListCity = new ArrayList<String>();
            arrayListCity.add("sel_citycode");
            YuinResultDto resultCityDto = this.tradeOperDbService.operDbaction(javaDict, javaDict.get("sysid").toString(), javaDict.get("appid").toString(), arrayListCity);
            List qryResultCity = (List)resultCityDto.getBody();
            if (CollectionUtils.isEmpty((Collection)qryResultCity)) {
                return YuinResult.newSuccessResult((Object[])new Object[]{defaultCityCode});
            }
            Map itemMapCity = YuinBeanUtil.transBean2Map(qryResultCity.get(0));
            javaDict.setMap(itemMapCity);
            LogUtils.printInfo((Object)this, (String)"\u65b0\u7684\u57ce\u5e02\u4ee3\u7801\u503c\u662f: {}", (Object[])new Object[]{javaDict.getString("citycode")});
            javaDict.set("payercitycode", (Object)javaDict.getString("citycode"));
            return YuinResult.newSuccessResult((Object[])new Object[]{javaDict.getString("citycode")});
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.printInfo((Object)this, (String)"\u9519\u8bef\u4fe1\u606f: {}", (Object[])new Object[]{e.getMessage()});
            return YuinResult.newFailureResult((String)"E1099", (String)PayErrorCode.getErrmsgAdd((String)"E1099", (String)"\u83b7\u53d6\u57ce\u5e02\u4ee3\u7801\u5f02\u5e38"));
        }
    }

    public YuinResult getCityCode(JavaDict javaDict, String inparamBank, String outparamCityMap) {
        try {
            YuinResult result = this.upPBankinfoService.getBankInfoByBank(javaDict, inparamBank);
            String payeecitycode = ((JavaDict)result.getOutputParams().get(0)).getString("nodecity");
            javaDict.set(outparamCityMap, (Object)payeecitycode);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.printInfo((Object)this, (String)"\u9519\u8bef\u4fe1\u606f: {}", (Object[])new Object[]{e.getMessage()});
            return YuinResult.newFailureResult((String)"E1099", (String)PayErrorCode.getErrmsg((String)"E1099"));
        }
    }

    public YuinResult getCorpInfo(JavaDict javaDict, List<String> inParam) {
        Object result = null;
        try {
            String corpStatus = javaDict.getString(inParam.get(0));
            String corpErrCode = inParam.get(1);
            String corpErrMsg = inParam.get(2);
            if (javaDict.hasKey(corpErrCode) && javaDict.hasKey(corpErrMsg)) {
                return YuinResult.newSuccessResult(null);
            }
            if (javaDict.hasKey(corpErrCode)) {
                String msgPrefix = "";
                String msgSuffix = "";
                YuinResult sysAbbreviation = null;
                if ("HVPS".equals(javaDict.getString("appid"))) {
                    sysAbbreviation = this.upPDictService.getDictValue2ByKey(javaDict, "sysid,appid,#systemAbbreviation,#S,#System,#HV");
                } else if ("BEPS".equals(javaDict.getString("appid"))) {
                    sysAbbreviation = this.upPDictService.getDictValue2ByKey(javaDict, "sysid,appid,#systemAbbreviation,#S,#System,#BE");
                }
                List outputParams = sysAbbreviation.getOutputParams();
                msgPrefix = String.valueOf(outputParams.get(0));
                msgSuffix = PayErrorCode.getErrmsg((String)javaDict.getString(corpErrCode).substring(3));
                String innerCorpErrMsg = msgPrefix + msgSuffix;
                javaDict.set(corpErrMsg, (Object)innerCorpErrMsg);
                return YuinResult.newSuccessResult(null);
            }
            if (!javaDict.hasKey(corpErrCode)) {
                String corpErrCodeInner;
                if (ECorpStatus.MPS_CORPSTATUS_WASH.getCode().equals(corpStatus)) {
                    corpErrCodeInner = "CU1S9999";
                    if (!javaDict.hasKey(corpErrMsg)) {
                        String innerCorpErrMsg = "\u5176\u4ed6\u7cfb\u7edf\u9519";
                        javaDict.set(corpErrMsg, (Object)innerCorpErrMsg);
                    }
                } else {
                    corpErrCodeInner = "CU0I0000";
                    if (!javaDict.hasKey(corpErrMsg)) {
                        String innerCorpErrMsg = "\u5904\u7406\u6210\u529f";
                        javaDict.set(corpErrMsg, (Object)innerCorpErrMsg);
                    }
                }
                javaDict.set(corpErrCode, (Object)corpErrCodeInner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newExeptionResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)("\u83b7\u53d6\u4e2d\u5fc3\u9519\u8bef\u4fe1\u606f\u5f02\u5e38" + e.getMessage())));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getUpMsg(JavaDict javaDict) {
        String sysid = javaDict.getString("sysid");
        String appid = javaDict.getString("appid");
        String sendmsgtype = javaDict.getString("__sendmsgtype__");
        String sendclearbank = javaDict.getString("sendclearbank");
        String recvclearbank = javaDict.getString("recvclearbank");
        String authcode = javaDict.getString("authcode");
        String msgtype = sendmsgtype.substring(0, sendmsgtype.length() - 1) + "2";
        if ("ibps.101.001.02".equals(msgtype)) {
            UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
            upBMsgmangeVo.setAppid(appid);
            upBMsgmangeVo.setSysid(sysid);
            upBMsgmangeVo.setBankno(sendclearbank);
            upBMsgmangeVo.setOrigmsgtype(msgtype);
            upBMsgmangeVo.setMsgtype("MC00");
            UpBMsgmangePo upBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoSe == null) {
                LogUtils.printInfo((Object)this, (String)"{}:\u4e0d\u652f\u63011.6", (Object[])new Object[]{sendclearbank});
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            upBMsgmangeVo.setBankno(recvclearbank);
            UpBMsgmangePo upBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoRe == null) {
                LogUtils.printInfo((Object)this, (String)"{}:\u4e0d\u652f\u63011.6", (Object[])new Object[]{recvclearbank});
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            javaDict.set("sendmsgtype", (Object)upBMsgmangePoSe.getOrigmsgtype());
        } else if (javaDict.hasKey("authcode") && ("ibps.103.001.02".equals(msgtype) || "ibps.105.001.02".equals(msgtype) || "ibps.335.001.02".equals(msgtype) || "ibps.339.001.02".equals(msgtype))) {
            UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
            upBMsgmangeVo.setAppid(appid);
            upBMsgmangeVo.setSysid(sysid);
            upBMsgmangeVo.setBankno(sendclearbank);
            upBMsgmangeVo.setOrigmsgtype(msgtype);
            upBMsgmangeVo.setAuthcode(authcode);
            upBMsgmangeVo.setMsgtype("MC00");
            UpBMsgmangePo upBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoSe == null) {
                LogUtils.printInfo((Object)this, (String)"{}:\u4e0d\u652f\u63011.6", (Object[])new Object[]{sendclearbank});
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            upBMsgmangeVo.setBankno(recvclearbank);
            UpBMsgmangePo upBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (upBMsgmangePoRe == null) {
                LogUtils.printInfo((Object)this, (String)"{}:\u4e0d\u652f\u63011.6", (Object[])new Object[]{recvclearbank});
                return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
            }
            javaDict.set("sendmsgtype", (Object)upBMsgmangePoSe.getOrigmsgtype());
        } else {
            return new YuinResult(1, "", "\u6b64\u62a5\u6587\u4e0d\u5c5e\u4e8e1.6\u7c7b\u62a5\u6587\uff0c\u76f4\u63a5\u8df3\u51fa", null);
        }
        LogUtils.printInfo((Object)this, (String)"\u6700\u65b0\u7248\u672c\u62a5\u6587\u7f16\u53f7\u4e3a{}", (Object[])new Object[]{msgtype});
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getEndorserName(JavaDict javaDict) {
        Object result = null;
        try {
            String endorserName = "";
            if (javaDict.hasKey("tradecode") && "UPP01021".equals(javaDict.getString("tradecode"))) {
                if (javaDict.hasKey("circle")) {
                    List dealCircle = (List)javaDict.get("circle");
                    if (CollectionUtils.isEmpty((Collection)dealCircle)) {
                        return YuinResult.newSuccessResult(null);
                    }
                    for (Map item : dealCircle) {
                        if (!item.containsKey("endorsername")) continue;
                        endorserName = endorserName + "," + item.get("endorsername");
                    }
                    javaDict.set("endorsername", (Object)endorserName.substring(1));
                }
            } else if (javaDict.hasKey("tradecode") && "UPP01061".equals(javaDict.getString("tradecode"))) {
                List list;
                Map param;
                if (!javaDict.hasKey("listResult")) {
                    YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)"\u7f3a\u5c11listResult\u6570\u636e"));
                }
                if ((param = BeanUtils.beanToMap((list = (List)javaDict.get("listResult")).get(0))).containsKey("circle")) {
                    List dealCircle = (List)param.get("circle");
                    if (CollectionUtils.isEmpty((Collection)dealCircle)) {
                        return YuinResult.newSuccessResult(null);
                    }
                    for (Map item : dealCircle) {
                        if (!item.containsKey("endorsername")) continue;
                        endorserName = endorserName + ",";
                    }
                    param.put("endorsername", endorserName);
                    list.add(0, param);
                    javaDict.set("listResult", (Object)list);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newExeptionResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)("\u83b7\u53d6\u80cc\u4e66\u4eba\u4fe1\u606f, \u80cc\u4e66\u4eba\u4fe1\u606f\u5408\u5e76\u5f02\u5e38" + e.getMessage())));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getDrealAmt(JavaDict javaDict, String[] listInPara, String[] listOutPara) {
        BigDecimal initAmt = new BigDecimal(0.0);
        if (listInPara.length < 2) {
            return YuinResult.newFailureResult((String)"S9001", (String)"B_Get_RealTradeAmt\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u5165\u53c2");
        }
        for (String inParm : listInPara) {
            if (javaDict.hasKey(inParm)) continue;
            javaDict.set(inParm, (Object)"0");
        }
        LogUtils.printInfo((Object)this, (String)"\u4ea4\u6613\u91d1\u989d\uff1a{}", (Object[])new Object[]{javaDict.getBigDecimal(listInPara[0])});
        LogUtils.printInfo((Object)this, (String)"\u624b\u7eed\u8d39\uff1a{}", (Object[])new Object[]{javaDict.getBigDecimal(listInPara[1])});
        if (javaDict.getBigDecimal(listInPara[0]).compareTo(initAmt) <= 0) {
            return YuinResult.newFailureResult((String)"O1022", (String)PayErrorCode.getErrmsg((String)"O1022"));
        }
        if (javaDict.hasKey("feemode") && "0".equals(javaDict.getString("feemode"))) {
            BigDecimal intAmt = javaDict.getBigDecimal(listInPara[0]).subtract(javaDict.getBigDecimal(listInPara[1]));
            javaDict.set(listOutPara[0], (Object)intAmt);
        } else {
            javaDict.set(listOutPara[0], (Object)javaDict.getBigDecimal(listInPara[0]));
        }
        LogUtils.printInfo((Object)this, (String)"\u5b9e\u9645\u4ea4\u6613\u91d1\u989d\uff1a{}", (Object[])new Object[]{javaDict.getBigDecimal(listOutPara[0])});
        return YuinResult.newSuccessResult(null);
    }

    public String calcDate(String strDate, String strDtUnt, int strDtStp) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            Date dtDate = format.parse(strDate);
            Calendar calender = Calendar.getInstance();
            calender.setTime(dtDate);
            int month = calender.get(2) + strDtStp;
            int year = calender.get(1) + month / 12;
            month %= 12;
            int day = Math.min(calender.get(5), calender.getActualMaximum(5));
            if ("TU02".equals(strDtUnt)) {
                day += strDtStp;
                day = Math.min(calender.get(5), calender.getActualMaximum(5));
                day = Math.max(day, 1);
                return String.format("%04d%02d%02d", year, month, day);
            }
            if ("TU01".equals(strDtUnt)) {
                day = 1;
                return String.format("%04d%02d%02d", year, month, day);
            }
            if ("TU00".equals(strDtUnt)) {
                month = 0;
                day = 1;
                return String.format("%04d%02d%02d", year, month, day);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public YuinResult getUpMsgGood(JavaDict javaDict, String[] listInPara) {
        try {
            if ("UPP14065".equals(javaDict.getString("tradecode"))) {
                return YuinResult.newSuccessResult(null);
            }
            if (javaDict.hasKey("origmsgtype") && "ibps.335.001.03".equals(javaDict.getString("origmsgtype")) && javaDict.hasKey("authcode") && "AC03".equals(javaDict.getString("authcode"))) {
                javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.02");
                YuinResult.newSuccessResult(null);
            }
            if (listInPara.length < 5) {
                return YuinResult.newFailureResult((String)"S9001", (String)"B_Get_RealTradeAmt\u81f3\u5c11\u9700\u89815\u4e2a\u5165\u53c2");
            }
            String appid = javaDict.getString("appid");
            String authcode = javaDict.hasKey(listInPara[4]) ? javaDict.getString(listInPara[4]) : "";
            String sysid = javaDict.getString(listInPara[0]);
            String sendmsgtype = javaDict.hasKey(listInPara[1]) ? javaDict.getString(listInPara[1]) : "";
            String sendclearbank = javaDict.hasKey(listInPara[2]) ? javaDict.getString(listInPara[2]) : "";
            String recvclearbank = javaDict.hasKey(listInPara[3]) ? javaDict.getString(listInPara[3]) : "";
            String msgtype = sendmsgtype.substring(0, sendmsgtype.length() - 2);
            String msgtype1 = sendmsgtype.substring(0, sendmsgtype.length() - 2);
            LogUtils.printInfo((Object)this, (String)"sysid:{}", (Object[])new Object[]{sysid});
            LogUtils.printInfo((Object)this, (String)"sendmsgtype:{}", (Object[])new Object[]{sendmsgtype});
            LogUtils.printInfo((Object)this, (String)"sendclearbank:{}", (Object[])new Object[]{sendclearbank});
            LogUtils.printInfo((Object)this, (String)"recvclearbank:{}", (Object[])new Object[]{recvclearbank});
            if ("ibps.337.001.01".equals(javaDict.getString("sendmsgtype"))) {
                UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
                upBMsgmangeVo.setAppid(appid);
                upBMsgmangeVo.setSysid(sysid);
                upBMsgmangeVo.setBankno(sendclearbank);
                upBMsgmangeVo.setOrigmsgtype(msgtype1);
                upBMsgmangeVo.setMsgtype("MC00");
                UpBMsgmangePo upBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
                upBMsgmangeVo.setBankno(recvclearbank);
                UpBMsgmangePo upBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
                if (upBMsgmangePoSe != null && upBMsgmangePoRe != null) {
                    if (Integer.valueOf(upBMsgmangePoSe.getOrigmsgtype()) > Integer.valueOf(upBMsgmangePoRe.getOrigmsgtype())) {
                        javaDict.set("__sendmsgtype__", (Object)upBMsgmangePoRe.getOrigmsgtype());
                    } else {
                        javaDict.set("__sendmsgtype__", (Object)upBMsgmangePoSe.getOrigmsgtype());
                    }
                } else {
                    javaDict.set("__sendmsgtype__", (Object)(msgtype + "01"));
                }
                return YuinResult.newSuccessResult(null);
            }
            if ("UPP14052".equals(javaDict.getString("tradecode"))) {
                if ("ibps.335.001.03".equals(javaDict.getString("origmsgtype"))) {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.02");
                } else {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.01");
                }
                return YuinResult.newSuccessResult(null);
            }
            UpBMsgmangeVo upBMsgmangeVo = new UpBMsgmangeVo();
            upBMsgmangeVo.setAppid(appid);
            upBMsgmangeVo.setSysid(sysid);
            upBMsgmangeVo.setBankno(sendclearbank);
            upBMsgmangeVo.setOrigmsgtype(msgtype1);
            upBMsgmangeVo.setAuthcode(authcode);
            upBMsgmangeVo.setMsgtype("MC00");
            UpBMsgmangePo resultUpBMsgmangePoSe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            upBMsgmangeVo.setBankno(recvclearbank);
            UpBMsgmangePo reslutUpBMsgmangePoRe = this.upBMsgmangeRepo.selectById(upBMsgmangeVo);
            if (resultUpBMsgmangePoSe != null && reslutUpBMsgmangePoRe != null) {
                if (Integer.valueOf(resultUpBMsgmangePoSe.getOrigmsgtype()) > Integer.valueOf(reslutUpBMsgmangePoRe.getOrigmsgtype())) {
                    javaDict.set("__sendmsgtype__", (Object)reslutUpBMsgmangePoRe.getOrigmsgtype());
                } else {
                    javaDict.set("__sendmsgtype__", (Object)resultUpBMsgmangePoSe.getOrigmsgtype());
                }
            } else {
                javaDict.set("__sendmsgtype__", (Object)(msgtype + "01"));
            }
            if (("ibps.335.001.01".equals(javaDict.getString("sendmsgtype")) || "ibps.335.001.02".equals(javaDict.getString("sendmsgtype"))) && "MT03".equals(javaDict.getString("protocoloptype"))) {
                LogUtils.printInfo((Object)this, (String)"\u5bf9\u624b\u884c\u4e0d\u652f\u6301\u6b64\u67e5\u8be2\u529f\u80fd", (Object[])new Object[0]);
                return YuinResult.newFailureResult((String)"S9001", (String)"\u5bf9\u624b\u884c\u4e0d\u652f\u6301\u6b64\u67e5\u8be2\u529f\u80fd");
            }
            if ("ibps.335.001.03".equals(javaDict.getString("sendmsgtype")) && "MT03".equals(javaDict.getString("protocoloptype"))) {
                javaDict.set("authcode", (Object)"AC01");
                LogUtils.printInfo((Object)this, (String)"\u7ba1\u7406\u7c7b\u578b\u4e3a\u67e5\u8be2\u65f6\uff0c\u8ba4\u8bc1\u65b9\u5f0f\u56fa\u5b9a\u586b\u5199\uff1aAC01", (Object[])new Object[0]);
            }
            if ("UPP14051".equals(javaDict.getString("tradecode"))) {
                if ("ibps.335.001.03".equals(javaDict.getString("origrefmsgtype"))) {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.02");
                } else {
                    javaDict.set("__sendmsgtype__", (Object)"ibps.336.001.01");
                }
            }
            LogUtils.printInfo((Object)this, (String)("\u672c\u6b21\u4ea4\u6613\u652f\u6301\u62a5\u6587:" + javaDict.getString("sendmsgtype")), (Object[])new Object[0]);
            if ("UPP14051".equals(javaDict.getString("tradecode")) && "MT03".equals(javaDict.getString("protocoloptype"))) {
                if ("2".equals(javaDict.getString("effectflag"))) {
                    javaDict.set("__STEPSTATUS__", (Object)"2");
                    javaDict.set("errcode", (Object)"RJ1S");
                    javaDict.set("errmsg", (Object)"\u534f\u8bae\u5df2\u64a4\u9500");
                    LogUtils.printInfo((Object)this, (String)"\u534f\u8bae\u5df2\u8d85\u671f\u5931\u6548\uff0c\u4e0a\u4e00\u6b65\u9aa4\u4fee\u6539\u4e3a\uff1a2", (Object[])new Object[0]);
                }
                if (javaDict.hasKey("stopdate") && !"".equals(javaDict.getString("stopdate")) && Integer.valueOf(javaDict.getString("stopdate")) < Integer.valueOf(javaDict.getString("workdate"))) {
                    javaDict.set("__STEPSTATUS__", (Object)"2");
                    javaDict.set("errcode", (Object)"RJ1T");
                    javaDict.set("errmsg", (Object)"\u534f\u8bae\u5df2\u8d85\u671f\u5931\u6548");
                    LogUtils.printInfo((Object)this, (String)("\u672c\u6b21\u4ea4\u6613\u652f\u6301\u62a5\u6587" + javaDict.getString("sendmsgtype")), (Object[])new Object[0]);
                }
            }
            JavaDict javaDictcrt = new JavaDict();
            javaDictcrt.set("", (Object)("\u672c\u6b21\u4ea4\u6613\u652f\u6301\u62a5\u6587" + javaDict.getString("sendmsgtype")));
            return YuinResult.newSuccessResult((Object[])new Object[]{javaDictcrt});
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.printInfo((Object)this, (String)("\u83b7\u53d6sendmsgtype:" + e.getMessage()), (Object[])new Object[0]);
            return YuinResult.newFailureResult((String)"S9400", (String)("\u83b7\u53d6sendmsgtype\u5f02\u5e38\uff1a%s" + e.getMessage()));
        }
    }

    public YuinResult getClearBankInfo(JavaDict request, List<String> list) {
        YuinResult result = new YuinResult();
        try {
            result = this.uppBankinfoService.getBankInfoByBank(request, request.getString("bankno"), "recvbank,recvbankname,recvclearbank,recvclearbankname".split(","));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!result.success()) {
            return result;
        }
        JavaDict javaDict = (JavaDict)result.getOutputParams().get(0);
        request.set(list.get(0), (Object)javaDict.getString(list.get(0)));
        request.set(list.get(1), (Object)javaDict.getString(list.get(1)));
        request.set(list.get(2), (Object)javaDict.getString(list.get(2)));
        request.set(list.get(3), (Object)javaDict.getString(list.get(3)));
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHeadMsg(JavaDict javaDict, List<String> listInParam, String javaDictMap) {
        try {
            String strClearBank = "";
            if (listInParam.size() != 2) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u8be5\u51fd\u6570\u5165\u53c2\u4e2a\u6570\u4e3a2\u4e2a");
            }
            if ("UPP99007".equals(javaDict.getString("tradecode"))) {
                strClearBank = listInParam.get(1).startsWith("#") ? listInParam.get(1).substring(1) : javaDict.getString(listInParam.get(1));
                javaDict.set(javaDictMap, (Object)strClearBank);
            }
            if (!javaDict.hasKey(listInParam.get(0))) {
                strClearBank = listInParam.get(1).startsWith("#") ? listInParam.get(1).substring(1) : javaDict.getString(listInParam.get(1));
                javaDict.set(javaDictMap, (Object)strClearBank);
            } else {
                javaDict.set(javaDictMap, (Object)javaDict.getString(listInParam.get(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getBanknoByBrno(JavaDict javaDict, List<String> listInParam, List<String> outParam) {
        UpPBankmapQueryVo upPBankmapQueryVo = null;
        try {
            upPBankmapQueryVo = new UpPBankmapQueryVo();
            upPBankmapQueryVo.setSysid(javaDict.getString(listInParam.get(0)));
            upPBankmapQueryVo.setAppid(javaDict.getString(listInParam.get(1)));
            upPBankmapQueryVo.setBrno(javaDict.getString(listInParam.get(2)));
            UpPBankmapPo upPBankmapPo = this.upPBankmapRepo.selectById(upPBankmapQueryVo);
            if (upPBankmapPo == null) {
                return YuinResult.newFailureResult((String)"", (String)"\u83b7\u53d6\u652f\u4ed8\u884c\u53f7\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!"1".equals(upPBankmapPo.getStatus())) {
                return YuinResult.newFailureResult((String)"O3048", (String)"\u7f51\u70b9\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            if (outParam == null) {
                return YuinResult.newSuccessResult((Object[])new Object[]{upPBankmapPo.getCorpbankno()});
            }
            javaDict.set(outParam.get(0), (Object)upPBankmapPo.getCorpbankno());
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newSuccessResult(null);
        }
    }

    public YuinResult getBankBrno(JavaDict javaDict, List<String> listInParam, List<String> outParam) {
        UpPBankmapQueryVo upPBankmapQueryVo = null;
        try {
            upPBankmapQueryVo = new UpPBankmapQueryVo();
            upPBankmapQueryVo.setSysid(javaDict.getString(listInParam.get(0)));
            upPBankmapQueryVo.setCorpbankno(javaDict.getString(listInParam.get(1)));
            UpPBankmapPo upPBankmapPo = this.upPBankmapRepo.selectById(upPBankmapQueryVo);
            if (upPBankmapPo == null) {
                return YuinResult.newFailureResult((String)"", (String)"\u83b7\u53d6\u652f\u4ed8\u884c\u53f7\u6620\u5c04\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!"1".equals(upPBankmapPo.getStatus())) {
                return YuinResult.newFailureResult((String)"O3048", (String)"\u7f51\u70b9\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            if (outParam == null) {
                return YuinResult.newSuccessResult((Object[])new Object[]{upPBankmapPo.getBrno()});
            }
            javaDict.set(outParam.get(0), (Object)upPBankmapPo.getBrno());
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newSuccessResult(null);
        }
    }

    public YuinResult getCrtMsgBLOB(JavaDict javaDict, String listInPara, String listOutPara) {
        String[] listInParaArry = listInPara.split(",");
        String listOutParaValue = "";
        for (String param : listInParaArry) {
            if (param.split(":").length < 2) {
                return YuinResult.newFailureResult((String)"E3101", (String)PayErrorCode.getErrmsg((String)"E3101"));
            }
            if (!javaDict.hasKey(param.split(":")[0])) continue;
            listOutParaValue = StringUtils.isBlank((CharSequence)listOutParaValue) ? param.split(":")[1] + ":" + javaDict.getString(param.split(":")[0]) : listOutParaValue + "," + param.split(":")[1] + ":" + javaDict.getString(param.split(":")[0]);
        }
        javaDict.set(listOutPara, (Object)listOutParaValue);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getBankBrnoInfo(JavaDict javaDict, List<String> listInParam) {
        YuinResult result = new YuinResult();
        try {
            UpPBankmapQueryVo data;
            String bankNo;
            String sysId;
            if (listInParam.size() != 3) {
                return YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsgAdd((String)"S9001", (String)"\u5165\u53c2\u4e2a\u6570\u4e0d\u5408\u6cd5"));
            }
            String appId = javaDict.getString(listInParam.get(0));
            result = this.upPBankmapRepo.getBankStatus(appId, sysId = javaDict.getString(listInParam.get(1)), bankNo = javaDict.getString(listInParam.get(2)));
            if (result.success()) {
                if (CollectionUtils.isEmpty((Collection)result.getOutputParams())) {
                    return YuinResult.newFailureResult((String)"E1003", (String)PayErrorCode.getErrmsg((String)"E1003"));
                }
                data = (UpPBankmapQueryVo)result.getOutputParams().get(0);
                if (!"1".equals(data.getStatus())) {
                    return YuinResult.newFailureResult((String)"E1105", (String)PayErrorCode.getErrmsg((String)"E1105"));
                }
            } else {
                return YuinResult.newFailureResult((String)"O6046", (String)PayErrorCode.getErrmsg((String)"O6046"));
            }
            javaDict.set("brno", (Object)data.getBrno());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    @Transactional
    public YuinResult getOrigBrno(JavaDict request, String key) {
        YuinResult result = new YuinResult();
        try {
            UpMTranjnlVo upMTranjnlVo = new UpMTranjnlVo();
            upMTranjnlVo.setAppid(request.getString("appid"));
            upMTranjnlVo.setSysid(request.getString("sysid"));
            UpMTranjnlVo updateVo = new UpMTranjnlVo();
            updateVo.setTradebusistep("24");
            if ("HVPS".equals(request.getString("sysid")) && "01105".equals(request.getString("extbusitype"))) {
                if ("2".equals(request.getString("sysflag"))) {
                    upMTranjnlVo.setMsgid(request.getString("origmsgid"));
                    upMTranjnlVo.setMsgtype(request.getString("origmsgtype"));
                    upMTranjnlVo.setSendbank(request.getString("origsendbank"));
                } else {
                    upMTranjnlVo.setBusidate("origbusidate");
                    upMTranjnlVo.setMsgid(request.getString("origmsgid"));
                    upMTranjnlVo.setSendbank(request.getString("payeebank"));
                }
                UpMTranjnlVo operBrnoVo = this.upMTranjnlRepo.getOperBrnoInfo(upMTranjnlVo);
                if (operBrnoVo != null) {
                    updateVo.setWorkdate(operBrnoVo.getWorkdate());
                    updateVo.setWorkseqid(operBrnoVo.getWorkseqid());
                    this.upMTranjnlRepo.updateTradeBusiStep(updateVo);
                    if (StringUtils.isBlank((CharSequence)key)) {
                        request.set(key, (Object)operBrnoVo.getOperbrno());
                    }
                }
            } else if ("BEPS".equals(request.getString("sysid")) && "01105".equals(request.getString("extbusitype"))) {
                if ("2".equals(request.getString("sysflag"))) {
                    upMTranjnlVo.setMsgid(request.getString("origmsgid"));
                    upMTranjnlVo.setDetailno("origdetailno");
                    upMTranjnlVo.setMsgtype(request.getString("origmsgtype"));
                    upMTranjnlVo.setSendclearbank("recvclearbank");
                } else {
                    upMTranjnlVo.setBusidate("origbusidate");
                    upMTranjnlVo.setDetailno("origdetailno");
                    upMTranjnlVo.setPayeeaccno(request.getString("payeraccno"));
                    String amt = request.getString("amt");
                    BigDecimal formatAmt = new BigDecimal(amt);
                    upMTranjnlVo.setAmt(formatAmt);
                    upMTranjnlVo.setSendclearbank(request.getString("recvclearbank"));
                }
                UpMTranjnlVo operBrnoVo = this.upMTranjnlRepo.getOperBrnoInfo(upMTranjnlVo);
                updateVo.setWorkdate(operBrnoVo.getWorkdate());
                updateVo.setWorkseqid(operBrnoVo.getWorkseqid());
                this.upMTranjnlRepo.updateTradeBusiStep(updateVo);
                if (operBrnoVo != null && StringUtils.isBlank((CharSequence)key)) {
                    request.set(key, (Object)operBrnoVo.getOperbrno());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getOneBusiMap(JavaDict javaDict) {
        if ("BEPS".equals(javaDict.getString("appid")) && "1".equals(javaDict.getString("sysflag")) && "A105".equals(javaDict.getString("busitype"))) {
            javaDict.set("busitype", (Object)"00108");
            javaDict.set("mainclass", (Object)"00108");
            if ("02108".equals(javaDict.getString("busikind"))) {
                javaDict.remove("busikind");
            }
        }
        if ("HVPS".equals(javaDict.getString("appid")) && "1".equals(javaDict.getString("sysflag")) && "A105".equals(javaDict.getString("busitype"))) {
            javaDict.set("busitype", (Object)"CMT108");
            javaDict.set("mainclass", (Object)"CMT108");
            if ("02108".equals(javaDict.getString("busikind"))) {
                javaDict.remove("busikind");
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public String getHeadMsg(JavaDict request, List<String> inParam) {
        String clearBank = "";
        try {
            if ("BUP99007".equals(request.getString("tradecode"))) {
                clearBank = inParam.get(1).startsWith("#") ? inParam.get(1).substring(1) : request.getString(inParam.get(1));
                return clearBank;
            }
            if (!request.hasKey(inParam.get(0))) {
                clearBank = inParam.get(1).startsWith("#") ? inParam.get(1).substring(1) : request.getString(inParam.get(1));
                return clearBank;
            }
            clearBank = request.getString(inParam.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clearBank;
    }

    public YuinResult getProdCode(JavaDict request) {
        Object result = null;
        try {
            String code = ProdCodeEnum.validAppIdExists(request.getString("appid"));
            if (StringUtils.isEmpty((CharSequence)code)) {
                YuinResult.newFailureResult((String)"S9002", (String)"\u5e94\u7528\u6807\u8bc6\u914d\u7f6e\u9519\u8bef\uff01");
            }
            request.set("prodcode", (Object)code);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u5bf9\u8d26\u4ea7\u54c1\u7801\u83b7\u53d6\u5f02\u5e38");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCheckDate(JavaDict request) {
        Object result = null;
        try {
            String checkDate = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            if (!request.hasKey("chkdate")) {
                request.set("chkdate", (Object)checkDate);
            }
            request.set("startcleardate", (Object)request.getString("chkdate"));
            request.set("endcleardate", (Object)request.getString("chkdate"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u83b7\u53d6\u5bf9\u8d26\u65e5\u671f\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTranAddAndMap(JavaDict request, JavaDict mapDict, String selKey, String mapKey) {
        YuinResult result = null;
        try {
            if (StringUtils.isEmpty((CharSequence)selKey)) {
                return YuinResult.newFailureResult((String)"E9010", (String)ErrorCode.getErrmsg((String)"E9010"));
            }
            YuinResultDto selMainResult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), selKey);
            if (!selMainResult.isSuccess()) {
                return YuinResult.newFailureResult((String)selMainResult.getHead().getResponseCode(), (String)selMainResult.getHead().getResponseMsg());
            }
            List origMainList = (List)selMainResult.getBody();
            if (CollectionUtil.isEmpty((Collection)origMainList)) {
                return YuinResult.newFailureResult((String)"E1412", (String)ErrorCode.getErrmsg((String)"E1412"));
            }
            Map origInfo = (Map)origMainList.get(0);
            String dictInfo = String.format("sysid,appid,#getTranjnlAddInfo,#S,#tranjnlAddInfo,#%s", origInfo.get("msgtype"));
            result = this.upPDictService.getDictValue2ByKey(request, dictInfo);
            if (!result.success()) {
                return result;
            }
            String actionKey = (String)result.getOutputParams().get(0);
            YuinResultDto selAddResult = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), actionKey);
            if (!selAddResult.isSuccess()) {
                return YuinResult.newFailureResult((String)selAddResult.getHead().getResponseCode(), (String)selAddResult.getHead().getResponseMsg());
            }
            List origAddList = (List)selAddResult.getBody();
            if (CollectionUtil.isEmpty((Collection)origAddList)) {
                return YuinResult.newFailureResult((String)"E1412", (String)ErrorCode.getErrmsg((String)"E1412"));
            }
            Map addInfo = (Map)origAddList.get(0);
            if (!StringUtils.isEmpty((CharSequence)mapKey)) {
                mapDict.setMap(addInfo);
                YuinResultDto mapResult = this.tradeOperDbService.operDbaction(mapDict, request.getString("sysid"), request.getString("appid"), mapKey);
                if (!mapResult.isSuccess()) {
                    return YuinResult.newFailureResult((String)mapResult.getHead().getResponseCode(), (String)mapResult.getHead().getResponseMsg());
                }
                request.setMap((Map)mapResult.getBody());
            } else {
                request.setMap(addInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"O6049", (String)"\u539f\u4e1a\u52a1\u83b7\u53d6\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }
}

