/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.pub;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UPPDateService {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat hms = new SimpleDateFormat("HH:mm:ss");

    public static String dateAddAndSub(String date, Integer day) {
        String result = null;
        try {
            Date parse = dateFormat.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(5, day);
            Date time = calendar.getTime();
            result = dateFormat.format(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Integer getDaysDifference(String startDate, String endDate) {
        Integer result = 0;
        try {
            Date start = dateFormat.parse(startDate);
            Date end = dateFormat.parse(endDate);
            long startTime = start.getTime();
            long endTime = end.getTime();
            long num = endTime - startTime;
            result = Math.toIntExact(num / 24L / 60L / 60L / 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        now.setTime(nowTime);
        Calendar start = Calendar.getInstance();
        start.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return now.after(start) && now.before(end);
    }

    public static Boolean cutoffTimeJudge(Date date, String cutoffStart, String cutoffEnd) {
        try {
            String format = hms.format(date);
            Date now = hms.parse(format);
            Date start = hms.parse(cutoffStart);
            Date end = hms.parse(cutoffEnd);
            if (!UPPDateService.isEffectiveDate(now, start, end).booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public YuinResult dateFormat(JavaDict javaDict, List<String> list, String resultDate) {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u8be5\u51fd\u6570\u5165\u53c2\u4e2a\u6570\u81f3\u5c11\u4e3a1\u4e2a");
            }
            String[] ex = list.get(0).split("\\+");
            String strOrigDate = javaDict.getString(ex[0].trim());
            if (ex.length > 1) {
                strOrigDate = strOrigDate + javaDict.getString(ex[1].trim());
            }
            String strFormat = list.size() == 2 ? "yyyy-MM-ddTHH:mm:ss" : "yyyyMMdd";
            String fmtDate = StringUtils.leftPad((String)strOrigDate.replaceAll("\\d", ""), (int)14, (String)"0");
            Date fmtList = DateUtils.parseDate((String)fmtDate, (String)"yyyy-MM-dd HH:mm:ss");
            String strNewDate = strFormat.replaceAll("yyyy", StringUtils.leftPad((String)String.valueOf(DateUtils.getYear((Date)fmtList)), (int)4, (String)"0")).replaceAll("MM", StringUtils.leftPad((String)String.valueOf(DateUtils.getMonth((Date)fmtList)), (int)2, (String)"0")).replaceAll("dd", StringUtils.leftPad((String)String.valueOf(DateUtils.getMonthDay((Date)fmtList)), (int)2, (String)"0")).replaceAll("HH", StringUtils.leftPad((String)String.valueOf(DateUtils.getDayHour((Date)fmtList)), (int)2, (String)"0")).replaceAll("mm", StringUtils.leftPad((String)String.valueOf(DateUtils.getMinute((Date)fmtList)), (int)2, (String)"0")).replaceAll("ss", StringUtils.leftPad((String)String.valueOf(DateUtils.getSecond((Date)fmtList)), (int)2, (String)"0"));
            javaDict.set(resultDate, (Object)strNewDate);
            return YuinResult.newSuccessResult(null);
        }
        catch (Exception e) {
            LogUtils.printError((Object)this, (String)"\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38:{}", (Object[])new Object[]{e.getMessage()});
            return YuinResult.newFailureResult((String)"E230604", (String)"\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38");
        }
    }
}

