/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.pub;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.enumeration.ProdCodeEnum;
import cn.com.yusys.yusp.pay.common.base.dto.UpPSeqParam;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.base.util.SequenceUtil;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.TradeInitService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPPCrtService {
    @Resource
    private SequenceUtil sequenceUtil;
    @Autowired
    private TradeInitService tradeInitService;

    public static <T> T[] convertArray(Class<T> targetType, Object[] arrayObjects) {
        if (targetType == null) {
            return arrayObjects;
        }
        if (arrayObjects == null) {
            return null;
        }
        Object[] targetArray = (Object[])Array.newInstance(targetType, arrayObjects.length);
        try {
            System.arraycopy(arrayObjects, 0, targetArray, 0, arrayObjects.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetArray;
    }

    public YuinResult crtPayBLOB(JavaDict dictReq, List<String> listInPara, List<String> listOutPara) {
        String result = "";
        try {
            for (String item : listInPara) {
                if (item.startsWith("PICK_") && dictReq.hasKey(item.substring(5))) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    String byteStr = dictReq.get(item.substring(5)).toString();
                    byte[] bytes = byteStr.getBytes(StandardCharsets.UTF_8);
                    oos.write(bytes);
                    String strPick = bos.toString();
                    String tranStr = "," + item + "," + strPick.length() + "," + strPick;
                    result = result + tranStr;
                    continue;
                }
                if (!dictReq.hasKey(item)) continue;
                String strPick = String.valueOf(dictReq.get(item));
                result = result + "," + item + "," + strPick.length() + "," + strPick;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty(listOutPara)) {
            Object[] yuinResult = new Object[]{};
            if (StringUtils.isNotEmpty((String)result)) {
                yuinResult = new Object[]{result.substring(1)};
            }
            return YuinResult.newSuccessResult((Object[])yuinResult);
        }
        if (StringUtils.isEmpty((String)result)) {
            dictReq.set(listOutPara.get(0), (Object)result);
        } else {
            dictReq.set(listOutPara.get(0), (Object)result.substring(1));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult crtPayAnzBLOB(JavaDict dictReq, String reqstoppayinfo) {
        int intLen = reqstoppayinfo.length();
        int intLac = 0;
        int intPos = 0;
        String strValue = null;
        if (intPos < intLen) {
            int intValueLen;
            String[] split = reqstoppayinfo.split(",");
            String s = split[0];
            if (s.length() < 0) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u6574\u5408\u5b57\u6bb5\u683c\u5f0f\u975e\u6cd5\u4e0d\u652f\u6301\u89e3\u6790");
            }
            String strKey = reqstoppayinfo.substring(intPos, intPos + intLac);
            intPos += intLac + 1;
            split = reqstoppayinfo.split(",");
            s = split[0];
            if (s.length() < 0) {
                return YuinResult.newFailureResult((String)"S9001", (String)"\u6574\u5408\u5b57\u6bb5\u683c\u5f0f\u975e\u6cd5\u4e0d\u652f\u6301\u89e3\u6790");
            }
            if ((intPos += intLac + 1) + (intValueLen = reqstoppayinfo.substring(intPos, intPos + intLac).length()) > intLen) {
                strValue = reqstoppayinfo.substring(intPos, intPos + intValueLen);
                intPos += intLac + 1;
                return YuinResult.newFailureResult((String)"S9001", (String)"\u6574\u5408\u5b57\u6bb5\u683c\u5f0f\u975e\u6cd5\u4e0d\u652f\u6301\u89e3\u6790");
            }
            if (strKey.startsWith("PICK_")) {
                String substring = strKey.substring(5);
                dictReq.set(substring, (Object)strValue);
                LogUtils.printInfo((Object)this, (String)"{KEY:}|{VALUES:}", (Object[])new Object[]{substring, dictReq.getString(substring)});
            } else {
                dictReq.set(strKey, (Object)strValue);
                LogUtils.printInfo((Object)this, (String)"{KEY:}|{VALUES:}", (Object[])new Object[]{strKey, strValue});
            }
            return YuinResult.newSuccessResult(null);
        }
        return YuinResult.newFailureResult((String)"S9400", (String)"\u5b57\u6bb5\u8f6c\u6362\u5bb9\u5668\u7ec4\u4ef6\u5f02\u5e38");
    }

    public void crtIBPSMsgId(JavaDict javaDict, String bankno, String busidate) {
        String msgid = this.tradeInitService.getSeqMsgid(javaDict.getString("appid"), busidate, bankno, null);
        LogUtils.printInfo((Object)this, (String)"{}|[{}]", (Object[])new Object[]{"crtmsgid", msgid});
        javaDict.set("crtmsgid", (Object)msgid);
    }

    public void crtProtocolId(JavaDict javaDict, String busidate, String protocolno) {
        String strprotoSqu = String.format("%s%s", busidate, this.tradeInitService.getSequence("msgid", "8"));
        LogUtils.printInfo((Object)this, (String)"{}|[{}]", (Object[])new Object[]{"protocolno", strprotoSqu});
        javaDict.set(protocolno, (Object)strprotoSqu);
    }

    public YuinResult crtIBPSUrl(JavaDict javaDict, List<String> listInparam) {
        try {
            String strParaBaseTemp;
            String strMsgtype = javaDict.getString("msgtype");
            String strPreUrl = listInparam.get(0).startsWith("#") ? listInparam.get(0).substring(1) : javaDict.getString(listInparam.get(0));
            String strPinUrl = null;
            String strParaBase64 = null;
            String strUrl = null;
            if (javaDict.hasKey("__prodcode__") && "PROD_NR14051_IBPS".equals(javaDict.getString("__prodcode__")) || javaDict.hasKey("__prodcode__") && "prod_bup14_61_01".equals(javaDict.getString("__prodcode__")) || javaDict.hasKey("__prodcode__") && "prod_bup06_51_3".equals(javaDict.getString("__prodcode__")) || javaDict.hasKey("__prodcode__") && "prod_bup14_51_02".equals(javaDict.getString("__prodcode__")) || javaDict.hasKey("__prodcode__") && "prod_bup14_61_02".equals(javaDict.getString("__prodcode__")) || javaDict.hasKey("__prodcode__") && "prod_bup14_51_03".equals(javaDict.getString("__prodcode__"))) {
                if (javaDict.hasKey("acclmdtype") && "TL03".equals(javaDict.getString("acclmdtype"))) {
                    if (javaDict.hasKey("corporbankUrl")) {
                        strPinUrl = javaDict.getString("corporbankUrl") + "/ibps.do?";
                    }
                } else if (javaDict.hasKey("perbankUrl")) {
                    strPinUrl = javaDict.getString("perbankUrl") + "/ibps.do?";
                }
            }
            if ("ibps.105.001.01".equals(strMsgtype)) {
                String strPara = listInparam.get(1).startsWith("#") ? listInparam.get(1).substring(1) : javaDict.getString(listInparam.get(1));
                String tranId = listInparam.get(2).startsWith("#") ? listInparam.get(2).substring(1) : javaDict.getString(listInparam.get(2));
                String olnTranSeqNb = listInparam.get(3).startsWith("#") ? listInparam.get(3).substring(1) : javaDict.getString(listInparam.get(3));
                String tranAmt = listInparam.get(4).startsWith("#") ? listInparam.get(4).substring(1) : javaDict.getString(listInparam.get(4));
                String merchtCd = listInparam.get(5).startsWith("#") ? listInparam.get(5).substring(1) : javaDict.getString(listInparam.get(5));
                String merchtNm = listInparam.get(6).startsWith("#") ? listInparam.get(6).substring(1) : javaDict.getString(listInparam.get(6));
                strParaBaseTemp = strPara + "&amp;TranId=" + tranId + "&amp;OlnTranSeqNb=" + olnTranSeqNb + "&amp;TranAmt=" + tranAmt + "&amp;MerchtCd=" + merchtCd + "&amp;MerchtNm=" + merchtNm;
            } else {
                String strPara = listInparam.get(1).startsWith("#") ? listInparam.get(1).substring(1) : javaDict.getString(listInparam.get(1));
                String strOrigMsgId = listInparam.get(2).startsWith("#") ? listInparam.get(2).substring(1) : javaDict.getString(listInparam.get(2));
                strParaBaseTemp = strPara + strOrigMsgId;
            }
            LogUtils.printInfo((Object)this, (String)"base64\u52a0\u5bc6\u524d\uff1a{}", (Object[])new Object[]{strParaBaseTemp});
            strParaBase64 = new String(Base64.getEncoder().encode(strParaBaseTemp.getBytes(StandardCharsets.UTF_8)));
            strUrl = String.format("%s%s%s", strPreUrl, strPinUrl, strParaBase64);
            LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u7684\u5230URL\u4e3a\uff1a{}", (Object[])new Object[]{strUrl});
            return YuinResult.newSuccessResult((Object[])new Object[]{strUrl});
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u7f51\u94f6URL\u5f02\u5e38\uff1a{}", (Object[])new Object[]{e.getMessage()});
            return YuinResult.newFailureResult((String)"S9400", (String)String.format("\u83b7\u53d6\u7f51\u94f6URL\u5f02\u5e38\uff1a%s", e.getMessage()));
        }
    }

    public YuinResult crtBepsMsgId(JavaDict request, List<String> listParam) {
        Object result = null;
        String sequenceNo = this.crtSequenceNo("bepmsgseqid", "8", '0');
        if (StringUtils.isEmpty((String)sequenceNo)) {
            YuinResult.newFailureResult((String)"E0103", (String)PayErrorCode.getErrmsg((String)"E0103"));
        }
        try {
            String sysId;
            String string = sysId = listParam.get(0).startsWith("#") ? listParam.get(0).substring(1) : request.getString(listParam.get(0));
            if ("1".equals(sysId)) {
                request.set("bepmsgseqid", (Object)sequenceNo);
            } else {
                if (listParam.size() < 2) {
                    YuinResult.newFailureResult((String)"S9001", (String)PayErrorCode.getErrmsg((String)"\u5165\u53c2\u4e2a\u6570\u4e0d\u8db3"));
                }
                String workDate = request.getString(listParam.get(0));
                request.set("bepmsgseqid", (Object)(workDate + sequenceNo));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult((Object[])new Object[0]);
    }

    public String crtSequenceNo(String key, String length, char fillInfo) {
        String result = "";
        try {
            UpPSeqParam upPSeqParam = new UpPSeqParam();
            upPSeqParam.setSeqid(key);
            upPSeqParam.setSeqlen(length);
            upPSeqParam.setFillString(fillInfo);
            result = this.sequenceUtil.getSequence(upPSeqParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public YuinResult crtAccountFileName(JavaDict request) {
        Object result = null;
        try {
            String prefix = ProdCodeEnum.getFilePrefix(request.getString("appid"));
            if (StringUtils.isEmpty((String)prefix)) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u5e94\u7528\u6807\u8bc6\u914d\u7f6e\u9519\u8bef\uff01");
            }
            if (!(request.hasKey("chkdate") && request.hasKey("prodcode") && request.hasKey("chkdate"))) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u83b7\u53d6\u5bf9\u8d26\u540d\u79f0\u5fc5\u8981\u53c2\u6570\u9519\u8bef\uff01");
            }
            String suffix = String.format("%s_%s_%s_SUM|Plat_%s_%s_%s_SUM|Plat_%s_%s_%s_DTL", request.getString("prodcode"), request.getString("chktype"), request.getString("chkdate"), request.getString("prodcode"), request.getString("chktype"), request.getString("chkdate"), request.getString("prodcode"), request.getString("chktype"), request.getString("chkdate"));
            String fileName = String.format("%s_%s", prefix, suffix);
            request.set("filename", (Object)fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u751f\u6210\u5bf9\u8d26\u540d\u79f0\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult crtChkDetailName(JavaDict request) {
        Object result = null;
        try {
            String prefix = ProdCodeEnum.getFilePrefix(request.getString("appid"));
            if (StringUtils.isEmpty((String)prefix)) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u5e94\u7528\u6807\u8bc6\u914d\u7f6e\u9519\u8bef\uff01");
            }
            if (!(request.hasKey("chkdate") && request.hasKey("prodcode") && request.hasKey("chkdate"))) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u83b7\u53d6\u5bf9\u8d26\u540d\u79f0\u5fc5\u8981\u53c2\u6570\u9519\u8bef\uff01");
            }
            String suffix = String.format("%s_%s_%s_DTL", request.getString("prodcode"), request.getString("chktype"), request.getString("chkdate"));
            String fileName = String.format("%s_%s", prefix, suffix);
            request.set("filename", (Object)fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9003", (String)"\u751f\u6210\u5bf9\u8d26\u540d\u79f0\u5f02\u5e38\uff01");
        }
        return YuinResult.newSuccessResult(null);
    }
}

