/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.domain.service.pub;

import cn.com.yusys.yusp.pay.base.sign.client.dto.ProtoQueryReqDto;
import cn.com.yusys.yusp.pay.base.sign.client.inter.PaySignClient;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.data.UpDBusimaxamtService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BepsChkService {
    @Autowired
    UpPBankinfoService upPBankinfoService;
    @Autowired
    UpDBusimaxamtService upDBusimaxamtService;
    @Autowired
    UPPGetService uppGetService;
    @Resource
    private PaySignClient paySignClient;
    @Autowired
    private TradeOperDbService tradeOperDbService;

    public YuinResult chkBepsAmtAuth(JavaDict request) {
        try {
            YuinResult resultsend = this.upPBankinfoService.getBankInfoByBank(request, request.getString("sendclearbank"));
            if (!resultsend.success()) {
                return resultsend;
            }
            String sendcatalog = ((JavaDict)resultsend.getOutputParams().get(0)).getString("bankcatalog");
            YuinResult resultrecv = this.upPBankinfoService.getBankInfoByBank(request, request.getString("recvclearbank"));
            if (!resultrecv.success()) {
                return resultrecv;
            }
            String recvcatalog = ((JavaDict)resultrecv.getOutputParams().get(0)).getString("bankcatalog");
            return this.upDBusimaxamtService.chkBepsAmtAuth(request, sendcatalog, recvcatalog, request.getBigDecimal("amt"));
        }
        catch (Exception e) {
            return YuinResult.newFailureResult((String)"S9002", (String)String.format("\u5c0f\u989d\u7cfb\u7edf\u4ea4\u6613\u91d1\u989d\u4e0a\u9650\u6821\u9a8c\u5f02\u5e38: %s", e.getMessage()));
        }
    }

    public YuinResult chkBepsSysStatus(JavaDict javaDict) {
        if (!"BEPS".equals(javaDict.getString("appid"))) {
            YuinResult.newFailureResult((String)"E0199", (String)PayErrorCode.getErrmsgAdd((String)"E0199", (String)"\u5f53\u524d\u975e\u5c0f\u989d\u7cfb\u7edf"));
        }
        if (!"1".equals(javaDict.getString("__sysstatus__")) || !"ST02".equals(javaDict.getString("__corpstatus__"))) {
            YuinResult.newFailureResult((String)"E0103", (String)PayErrorCode.getErrmsgAdd((String)"E0103", (String)"\u5f53\u524d\u5c0f\u989d\u7cfb\u7edf\u975e\u65e5\u95f4\u72b6\u6001"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult chkDJTreaty(JavaDict javaDict) {
        String protocolno = javaDict.getString("protocolno");
        JavaDict cirDict = new JavaDict();
        if (!"UPP15012".equals(javaDict.getString("tradecode")) && !"UPP15013".equals(javaDict.getString("tradecode"))) {
            if (javaDict.hasKey("protocolno") && "000000000000000000000000000000000000000000000000000000000000".equals(javaDict.getString("protocolno")) || javaDict.hasKey("corpchkflag") && "1".equals(javaDict.getString("corpchkflag")) || "CE01".equals(javaDict.getString("checkflag"))) {
                cirDict.set("confirmflag", (Object)"1");
                cirDict.set("addinfo", (Object)"\u540c\u610f\u4ed8\u6b3e");
            } else {
                ProtoQueryReqDto protoQueryReqDto = new ProtoQueryReqDto();
                protoQueryReqDto.setSysid("UPP");
                protoQueryReqDto.setAppid("BEPS");
                protoQueryReqDto.setProtono(protocolno);
                try {
                    Map map;
                    YuinResultDto resultDto = this.paySignClient.protoQuery(protoQueryReqDto);
                    boolean refuseFlag = true;
                    if (resultDto.getBody() != null && "1".equals((map = (Map)resultDto.getBody()).get("protostatus"))) {
                        refuseFlag = false;
                    }
                    if (refuseFlag) {
                        cirDict.set("confirmflag", (Object)"0");
                        if (javaDict.hasKey("sysflag") && "1".equals(javaDict.get("sysflag"))) {
                            cirDict.set("rejectcode", (Object)"90");
                        } else {
                            cirDict.set("rejectcode", (Object)"RJ06");
                            cirDict.set("rejectreason", (Object)"\u534f\u8bae\u53f7\u4e0d\u5b58\u5728");
                            cirDict.set("addinfo", (Object)"\u62d2\u7edd\u4ed8\u6b3e");
                        }
                        return YuinResult.newFailureResult((String)"E1802", (String)PayErrorCode.getErrmsg((String)"E1802"));
                    }
                    cirDict.set("confirmflag", (Object)"1");
                    cirDict.set("addinfo", (Object)"\u540c\u610f\u4ed8\u6b3e");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            cirDict.set("confirmflag", (Object)"1");
            cirDict.set("addinfo", (Object)"\u540c\u610f\u4ed8\u6b3e");
        }
        cirDict.set("origbusidate", (Object)javaDict.get("busidate").toString());
        cirDict.set("origmsgid", (Object)javaDict.get("msgid").toString());
        cirDict.set("origdetailno", (Object)javaDict.get("detailno").toString());
        cirDict.set("origsendbank", (Object)javaDict.get("sendbank").toString());
        javaDict.setMap(cirDict.get());
        return YuinResult.newSuccessResult((Object[])new Object[]{cirDict});
    }

    public YuinResult chkDSFProtocol(JavaDict javaDict) {
        String protocolno = javaDict.get("protocolno", (Object)"").toString();
        String checkflag = javaDict.get("checkflag", (Object)"").toString();
        String payerchgflag = javaDict.get("payerchgflag", (Object)"").toString();
        if ("UPP15001".equals(javaDict.get("tradecode")) || "UPP15007".equals(javaDict.get("tradecode"))) {
            JavaDict cirDict = new JavaDict();
            cirDict.set("confirmflag", (Object)"1");
            cirDict.set("addinfo", (Object)"\u540c\u610f\u4ed8\u6b3e");
            if ("CE02".equals(checkflag)) {
                cirDict.set("confirmflag", (Object)"0");
                cirDict.set("rejectcode", (Object)"RJ06");
                cirDict.set("rejectreason", (Object)"\u4e0d\u652f\u6301\u672a\u6838\u9a8c\u6838\u9a8c\u6807\u8bc6");
                cirDict.set("addinfo", (Object)"\u62d2\u7edd\u4ed8\u6b3e");
            } else {
                cirDict.set("confirmflag", (Object)"1");
                cirDict.set("addinfo", (Object)"\u540c\u610f\u4ed8\u6b3e");
            }
            cirDict.set("busitype", (Object)javaDict.get("busitype").toString());
            cirDict.set("busikind", (Object)javaDict.get("busikind").toString());
            cirDict.set("amt", (Object)javaDict.get("amt").toString());
            cirDict.set("origbusidate", (Object)javaDict.get("busidate").toString());
            cirDict.set("origmsgid", (Object)javaDict.get("msgid").toString());
            cirDict.set("origdetailno", (Object)javaDict.get("detailno").toString());
            cirDict.set("origsendbank", (Object)javaDict.get("sendbank").toString());
            return YuinResult.newSuccessResult((Object[])new Object[]{cirDict});
        }
        if ("CE02".equals(checkflag)) {
            javaDict.set("confirmflag", (Object)"0");
            javaDict.set("rejectcode", (Object)"RJ06");
            javaDict.set("rejectreason", (Object)"\u4e0d\u652f\u6301\u672a\u6838\u9a8c\u6838\u9a8c\u6807\u8bc6");
            javaDict.set("addinfo", (Object)"\u62d2\u7edd\u4ed8\u6b3e");
            return YuinResult.newFailureResult((String)"E1809", (String)PayErrorCode.getErrmsg((String)"E1809"));
        }
        if ("UPP15012".equals(javaDict.get("tradecode")) && "beps.382.001.02".equals(javaDict.get("msgtype"))) {
            if ("AG01".equals(payerchgflag)) {
                try {
                    YuinResultDto selresult = this.tradeOperDbService.operDbaction(javaDict, javaDict.getString("sysid"), javaDict.getString("appid"), "sel_btchpmtjnl");
                    if (!selresult.isSuccess()) {
                        return YuinResult.newFailureResult((String)selresult.getHead().getResponseCode(), (String)selresult.getHead().getResponseMsg());
                    }
                    List list = (List)selresult.getBody();
                    if (list.size() > 0) {
                        if ("AG01".equals(payerchgflag)) {
                            javaDict.set("__acctscne__", (Object)javaDict.get("__acctscne1__").toString());
                            javaDict.set("__INSBIZDETAIL__", (Object)"biz_ins_bupmtranjnl_15011_1");
                            javaDict.set("tradebusistep", (Object)"64");
                            javaDict.set("ootpdt", ((Map)list.get(0)).get("bankdate"));
                            javaDict.set("ootpsq", ((Map)list.get(0)).get("bankseqno"));
                            javaDict.set("circletotalamt", ((Map)list.get(0)).get("amt"));
                            javaDict.set("circlestatus", ((Map)list.get(0)).get("circlestatus"));
                            javaDict.set("circleno", ((Map)list.get(0)).get("circleno"));
                        }
                        return YuinResult.newSuccessResult(null);
                    }
                    YuinResult.newFailureResult((String)"E1802", (String)PayErrorCode.getErrmsg((String)"E1802"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)"\u67e5\u8be2\u5708\u5b58\u6570\u636e\u5f02\u5e38");
                }
            }
            if ("UPP15021".equals(javaDict.get("tradecode")) && "beps.384.001.02".equals(javaDict.get("origmsgtype"))) {
                return this.chkBUPProtocol(javaDict);
            }
            if ("UPP15021".equals(javaDict.get("tradecode")) && "beps.384.001.02".equals(javaDict.get("msgtype")) && "CE02".equals(checkflag)) {
                ProtoQueryReqDto protoQueryReqDto = new ProtoQueryReqDto();
                protoQueryReqDto.setSysid("UPP");
                protoQueryReqDto.setAppid("BEPS");
                protoQueryReqDto.setProtono(protocolno);
                protoQueryReqDto.setProtostatus("1");
                protoQueryReqDto.setPayeraccno(javaDict.getString("payeraccno"));
                try {
                    YuinResultDto resultDto = this.paySignClient.protoQuery(protoQueryReqDto);
                    if (resultDto.getBody() == null) {
                        javaDict.set("respstatus", (Object)"0");
                        javaDict.set("rejectcode", (Object)"RJ06");
                        javaDict.set("rejectreason", (Object)"\u534f\u8bae\u53f7\u4e0d\u5b58\u5728");
                        return YuinResult.newFailureResult((String)"E1802", (String)PayErrorCode.getErrmsg((String)"E1802"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return YuinResult.newSuccessResult(null);
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult chkBUPProtocol(JavaDict javaDict) {
        try {
            if ("CE02".equals(javaDict.get("checkflag", (Object)""))) {
                javaDict.set("confirmflag", (Object)"0");
                javaDict.set("rejectcode", (Object)"RJ06");
                javaDict.set("rejectreason", (Object)"\u4e0d\u652f\u6301\u672a\u6838\u9a8c\u6838\u9a8c\u6807\u8bc6");
                javaDict.set("addinfo", (Object)"\u62d2\u7edd\u4ed8\u6b3e");
                return YuinResult.newFailureResult((String)"E1809", (String)PayErrorCode.getErrmsg((String)"E1809"));
            }
            if ("CE01".equals(javaDict.get("checkflag", (Object)""))) {
                return YuinResult.newSuccessResult(null);
            }
            if ("beps.384.001.01".equals(javaDict.get("msgtype")) || "beps.386.001.01".equals(javaDict.get("msgtype")) || "beps.382.001.01".equals(javaDict.get("msgtype"))) {
                String protocolno = javaDict.getString("protocolno");
                String prototype = javaDict.getString("prototype");
                String protobank = javaDict.getString("protobank");
                ProtoQueryReqDto protoQueryReqDto = new ProtoQueryReqDto();
                protoQueryReqDto.setSysid("UPP");
                protoQueryReqDto.setAppid("BEPS");
                protoQueryReqDto.setProtono(protocolno);
                protoQueryReqDto.setPrototype(prototype);
                protoQueryReqDto.setProtobank(protobank);
                YuinResultDto resultDto = this.paySignClient.protoQuery(protoQueryReqDto);
                if (resultDto.getBody() == null) {
                    return YuinResult.newFailureResult((String)"E1802", (String)PayErrorCode.getErrmsg((String)"E1802"));
                }
                Map map = (Map)resultDto.getBody();
                if (!"1".equals(map.get("protostatus"))) {
                    return YuinResult.newFailureResult((String)"E1803", (String)PayErrorCode.getErrmsg((String)"E1803"));
                }
            }
            JavaDict proDict = new JavaDict();
            proDict.set("workdate", javaDict.get("workdate"));
            proDict.set("sendclearbank", javaDict.get("sendclearbank"));
            proDict.set("protocolno", javaDict.get("protocolno"));
            proDict.set("payeraccno", javaDict.get("payeraccno"));
            proDict.set("payername", javaDict.get("payername"));
            proDict.set("payeename", javaDict.get("payeename"));
            proDict.set("amt", javaDict.get("amt"));
            proDict.set("busitype", javaDict.get("busitype"));
            proDict.set("busikind", javaDict.get("busikind"));
            if ("UPP15021".equals(javaDict.get("tradecode"))) {
                javaDict.set("__stepaddflag__", (Object)"1");
            } else if ("UPP15031".equals(javaDict.get("tradecode"))) {
                javaDict.set("__stepaddflag__", (Object)"3");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"E1899", (String)PayErrorCode.getErrmsg((String)"E1899"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult protoColChk(JavaDict javaDict) {
        try {
            JavaDict protoInfo;
            List<String> listPara = Arrays.asList("workdate", "sendclearbank", "protocolno", "payeraccno", "payername", "payeename", "amt", "busitype", "busikind");
            List<String> listParaStr = Arrays.asList("\u4ea4\u6613\u65e5\u671f", "\u53d1\u8d77\u884c", "\u534f\u8bae\u53f7", "\u4ed8\u6b3e\u4eba\u8d26\u53f7", "\u4ed8\u6b3e\u4eba\u540d\u79f0", "\u6536\u6b3e\u4eba\u540d\u79f0", "\u4ea4\u6613\u91d1\u989d", "\u4e1a\u52a1\u7c7b\u578b", "\u4e1a\u52a1\u79cd\u7c7b");
            for (int i = 0; i < listPara.size(); ++i) {
                if (javaDict.hasKey(listPara.get(i))) continue;
                String errorMsg = String.format("E1830\uff1a%s-%s", listPara.get(i), listParaStr.get(i));
                return YuinResult.newFailureResult((String)"E1830", (String)errorMsg);
            }
            JavaDict tmpDict = new JavaDict();
            List<JavaDict> list = Arrays.asList(tmpDict);
            if (list.size() <= 0) {
                return YuinResult.newFailureResult((String)"E1831", (String)PayErrorCode.getErrmsg((String)"E1831"));
            }
            if (list.size() > 1) {
                String errorMsg = String.format("\u5b58\u5728%s\u6761\u751f\u6548\u534f\u8bae\uff0c\u5f02\u5e38\u62d2\u7edd", list.size());
                YuinResult.newFailureResult((String)"E1832", (String)PayErrorCode.getErrmsgAdd((String)"E1832", (String)errorMsg));
            }
            if (!"1".equals((protoInfo = list.get(0)).get("protocolstatus"))) {
                return YuinResult.newFailureResult((String)"E1803", (String)PayErrorCode.getErrmsg((String)"E1803"));
            }
            if (!protoInfo.get("debtorname").equals(javaDict.get("payername"))) {
                return YuinResult.newFailureResult((String)"E1833", (String)PayErrorCode.getErrmsg((String)"E1833"));
            }
            if (!protoInfo.get("debtoraccno").equals(javaDict.get("payeraccno"))) {
                return YuinResult.newFailureResult((String)"E1834", (String)PayErrorCode.getErrmsg((String)"E1834"));
            }
            if (!protoInfo.get("payeename").equals(javaDict.get("payeename"))) {
                return YuinResult.newFailureResult((String)"E1835", (String)PayErrorCode.getErrmsg((String)"E1835"));
            }
            if (!protoInfo.get("paycode").toString().contains(javaDict.get("busikind").toString())) {
                return YuinResult.newFailureResult((String)"E1836", (String)PayErrorCode.getErrmsg((String)"E1836"));
            }
            if (protoInfo.get("oncedlimit") != null && Integer.parseInt(javaDict.get("amt").toString()) > Integer.parseInt(protoInfo.get("oncedlimit").toString())) {
                return YuinResult.newFailureResult((String)"E1837", (String)PayErrorCode.getErrmsg((String)"E1837"));
            }
            List<String> paramList = Arrays.asList("timeunit", "timestep", "amtlimit", "numlimit");
            List<String> paramStrList = Arrays.asList("\u6263\u6b3e\u65f6\u95f4\u5355\u4f4d", "\u6263\u6b3e\u65f6\u95f4\u6b65\u957f", "\u6263\u6b3e\u5468\u671f\u5185\u6263\u8d39\u9650\u989d", "\u6263\u6b3e\u5468\u671f\u5185\u9650\u5236\u7b14\u6570");
            for (int i = 0; i < paramList.size(); ++i) {
                if (protoInfo.get(paramList.get(i)) != null) continue;
                return YuinResult.newSuccessResult(null);
            }
            if ("TU00".equals(protoInfo.get("timeunit")) && "99".equals(protoInfo.get("timestep")) && "0".equals(protoInfo.get("amtlimit")) && "0".equals(protoInfo.get("numlimit"))) {
                return YuinResult.newSuccessResult(null);
            }
            String startDate = this.uppGetService.calcDate(javaDict.get("workdate").toString(), protoInfo.get("timeunit").toString(), Integer.parseInt(protoInfo.get("timestep").toString()));
            if (startDate.length() <= 0) {
                return YuinResult.newFailureResult((String)"E1838", (String)PayErrorCode.getErrmsg((String)"E1838"));
            }
            JavaDict tmpDict2 = new JavaDict();
            List<JavaDict> list2 = Arrays.asList(tmpDict2);
            if (list2.size() <= 0) {
                return YuinResult.newFailureResult((String)"E1839", (String)PayErrorCode.getErrmsg((String)"E1839"));
            }
            String totalnum = list2.get(0).getString("count");
            String totalamt = list2.get(0).getString("totalamt");
            if (Integer.parseInt(totalnum) + 1 > Integer.parseInt(protoInfo.get("numlimit").toString())) {
                return YuinResult.newFailureResult((String)"E1840", (String)PayErrorCode.getErrmsg((String)"E1840"));
            }
            if (Integer.parseInt(totalamt) + Integer.parseInt(javaDict.get("amt").toString()) > Integer.parseInt(protoInfo.get("amtlimit").toString())) {
                return YuinResult.newFailureResult((String)"E1841", (String)PayErrorCode.getErrmsg((String)"E1841"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"E1842", (String)PayErrorCode.getErrmsg((String)"E1842"));
        }
        return YuinResult.newSuccessResult(null);
    }
}

