/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g70;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g70.UPP70064SubService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.HostProcService;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.chnlreq.ChnlReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.chnlreq.inter.IChnlReqTradeMethod;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ETradeBusiStep;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.constant.ErrorCode;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UPP70064Service
implements IChnlReqTradeMethod {
    @Resource
    private UPP70064SubService upp70064SubService;
    @Autowired
    private TradeOperDbService tradeOperDbService;
    @Autowired
    private OrigInfoService origInfoService;
    @Resource
    private HostProcService hostProcService;
    @Autowired
    private ChnlReqFlowService chnlReqFlowService;

    public ResponseEntity tradeFlow(Map<String, Object> requestMap) {
        return this.chnlReqFlowService.tradeExec(requestMap, (IChnlReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        JavaDict originfo = new JavaDict();
        YuinResult origInfoMap = this.origInfoService.getOrigInfoMap(request, originfo);
        if (!origInfoMap.success()) {
            return YuinResult.newFailureResult((String)"E1412", (String)ErrorCode.getErrmsg((String)"E1412"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        if ("1".equals(request.getString("revflag")) || "06".equals(request.getString("tradebusistep"))) {
            return YuinResult.newFailureResult((String)"E9999", (String)"\u539f\u4e1a\u52a1\u5df2\u51b2\u6b63\u6210\u529f,\u4e0d\u5141\u8bb8\u91cd\u590d\u51b2\u6b63");
        }
        YuinResult result = this.upp70064SubService.getHostDt(request);
        if (!result.success()) {
            return YuinResult.newFailureResult((String)"E2999", (String)PayErrorCode.getErrmsg((String)"E2032"));
        }
        if (request.hasKey("dt") && request.hasKey("origbankrspdate")) {
            if (request.getString("dt").equals(request.getString("origbankrspdate"))) {
                request.set("islastday", (Object)"0");
            } else {
                request.set("islastday", (Object)"1");
            }
        } else {
            return YuinResult.newFailureResult((String)"E9999", (String)"\u539f\u4e1a\u6263\u8d26\u672a\u6210\u529f,\u65e0\u9700\u51b2\u6b63");
        }
        result = this.upp70064SubService.check(request);
        if (!result.success()) {
            return result;
        }
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result = YuinResult.newSuccessResult(null);
        if ("000000".equals(request.getString("bankerrcode"))) {
            request.set("revflag", (Object)"1");
            request.set("busistatus", (Object)"0");
            request.set("reserved1", (Object)"\u624b\u5de5\u62b9\u8d26");
            request.set("tradebusistep", (Object)ETradeBusiStep.TRADEBUSISTEP_REVERSE.getCode());
        } else {
            request.set("revflag", (Object)"0");
            request.set("busistatus", (Object)"0");
            request.set("reserved1", (Object)"\u624b\u5de5\u62b9\u8d26\u5931\u8d25");
            request.set("tradebusistep", (Object)ETradeBusiStep.TRADEBUSISTEP_REFUSE.getCode());
        }
        try {
            YuinResultDto resultDto = this.tradeOperDbService.operDbaction(request, request.getString("sysid"), request.getString("appid"), request.getString("__udp_tranjnl_revflag__"));
            if (!resultDto.isSuccess()) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u52a8\u6001\u6570\u636eactionkey\u64cd\u4f5c\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

