/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.IDict;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.TradeInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPInitadmService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import cn.com.yusys.yusp.pay.common.busideal.flow.domain.tools.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15031Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private BepsChkService bepsChkService;
    @Autowired
    private UpPInitadmService upPInitadmService;
    @Resource
    private TradeInitService tradeInitService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.corpReqFlowService.tradeExec(requestMap, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        YuinResult result = this.uppGetService.getDictMap(request, "sysid,appid,#getAddflag,#M,tradecode,recvtype", "addflag");
        if (!result.success()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        if (!"0".equals(request.getString("addflag"))) {
            try {
                LogUtils.printInfo((Object)this, (String)"UPP15031\u4ea4\u6613\u6839\u636eappflag\u91cd\u65b0\u521d\u59cb\u5316\u4fe1\u606f", (Object[])new Object[0]);
                JavaDict tradeValue = this.upPInitadmService.initAdmin(request, request.getString("sysid"), request.getString("appid"), request.getString("tradecode"), "UPP15031", "PUB", request.getString("addflag"), Boolean.FALSE);
                request.set((IDict)tradeValue);
                request.set((IDict)Tools.dealKeyValue((Object)this, (JavaDict)tradeValue));
            }
            catch (Exception e) {
                return YuinResult.newFailureResult((String)"S9002", (String)"\u6839\u636eaddflag\u521d\u59cb\u5316\u5f02\u5e38");
            }
        }
        YuinResult result = new YuinResult();
        switch (addflag) {
            case "1": {
                result = this.pubInitService.getBrnoInfo(request);
                if (!result.success()) {
                    return result;
                }
                List<String> inParam = Arrays.asList("#1", "msgid");
                List<String> outParam = Arrays.asList("busidate", "__submsgid__");
                result = this.uppInitService.initInBusinessDate(request, inParam, outParam);
                if (!result.success()) {
                    return result;
                }
                String[] bankStrArr = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
                String[] bankNameStrArr = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
                try {
                    result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
                    if (!result.success()) {
                        return result;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
                }
            }
            case "2": {
                result = this.pubInitService.getBrnoInfo(request);
                if (!result.success()) {
                    return result;
                }
                List<String> inParam_2 = Arrays.asList("#1", "msgid");
                List<String> outParam_2 = Arrays.asList("busidate", "__submsgid__");
                result = this.uppInitService.initInBusinessDate(request, inParam_2, outParam_2);
                if (!result.success()) {
                    return result;
                }
                String[] bankStrArr_2 = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
                String[] bankNameStrArr_2 = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
                try {
                    result = this.upPBankinfoService.getBankName(request, bankStrArr_2, bankNameStrArr_2);
                    if (!result.success()) {
                        return result;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
                }
            }
        }
        if (!result.success()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        String addflag = request.getString("addflag");
        YuinResult result = new YuinResult();
        switch (addflag) {
            case "1": {
                result = this.uppChkService.chkVerifierResult(request);
                if (result.success()) break;
                return result;
            }
            case "2": {
                result = this.uppChkService.chkVerifierResult(request);
                if (result.success()) break;
                return result;
            }
        }
        result = this.bepsChkService.chkBUPProtocol(request);
        if (!result.success()) {
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
            request.set("__hostcommflag__", (Object)"0");
            return YuinResult.newSuccessResult(null);
        }
        result = this.uppChkService.chkVerifierResult(request);
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        if (!"1".equals(request.get("__stepstatus__"))) {
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

