/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15.UPP15051Service;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15022Service
implements ICorpReqTradeMethod {
    @Autowired
    UPP15051Service upp15051Service;
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UPPChkService uppChkService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.corpReqFlowService.tradeExec(requestMap, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u63a5\u6536\u884c\u5bf9\u5e94\u673a\u6784\u53f7getBrnoInfo", (Object[])new Object[0]);
        YuinResult result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        return result;
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        String[] inParam = new String[]{"amt", "feeamt"};
        String[] outParam = new String[]{"realtradeamt"};
        LogUtils.printInfo((Object)this, (String)"\u5b9e\u9645\u4ea4\u6613\u91d1\u989d\u83b7\u53d6getRealTradeAmt", (Object[])new Object[0]);
        YuinResult result = this.uppGetService.getRealTradeAmt(request, inParam, outParam);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u7f51\u70b9\u53f7getBrnoInfo", (Object[])new Object[0]);
        result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        String[] bankStrArr = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
        String[] bankNameStrArr = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
        try {
            LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u884c\u540dgetBankName", (Object[])new Object[0]);
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u62a5\u6587\u7b7e\u540d\u9a8c\u8bc1 chkVerifierResult", (Object[])new Object[0]);
        YuinResult result = this.uppChkService.chkVerifierResult(request);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        JavaDict hostAcctRsp;
        request.set("status", (Object)"0");
        if (request.hasKey("__host_acct_rsp__") && "000000".equals((hostAcctRsp = (JavaDict)request.get("__host_acct_rsp__")).get("rtncode"))) {
            request.set("status", (Object)"1");
        }
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u6b65\u9aa4\u72b6\u6001", (Object[])new Object[0]);
        YuinResult result = this.uppGetService.getDictMap(request, "sysid,appid,#getRespStatus,#M,msgtype,status", "respstatus");
        return result;
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

