/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15.UPP15051Service;
import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g15.UPP15021SubService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.DataProcService;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15021Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private UPP15021SubService upp15021SubService;
    @Autowired
    private BepsChkService bepsChkService;
    @Autowired
    private UPP15051Service upp15051Service;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private DataProcService dataProcService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.corpReqFlowService.tradeExec(requestMap, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6addflag", (Object[])new Object[0]);
        YuinResult result = this.uppGetService.getDictMap(request, "sysid,appid,#getAddflag,#M,#UPP15021,msgtype", "addflag");
        if (request.hasKey("addflag")) {
            if ("1".equals(request.getString("addflag"))) {
                request.set("__sendmsgtype__", (Object)"beps.385.001.01");
            } else if ("2".equals(request.getString("addflag"))) {
                request.set("__sendmsgtype__", (Object)"beps.385.001.02");
            }
        }
        return result;
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u8d26\u52a1\u573a\u666fgetAcctScne", (Object[])new Object[0]);
        YuinResult result = this.upp15021SubService.getAcctScne(request);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u7f51\u70b9\u53f7getBrnoInfo", (Object[])new Object[0]);
        result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        String[] bankStrArr = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
        String[] bankNameStrArr = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
        try {
            LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u884c\u540dgetBankName", (Object[])new Object[0]);
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        LogUtils.printInfo((Object)this, (String)"\u62a5\u6587\u7c7b\u578b\u6620\u5c04getMsgtypeMap", (Object[])new Object[0]);
        result = this.uppGetService.getMsgtypeMap(request);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        request.set("totalamt", (Object)request.getString("amt"));
        LogUtils.printInfo((Object)this, (String)"\u6821\u9a8c\u4ed8\u6b3e\u534f\u8baechkBUPProtocol", (Object[])new Object[0]);
        YuinResult result = this.bepsChkService.chkBUPProtocol(request);
        if (!result.success()) {
            request.remove("__packrule__");
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
            request.set("__hostcommflag__", (Object)"0");
            try {
                LogUtils.printInfo((Object)this, (String)"\u66f4\u65b0\u6d41\u6c34\u8868\u6b65\u9aa4updMainjnlByStepCtrl", (Object[])new Object[0]);
                result = this.dataProcService.updMainjnlByStepCtrl(request);
            }
            catch (Exception e) {
                e.printStackTrace();
                return result;
            }
            return YuinResult.newSuccessResult(null);
        }
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        if (!"1".equals(request.get("__stepstatus__"))) {
            request.remove("__packrule__");
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

