/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPMapService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.BatchReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.inter.IBatchReqTradeMethod;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15014Service
implements IBatchReqTradeMethod {
    @Autowired
    private BatchReqFlowService batchReqFlowService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private TradeStatusService tradeStatusService;
    @Resource
    private TradeOperDbService tradeOperDbService;
    @Autowired
    private UPPMapService uppMapService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.batchReqFlowService.tradeExec(requestMap, (IBatchReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u7f51\u70b9\u53f7getBrnoInfo", (Object[])new Object[0]);
        YuinResult result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u884c\u540dgetBankName", (Object[])new Object[0]);
        String[] bankStrArr = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payerclearbank", "payeraccbank", "payeebank", "payeeclearbank", "payeeaccbank"};
        String[] bankNameStrArr = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payerclearbankname", "payeraccbankname", "payeebankname", "payeeclearbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        try {
            LogUtils.printInfo((Object)this, (String)"\u66f4\u65b0\u4e1a\u52a1\u6b65\u9aa4updateTradeStep", (Object[])new Object[0]);
            result = this.tradeStatusService.updateTradeStep(request, request.getString("tradebusistep"), request.getString("__stepstatus__"));
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

