/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsBatService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsChkService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeOperDbService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.BatchReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.inter.IBatchReqTradeMethod;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UPP15012Service
implements IBatchReqTradeMethod {
    @Resource
    TradeOperDbService tradeOperDbService;
    @Autowired
    private BatchReqFlowService batchReqFlowService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private BepsChkService bepsChkService;
    @Resource
    private BepsBatService bepsBatService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;

    public ResponseEntity tradeFlow(Map<String, Object> requestMap) {
        return this.batchReqFlowService.tradeExec(requestMap, (IBatchReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u884c\u540dgetBankName", (Object[])new Object[0]);
        String[] bankStrArr = new String[]{"payeebank", "sendbank", "payerbank", "recvbank", "recvclearbank", "payerclearbank", "sendclearbank", "payeeclearbank"};
        String[] bankNameStrArr = new String[]{"payeebankname", "sendbankname", "payerbankname", "recvbankname", "recvclearbankname", "payerclearbankname", "sendclearbankname", "payeeclearbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u6821\u9a8c\u4ed8\u6b3e\u534f\u8baechkBUPProtocol", (Object[])new Object[0]);
        YuinResult result = this.bepsChkService.chkBUPProtocol(request);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u6821\u9a8c\u4ed8\u6b3e\u534f\u8baechkDSFProtocol", (Object[])new Object[0]);
        result = this.bepsChkService.chkDSFProtocol(request);
        if (!result.success()) {
            request.remove("__packrule__");
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
            request.set("__hostcommflag__", (Object)"0");
            return YuinResult.newSuccessResult(null);
        }
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDealHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u6279\u91cf\u4ee3\u4ed8\u843d\u5730\uff08\u4ed8\u6b3e\u884c\uff09batchDown_15012", (Object[])new Object[0]);
        this.bepsBatService.batchDown_15012(request);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        if (!"1".equals(request.get("__stepstatus__"))) {
            request.remove("__packrule__");
            request.set("__sendmsgtype__", (Object)"beps.388.001.01");
            request.set("sendmsgtype", (Object)"beps.388.001.01");
        } else {
            try {
                this.tradeOperDbService.operDbaction(request, request.get("sysid").toString(), request.get("appid").toString(), "map_ctlacct");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

