/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsBatService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPInitService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.BatchReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.inter.IBatchReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15005Service
implements IBatchReqTradeMethod {
    @Autowired
    private BatchReqFlowService batchReqFlowService;
    @Autowired
    private UPPInitService uppInitService;
    @Autowired
    private UPPGetService uppGetService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Autowired
    private BepsChkService bepsChkService;
    @Autowired
    private BepsBatService bepsBatService;
    @Autowired
    private UPPChkService uppChkService;
    @Autowired
    private TradeStatusService tradeStatusService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.batchReqFlowService.tradeExec(requestMap, (IBatchReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        List<String> inParam = Arrays.asList("msgid");
        List<String> outParam = Arrays.asList("busidate");
        YuinResult result = this.uppInitService.rInitInBusinessDate(request, inParam, null);
        if (!result.success()) {
            return result;
        }
        List<String> inParam2 = Arrays.asList("#1", "msgid", "pkgdate");
        List<String> outParam2 = Arrays.asList("pkgdate", "__submsgid__");
        result = this.uppInitService.initInBusinessDate(request, inParam2, outParam2);
        if (!result.success()) {
            return result;
        }
        result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        String[] bankStrArr = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payerclearbank", "payeraccbank", "payeebank", "payeeclearbank", "payeeaccbank"};
        String[] bankNameStrArr = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payerclearbankname", "payeraccbankname", "payeebankname", "payeeclearbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = this.bepsChkService.chkDSFProtocol(request);
        if (!result.success()) {
            return result;
        }
        return result;
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDealHandler(JavaDict request) {
        this.bepsBatService.BatReqDown(request);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

