/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g15;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.PubInitService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UPP15002Service
implements ICorpReqTradeMethod {
    @Autowired
    private CorpReqFlowService corpReqFlowService;
    @Autowired
    private PubInitService pubInitService;
    @Autowired
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private TradeStatusService tradeStatusService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.corpReqFlowService.tradeExec(requestMap, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = this.pubInitService.getBrnoInfo(request);
        if (!result.success()) {
            return result;
        }
        String[] inParam = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payerclearbank", "payeraccbank", "payeebank", "payeeclearbank", "payeeaccbank"};
        String[] outParam = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payerclearbankname", "payeraccbankname", "payeebankname", "payeeclearbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, inParam, outParam);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return result;
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        String eventId = request.getString("__biz_upd_tranjnl__");
        try {
            this.tradeStatusService.updateTradeStep(request, request.getString("tradebusistep"), request.getString("__stepstatus__"));
        }
        catch (Exception e) {
            LogUtils.printError((Object)this, (String)"\u6570\u636e\u53d8\u66f4\u5931\u8d25", (Object[])new Object[]{e});
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

