/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g04;

import cn.com.yusys.yusp.pay.center.beps.domain.constant.PayErrorCode;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsBatService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.BepsPkgService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.common.base.component.dboper.service.TradeStatusService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.base.util.LogUtils;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.chnlreq.ChnlReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.chnlreq.inter.IChnlReqTradeMethod;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UPP04014Service
implements IChnlReqTradeMethod {
    @Resource
    private ChnlReqFlowService chnlReqFlowService;
    @Resource
    private BepsBatService bepsBatService;
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private BepsChkService bepsChkService;
    @Resource
    private TradeStatusService tradeStatusService;
    @Resource
    private BepsPkgService bepsPkgService;
    @Resource
    private UpPBankinfoService upPBankinfoService;

    public ResponseEntity tradeFlow(Map<String, Object> requestMap) {
        return this.chnlReqFlowService.tradeExec(requestMap, (IChnlReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        LogUtils.printInfo((Object)this, (String)"\u83b7\u53d6\u4e00\u4e8c\u4ee3\u62a5\u6587\u6620\u5c04\u7c7b\u578b", (Object[])new Object[0]);
        result = this.uppGetService.getMsgtypeMap(request);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u884c\u53f7\u83b7\u53d6\u884c\u540d", (Object[])new Object[0]);
        String[] bankStrArr = new String[]{"recvbank", "payerbank", "payeraccbank"};
        String[] bankNameStrArr = new String[]{"recvbankname", "payerbankname", "payeraccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankStrArr, bankNameStrArr);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return YuinResult.newFailureResult((String)"S9002", (String)PayErrorCode.getErrmsg((String)"S9002"));
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        LogUtils.printInfo((Object)this, (String)"\u884c\u5185\u4ea4\u6613\u4e1a\u52a1\u6743\u9650\u68c0\u67e5", (Object[])new Object[0]);
        result = this.uppChkService.chkBankTranAuth(request);
        if (!result.success()) {
            return result;
        }
        LogUtils.printInfo((Object)this, (String)"\u4e1a\u52a1\u6743\u9650\u68c0\u67e5", (Object[])new Object[0]);
        result = this.uppChkService.chkBEPTranAuth(request);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        YuinResult result = null;
        try {
            LogUtils.printInfo((Object)this, (String)"\u72b6\u6001\u66f4\u65b0", (Object[])new Object[0]);
            result = this.tradeStatusService.updateTradeStep(request, request.getString("tradebusistep"), request.getString("__stepstatus__"));
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        LogUtils.printInfo((Object)this, (String)"\u5c0f\u989d\u7ec4\u5305\u53d1\u9001\u7b2c\u4e09\u65b9", (Object[])new Object[0]);
        this.bepsPkgService.chkAndDealBepsCorpCom(request);
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

