/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g01;

import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g01.UPP01064SubService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.busideal.component.business.service.OrigInfoService;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.CorpReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.corpreq.inter.ICorpReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UPP01064Service
implements ICorpReqTradeMethod {
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private OrigInfoService origInfoService;
    @Resource
    private UPP01064SubService upp01064SubService;
    @Resource
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private CorpReqFlowService corpReqFlowService;

    public void tradeFlow(Map<String, Object> requestMap) {
        this.corpReqFlowService.tradeExec(requestMap, (ICorpReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = null;
        result = this.uppGetService.getRealTradeAmt(request, new String[]{"amt", "feeamt"}, new String[]{"realtradeamt"});
        if (!result.success()) {
            return result;
        }
        JavaDict origInfo = new JavaDict();
        result = this.origInfoService.getOrigInfoMap(request, origInfo);
        if (!result.success()) {
            return result;
        }
        try {
            String[] bankNo1 = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payerbank", "payeeclearbank", "payeebank", "payerclearbank", "payeraccbank", "payeeaccbank"};
            String[] bankName = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payeeclearbankname", "payeebankname", "payerclearbankname", "payeraccbankname", "payeeaccbankname"};
            result = this.upPBankinfoService.getBankName(request, bankNo1, bankName);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        YuinResult result = null;
        List<String> inCommonParam = Arrays.asList("detailflag:#0:\u91cd\u590d\u7684\u4e1a\u52a1\u4e0d\u5904\u7406");
        result = this.uppChkService.chkCompValue(request, inCommonParam);
        if (!result.success()) {
            return result;
        }
        result = this.upp01064SubService.updMainJnl01064(request);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

