/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.beps.application.service.upp.g01;

import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPChkService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.pub.UPPGetService;
import cn.com.yusys.yusp.pay.center.beps.domain.service.upp.g01.UPP01062SubService;
import cn.com.yusys.yusp.pay.common.base.dto.YuinResult;
import cn.com.yusys.yusp.pay.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.pay.common.busideal.component.parm.service.UpPBankinfoService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.BatchReqFlowService;
import cn.com.yusys.yusp.pay.common.busideal.flow.application.service.batch.inter.IBatchReqTradeMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UPP01062Service
implements IBatchReqTradeMethod {
    @Resource
    private UPPGetService uppGetService;
    @Resource
    private UPPChkService uppChkService;
    @Resource
    private UpPBankinfoService upPBankinfoService;
    @Resource
    private UPP01062SubService upp01062SubService;
    @Resource
    private BatchReqFlowService batchReqFlowService;

    public ResponseEntity tradeFlow(Map<String, Object> requestMap) {
        return this.batchReqFlowService.tradeExec(requestMap, (IBatchReqTradeMethod)this);
    }

    public YuinResult getSysInitRepHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeInitHandler(JavaDict request) {
        YuinResult result = this.uppGetService.getRealTradeAmt(request, new String[]{"amt", "feeamt"}, new String[]{"realtradeamt"});
        if (!result.success()) {
            return result;
        }
        String[] bankNo = new String[]{"sendbank", "sendclearbank", "recvbank", "recvclearbank", "payeraccbank", "sendclearbank", "payeeaccbank", "recvclearbank", "payeraccbank", "payeeaccbank"};
        String[] bankName = new String[]{"sendbankname", "sendclearbankname", "recvbankname", "recvclearbankname", "payerbankname", "payeeclearbankname", "payeebankname", "payerclearbankname", "payeraccbankname", "payeeaccbankname"};
        try {
            result = this.upPBankinfoService.getBankName(request, bankNo, bankName);
            if (!result.success()) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> constList = Arrays.asList("appid", "sysid", "payerbank");
        result = this.uppGetService.getBankBrnoInfo(request, constList);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getTradeChkHandler(JavaDict request) {
        List<String> inParam = Arrays.asList("detailflag:#0:\u91cd\u590d\u7684\u4e1a\u52a1\u4e0d\u5904\u7406");
        YuinResult result = this.uppChkService.chkCompValue(request, inParam);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getSubTradeDisHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult dataDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getHostComAftDealHandler(JavaDict request) {
        YuinResult result = this.upp01062SubService.dataProcess01062(request);
        if (!result.success()) {
            return result;
        }
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getCorpComAftDealHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }

    public YuinResult getExceptProcAfterHandler(JavaDict request) {
        return YuinResult.newSuccessResult(null);
    }
}

