/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.ability.domain.service.func;

import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.pay.center.ability.domain.constant.EComOutType;
import cn.com.yusys.yusp.pay.center.ability.domain.repo.data.CheckRepo;
import cn.com.yusys.yusp.pay.center.ability.domain.repo.data.ExchangeRepo;
import cn.com.yusys.yusp.pay.center.ability.domain.repo.data.ReqPackRepo;
import cn.com.yusys.yusp.pay.center.ability.domain.repo.data.RespUnpackRepo;
import cn.com.yusys.yusp.pay.center.ability.domain.repo.data.SaveRepo;
import cn.com.yusys.yusp.pay.center.ability.domain.repo.data.UpPOuttrademapRepo;
import cn.com.yusys.yusp.pay.center.ability.domain.vo.UpPOuttrademapVo;
import cn.com.yusys.yusp.payment.common.base.dto.ReqCommInfo;
import cn.com.yusys.yusp.payment.common.base.dto.RspCommInfo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.util.YuinLogUtils;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public abstract class ChannelOutService {
    private static final Logger logger = LoggerFactory.getLogger(ChannelOutService.class);
    @Autowired
    public ApplicationContext applicationContext;
    @Autowired
    public UpPOuttrademapRepo uiPOuttrademapRepo;
    @Autowired
    private SaveRepo saveRepo;
    @Autowired
    private ReqPackRepo reqPackRepo;
    @Autowired
    private CheckRepo checkRepo;
    @Autowired
    private RespUnpackRepo respUnpackRepo;
    @Autowired
    private ExchangeRepo exchangeRepo;

    public RspCommInfo outExchange(ReqCommInfo hostReqCommInfo, UpPOuttrademapVo uiPOuttrademapVo) throws Exception {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        YuinLogUtils.getInst((Object)this).info(EComOutType.MODULE_NAME.getCode() + EComOutType.START.getName());
        LocalDateTime startTime = LocalDateTime.now();
        String savetime = startTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        RspCommInfo rspCommInfo = new RspCommInfo();
        rspCommInfo.setErrcode("E8101");
        YuinResult result = null;
        String servicecode = hostReqCommInfo.getHostcommid();
        if (EComOutType.DISABLED_CODE.getCode().equals(uiPOuttrademapVo.getDisabled()) || EComOutType.STATUS.getCode().equals(uiPOuttrademapVo.getSvcstatus())) {
            rspCommInfo.setErrmsg(EComOutType.ERR_OUT_DISABLED.getName() + servicecode);
            return rspCommInfo;
        }
        int comtimeout = 60000;
        if (uiPOuttrademapVo.getComtimeout() != 0) {
            comtimeout = uiPOuttrademapVo.getComtimeout();
        }
        reqMap.put(EComOutType.TIME_OUT.getCode(), comtimeout);
        reqMap.put("send", JSONObject.toJSONString((Object)hostReqCommInfo.getSender()));
        reqMap.put("tradeDataMap", hostReqCommInfo.getSender());
        try {
            result = this.exchangeRepo.exchangeOutAdapter(reqMap, uiPOuttrademapVo);
        }
        catch (Exception e) {
            result = YuinResult.newFailureResult((String)"E8199", (String)EComOutType.ERR_OUT.getName());
            rspCommInfo.setErrcode("E8199");
            rspCommInfo.setErrmsg(EComOutType.ERR_OUT.getName());
        }
        if (!result.isSuccess()) {
            rspCommInfo.setErrmsg(result.getErrorMsg());
            return rspCommInfo;
        }
        if (result.isSuccess()) {
            result = this.respUnpackRepo.respUnpack(reqMap);
            if (result.isSuccess()) {
                String rtncode = reqMap.getOrDefault("transaction.header.status.retCd", "").toString();
                if (EComOutType.ERR_ESB_OUT.getCode().equals(rtncode) || EComOutType.ERR_ESB_100001.getCode().equals(rtncode) || EComOutType.ERR_ESB_300003.getCode().equals(rtncode)) {
                    rspCommInfo.setRecv(reqMap);
                    rspCommInfo.setErrcode("E8103");
                    rspCommInfo.setErrmsg(EComOutType.ERR_OUT_TIME.getName());
                } else {
                    rspCommInfo.setRecv(reqMap);
                    rspCommInfo.setErrcode(EComOutType.SUCCESS_CODE.getCode());
                    rspCommInfo.setErrmsg(EComOutType.SUCCESS_CODE.getName());
                }
            } else {
                rspCommInfo.setErrcode("E8102");
                rspCommInfo.setErrmsg(EComOutType.ERR_PACK.getName());
            }
        } else {
            rspCommInfo.setErrcode(result.getErrorCode());
            rspCommInfo.setErrmsg(result.getErrorMsg());
        }
        YuinLogUtils.getInst((Object)this).info(EComOutType.MODULE_NAME.getCode() + EComOutType.END.getName());
        return rspCommInfo;
    }

    private void setBspSession(Map<String, Object> attributes, String moduleCode) {
        Session session = (Session)attributes.get(EComOutType.T_SESSION.getCode());
        String startWithCommOut = EComOutType.COMM_OUT.getCode() + moduleCode;
        if (session == null) {
            session = new Session();
            session.setModuleName(startWithCommOut);
            session.setContext(attributes);
            session.getContext().put(EComOutType.T_SESSION.getCode(), session);
        }
    }

    public static void main(String[] args) {
        LocalDateTime startTime = LocalDateTime.now();
        System.out.println(startTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }
}

