/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.center.ability.domain.repo.data;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.pay.center.ability.domain.constant.EComOutType;
import cn.com.yusys.yusp.pay.center.ability.domain.vo.UpPOuttrademapVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public abstract class ExchangeRepo {
    @Value(value="${front.datatype:/channelin_topin/upp_esb/}")
    private String url;
    private static final Logger logger = LoggerFactory.getLogger(ExchangeRepo.class);

    public YuinResult exchangeOutAdapter(Map<String, Object> info, UpPOuttrademapVo uiPOuttrademapVo) throws Exception {
        try {
            if (StringUtils.isNotEmpty((String)uiPOuttrademapVo.getSvcurl())) {
                info.put(EComOutType.OUT_URL.getCode(), uiPOuttrademapVo.getSvcurl());
            } else {
                info.put(EComOutType.OUT_URL.getCode(), this.url);
            }
            Map objectMap = BspTemplate.exchange((String)uiPOuttrademapVo.getComsvctype(), null, info);
            info.putAll(objectMap);
            return YuinResult.newSuccessResult((Object[])new Object[]{objectMap});
        }
        catch (Exception e) {
            String errcode = info.getOrDefault("G_RET_CODE", "E8199").toString();
            e.printStackTrace();
            String message = e.getMessage();
            if (message.contains("timed out")) {
                return YuinResult.newFailureResult((String)"E8103", (String)EComOutType.ERR_OUT_TIME.getName());
            }
            return YuinResult.newFailureResult((String)"E8199", (String)EComOutType.ERR_OUT.getName());
        }
    }
}

